/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class TileEntityDecoTank
extends TileEntityBase {
    private Fluid f;
    private boolean[] flags = new boolean[TankFlags.list.length];

    public Block getTileEntityBlockID() {
        return BlockRegistry.DECOTANK.getBlockInstance();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    protected String getTEName() {
        return BlockRegistry.DECOTANK.getBlockInstance().func_149732_F();
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)this.f);
        NBT.func_74768_a("flags", ReikaArrayHelper.booleanToBitflags((boolean[])this.flags));
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        this.flags = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("flags"), (int)TankFlags.list.length);
    }

    public Fluid getFluid() {
        return this.f;
    }

    public boolean canUpdate() {
        return false;
    }

    public void setLiquid(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74762_e("level") >= 25) {
            this.f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
        }
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public boolean getFlag(TankFlags flag) {
        return this.flags[flag.ordinal()];
    }

    public int getFlags() {
        int meta = 0;
        for (int k = 0; k < TankFlags.list.length; ++k) {
            TankFlags f = TankFlags.list[k];
            if (!this.getFlag(f)) continue;
            meta |= f.getItemMetadataBit();
        }
        return meta;
    }

    public void setFlags(ItemStack stack) {
        for (int k = 0; k < TankFlags.list.length; ++k) {
            TankFlags f = TankFlags.list[k];
            if (!f.apply(stack)) continue;
            this.flags[k] = true;
        }
        this.syncAllData(false);
    }

    public static enum TankFlags {
        CLEAR("Clear Glass", new ItemStack(Blocks.field_150410_aZ)),
        NOCOLOR("Ignore Fluid Color", new ItemStack(Items.field_151100_aR, 1, Short.MAX_VALUE)),
        LIGHTED("Glowing", new ItemStack(Items.field_151114_aO)),
        RESISTANT("Resistant", new ItemStack(Blocks.field_150343_Z));

        public final String displayName;
        private final ItemStack toggleFlag;
        public static final TankFlags[] list;

        private TankFlags(String s, ItemStack is) {
            this.displayName = s;
            this.toggleFlag = is;
        }

        public boolean toggle(InventoryCrafting ics) {
            for (int i = 0; i < ics.func_70302_i_(); ++i) {
                ItemStack in = ics.func_70301_a(i);
                if (!this.isItem(in)) continue;
                return true;
            }
            return false;
        }

        public boolean isItem(ItemStack is) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.toggleFlag);
        }

        public boolean apply(IBlockAccess world, int x, int y, int z) {
            TileEntityDecoTank te = (TileEntityDecoTank)world.func_147438_o(x, y, z);
            return te != null && te.getFlag(this);
        }

        public boolean apply(ItemStack item) {
            return this.applyItem(item.func_77960_j());
        }

        public boolean applyItem(int meta) {
            return (meta & this.getItemMetadataBit()) != 0;
        }

        public int getItemMetadataBit() {
            return 1 << this.ordinal();
        }

        static {
            list = TankFlags.values();
        }
    }
}

