/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiBlockMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.SodiumSolarUpgrades;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityMirror;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySolar
extends TileEntityIOMachine
implements MultiBlockMachine,
SimpleProvider,
PipeConnector,
PowerGenerator,
IFluidHandler {
    private BlockArray solarBlocks = new BlockArray();
    private final StepTimer mirrorTimer = new StepTimer(100);
    private int numberMirrors = 0;
    private float lightMultiplier = 0.0f;
    private float overallBrightness;
    private int size;
    private int topLocation = -1;
    public static final int GENOMEGA = 512;
    public static final int GENOMEGA_SODIUM = 4096;
    public static final int MAXTORQUE = 16384;
    public static final int MAXTORQUE_SODIUM = 65536;
    private final HybridTank tank = new HybridTank("solar", 4000);

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SOLARTOWER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        SodiumSolarUpgrades.SodiumSolarReceiver ss;
        super.updateTileEntity();
        this.topLocation = this.getTopOfTower();
        this.size = this.getArraySize();
        this.overallBrightness = this.getArrayOverallBrightness();
        if (!world.field_72995_K) {
            int temp = (int)((float)(5 * this.size) * this.overallBrightness);
            for (int i = -3; i <= 3; ++i) {
                for (int j = -3; j <= 3; ++j) {
                    if (!ConfigRegistry.BLOCKDAMAGE.getState()) continue;
                    ReikaWorldHelper.temperatureEnvironment((World)world, (int)(x + i), (int)(y + 1), (int)(z + j), (int)Math.min(temp, 1750));
                    if (temp < 1500) continue;
                    this.delete();
                    world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
                }
            }
            if (temp > 400) {
                AxisAlignedBB above = AxisAlignedBB.func_72330_a((double)(x - 3), (double)(y + 1), (double)(z - 3), (double)(x + 4), (double)(y + 2), (double)(z + 4));
                List in = world.func_72872_a(EntityLivingBase.class, above);
                for (EntityLivingBase e : in) {
                    if (e.func_70644_a(Potion.field_76426_n)) continue;
                    e.func_70015_d(3);
                }
            }
        }
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a || MachineRegistry.getMachine((IBlockAccess)world, x, y - 1, z) != this.getMachine()) {
            this.generatePower(world, x, y, z);
        } else {
            this.write = null;
        }
        if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a && !(world.func_147438_o(x, y + 1, z) instanceof SodiumSolarUpgrades)) {
            return;
        }
        TileEntity top = world.func_147438_o(x, this.topLocation + 1, z);
        if (top instanceof SodiumSolarUpgrades.SodiumSolarReceiver && (ss = (SodiumSolarUpgrades.SodiumSolarReceiver)top).isActive()) {
            ss.tick(this.size, this.overallBrightness);
        }
        this.mirrorTimer.update();
        if (this.mirrorTimer.checkCap() && this.solarBlocks.isEmpty()) {
            this.lightMultiplier = 0.0f;
            this.solarBlocks.recursiveAdd(world, x, y, z, this.getTileEntityBlockID());
            this.numberMirrors = this.solarBlocks.getSize();
            while (this.solarBlocks.getSize() > 0) {
                Coordinate c = this.solarBlocks.getNextAndMoveOn();
                MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord);
                if (m == MachineRegistry.MIRROR) {
                    TileEntityMirror te = (TileEntityMirror)world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    te.targetloc = new Coordinate(x, y, z);
                    float light = te.getLightLevel() * te.getAimingAccuracy();
                    this.lightMultiplier += light;
                    continue;
                }
                --this.numberMirrors;
            }
            this.lightMultiplier /= 15.0f;
            this.lightMultiplier /= (float)this.numberMirrors;
        }
        if (this.write != null) {
            this.basicPowerReceiver();
        }
    }

    private void generatePower(World world, int x, int y, int z) {
        this.getTowerWater(world, x, y, z);
        int amt = this.getConsumedWater();
        this.write = ForgeDirection.DOWN;
        boolean water = this.tank.getActualFluid() == FluidRegistry.WATER;
        this.omega = water ? 512 : 4096;
        this.torque = this.getGenTorque(world, x, y, z);
        if (this.size <= 0 || this.torque == 0 || this.tank.getLevel() < amt) {
            this.omega = 0;
            this.torque = 0;
        }
        this.power = (long)this.omega * (long)this.torque;
        if (this.tank.getActualFluid() == FluidRegistry.getFluid((String)"rc sodium")) {
            amt = (int)Math.max(1.0, (double)((long)amt * this.power) / 2.68435456E8);
        }
        if (this.power > 0L && this.tank.getLevel() > 0 && amt > 0) {
            SodiumSolarUpgrades.SodiumSolarOutput ss;
            TileEntity te;
            if (!water && (te = this.getAdjacentTileEntity(ForgeDirection.DOWN)) instanceof SodiumSolarUpgrades.SodiumSolarOutput && (ss = (SodiumSolarUpgrades.SodiumSolarOutput)te).isActive()) {
                amt = ss.receiveSodium(amt);
            }
            if (amt > 0) {
                this.tank.removeLiquid(amt);
            }
        }
    }

    private int getGenTorque(World world, int x, int y, int z) {
        if (this.tank.isEmpty()) {
            return 0;
        }
        boolean water = this.tank.getActualFluid() == FluidRegistry.WATER;
        int cap = water ? 16384 : 65536;
        float f = water ? 1.0f : 1.75f;
        float p = water ? 1.0f : 1.5f;
        return Math.min(cap, (int)((double)(f * this.overallBrightness * (float)Math.min(ReikaMathLibrary.ceil2exp((int)this.getTowerHeight()), 64)) * Math.pow(this.size + 1, p)));
    }

    public int getConsumedWater() {
        int base = 10 + 16 * ReikaMathLibrary.logbase2((long)this.power);
        int rnd = 10;
        if (base >= 1000) {
            rnd = 1000;
        } else if (base >= 100) {
            rnd = 100;
        }
        int ret = ReikaMathLibrary.roundUpToX((int)rnd, (int)base);
        if (this.tank.getActualFluid() == FluidRegistry.getFluid((String)"rc sodium")) {
            ret = (int)((double)ret * 0.015625);
        }
        return ret;
    }

    public int getTowerHeight() {
        return this.topLocation - this.field_145848_d;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean isMultiBlock(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public int[] getMultiBlockPosition(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public int[] getMultiBlockSize(World world, int x, int y, int z) {
        return null;
    }

    public int getArraySize() {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.topLocation, this.field_145849_e);
        if (tile == null) {
            return 0;
        }
        return ((TileEntitySolar)tile).numberMirrors;
    }

    public float getArrayOverallBrightness() {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.topLocation, this.field_145849_e);
        if (tile == null) {
            return 0.0f;
        }
        return ((TileEntitySolar)tile).lightMultiplier;
    }

    public int getTopOfTower() {
        int y = this.field_145848_d;
        while (MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.field_145851_c, y, this.field_145849_e) == MachineRegistry.SOLARTOWER) {
            ++y;
        }
        return y - 1;
    }

    public int getBottomOfTower() {
        int y = this.field_145848_d;
        while (MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.field_145851_c, y, this.field_145849_e) == MachineRegistry.SOLARTOWER) {
            --y;
        }
        return y + 1;
    }

    private void getTowerWater(World world, int x, int y, int z) {
        int lvl = this.tank.getLevel();
        Fluid f = this.tank.getActualFluid();
        int cy = y + 1;
        while (MachineRegistry.getMachine((IBlockAccess)world, x, cy, z) == MachineRegistry.SOLARTOWER) {
            TileEntitySolar tile = (TileEntitySolar)world.func_147438_o(x, cy, z);
            Fluid f2 = tile.tank.getActualFluid();
            if (f == null && f2 != null) {
                f = f2;
            }
            if (f2 != null && f.equals(f2)) {
                lvl += tile.tank.getLevel();
                tile.tank.empty();
            }
            ++cy;
        }
        this.tank.setContents(lvl, f);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return true;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return new PowerSourceList().addSource(this);
    }

    @Override
    public long getMaxPower() {
        return this.torque * this.omega;
    }

    @Override
    public long getCurrentPower() {
        return this.power;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.equals(FluidRegistry.WATER) || fluid.equals(FluidRegistry.getFluid((String)"rc sodium")) && this.canUseSodium();
    }

    private boolean canUseSodium() {
        int y = this.getTopOfTower() + 1;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
        if (te instanceof SodiumSolarUpgrades.SodiumSolarReceiver) {
            SodiumSolarUpgrades.SodiumSolarReceiver ss = (SodiumSolarUpgrades.SodiumSolarReceiver)te;
            return ss.isActive();
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.INPUT;
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        c.add(this.getAdjacentTileEntity(this.write));
    }
}

