/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Auxiliary.Trackers.ItemMaterialController;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.ItemMaterial;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesPulseFurnace;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPulseFurnace
extends InventoriedPowerReceiver
implements TemperatureTE,
PipeConnector,
IFluidHandler,
DiscreteFunction,
ConditionalOperation {
    public int pulseFurnaceCookTime;
    public static final int CAPACITY = 3000;
    public static final int MAXFUEL = 8000;
    public static final int MAXTEMP = 1000;
    public static final int SMELTTICKS = 100;
    public boolean idle = false;
    public int temperature;
    private int tickcount2 = 0;
    public int smelttick = 0;
    private int soundtick = 2000;
    boolean flag2 = false;
    private final HybridTank fuel = new HybridTank("fuel", 8000);
    private final HybridTank water = new HybridTank("water", 3000);
    private final HybridTank accel = new HybridTank("accel", 8000);

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    public void testIdle() {
        this.idle = !this.canSmelt() && this.omega > this.MINSPEED;
    }

    public int func_70302_i_() {
        return 3;
    }

    public static boolean func_52005_b(ItemStack par0ItemStack) {
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pulseFurnaceCookTime = NBT.func_74765_d("CookTime");
        this.water.readFromNBT(NBT);
        this.fuel.readFromNBT(NBT);
        this.accel.readFromNBT(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.pulseFurnaceCookTime);
        this.water.writeToNBT(NBT);
        this.fuel.writeToNBT(NBT);
        this.accel.writeToNBT(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    public int getCookProgressScaled(int par1) {
        return this.pulseFurnaceCookTime * par1 / 20;
    }

    public int getFuelScaled(int par1) {
        return this.fuel.getLevel() * par1 / 8000;
    }

    public int getTempScaled(int par1) {
        return this.temperature * par1 / 1000;
    }

    public int getWaterScaled(int par1) {
        return this.water.getLevel() * par1 / 3000;
    }

    public int getFireScaled(int par1) {
        return this.smelttick * par1 / 100;
    }

    public int getAccelerantScaled(int a) {
        return this.accel.getLevel() * a / this.accel.getCapacity();
    }

    private void getFuel(World world, int x, int y, int z, int meta) {
        if (this.tickcount2 >= 100) {
            this.fuel.removeLiquid(100);
            this.tickcount2 = 0;
        }
    }

    public void heatAmbient(World world, int x, int y, int z, int meta) {
        if (this.fuel.getLevel() > 0 && this.canHeatUp()) {
            this.temperature += ReikaMathLibrary.extrema((int)((1000 - this.temperature) / 8), (int)4, (String)"max");
        }
        if (this.water.getLevel() > 0) {
            int rem;
            if (rand.nextInt(3) == 0 && (rem = this.temperature * 2 / 1000 * 50) > 0) {
                this.water.removeLiquid(rem);
            }
            this.temperature -= this.temperature / 64;
        }
        if (this.temperature < 0) {
            this.temperature = 0;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (biome == BiomeGenBase.field_76776_l || biome == BiomeGenBase.field_76777_m || biome == BiomeGenBase.field_76775_o || biome == BiomeGenBase.field_76774_n || biome == BiomeGenBase.field_76768_g || biome == BiomeGenBase.field_76784_u) {
            this.temperature -= 4;
        } else if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s || biome == BiomeGenBase.field_76782_w || biome == BiomeGenBase.field_76792_x) {
            --this.temperature;
        } else if (biome != BiomeGenBase.field_76778_j) {
            this.temperature -= 2;
        }
        if (this.temperature < Tamb) {
            this.temperature = Tamb;
        }
    }

    private boolean canHeatUp() {
        return this.power >= this.MINPOWER && this.omega >= this.MINSPEED && !this.fuel.isEmpty();
    }

    public void smeltHeat() {
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        if (this.temperature > 915) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching very high temperature!"));
            world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
        ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)y, (int)z, (int)this.temperature);
        if (this.temperature > 1000) {
            this.overheat(world, x, y, z);
        }
    }

    public int getReqTemps(ItemStack is) {
        if (is == null) {
            return -1;
        }
        if (is.func_77973_b() == Items.field_151042_j) {
            return 900;
        }
        if (ItemMaterialController.instance.getMaterial(is) == ItemMaterial.OBSIDIAN) {
            return ItemMaterialController.instance.getMeltingPoint(is);
        }
        return ItemMaterialController.instance.getMeltingPoint(is) / 2;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.testIdle();
        ++this.soundtick;
        boolean flag1 = false;
        int reqtemp = this.getReqTemps(this.inv[0]);
        if (this.tickcount >= 20) {
            this.heatAmbient(world, x, y, z, meta);
            this.updateTemperature(world, x, y, z, meta);
            this.tickcount = 0;
        }
        if (this.soundtick >= 18 && this.canHeatUp()) {
            this.soundtick = 0;
            SoundRegistry.PULSEJET.playSoundAtBlock(world, x, y, z, 1.0f, 1.0f);
        }
        boolean canprocess = false;
        if (this.canSmelt()) {
            canprocess = true;
            if (!this.flag2) {
                this.getFuel(world, x, y, z, meta);
            }
        }
        ++this.tickcount;
        ++this.tickcount2;
        int tick = 1;
        if (!this.fuel.isEmpty() && this.power > 0L && this.omega >= this.MINSPEED && this.accel.getLevel() > 10) {
            tick = 4;
            if (canprocess || this.temperature >= 800) {
                this.accel.removeLiquid(10);
                if (rand.nextInt(4) == 0) {
                    ++this.temperature;
                }
            }
        }
        if (this.temperature >= reqtemp && reqtemp != -1 && this.canSmelt()) {
            this.smelttick += tick;
            if (this.temperature >= 900) {
                this.smelttick += tick;
            }
            if (this.temperature >= 950) {
                this.smelttick += tick * 2;
            }
            if (this.temperature >= 980) {
                this.smelttick += tick * 4;
            }
        } else {
            this.smelttick = 0;
        }
        if (this.smelttick < 100 && !this.flag2) {
            return;
        }
        if (this.smelttick > 100) {
            this.smelttick = 100;
        }
        this.flag2 = true;
        if (!this.field_145850_b.field_72995_K) {
            flag1 = true;
            if (this.canSmelt()) {
                this.pulseFurnaceCookTime += tick;
                if (this.pulseFurnaceCookTime >= this.getOperationTime()) {
                    this.pulseFurnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                    this.smelttick = 0;
                }
            } else {
                this.pulseFurnaceCookTime = 0;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        this.getPowerBelow();
        if (this.power <= 0L || this.omega < this.MINSPEED) {
            return false;
        }
        if (this.inv[0] == null) {
            return false;
        }
        if (this.fuel.isEmpty()) {
            return false;
        }
        int mintemp = this.getReqTemps(this.inv[0]);
        if (mintemp == -1 || mintemp > this.temperature) {
            return false;
        }
        ItemStack itemstack = RecipesPulseFurnace.getRecipes().getSmeltingResult(this.inv[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inv[2] == null) {
            return true;
        }
        if (!this.inv[2].func_77969_a(itemstack)) {
            return false;
        }
        if (this.inv[2].field_77994_a < this.func_70297_j_() && this.inv[2].field_77994_a < this.inv[2].func_77976_d()) {
            return true;
        }
        return this.inv[2].field_77994_a < itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        this.flag2 = false;
        this.smeltHeat();
        ItemStack itemstack = RecipesPulseFurnace.getRecipes().getSmeltingResult(this.inv[0]);
        if (this.inv[2] == null) {
            this.inv[2] = itemstack.func_77946_l();
        } else if (ReikaItemHelper.matchStacks((ItemStack)this.inv[2], (ItemStack)itemstack)) {
            this.inv[2].field_77994_a += itemstack.field_77994_a;
        }
        --this.inv[0].field_77994_a;
        if (this.inv[0].field_77994_a <= 0) {
            this.inv[0] = null;
        }
    }

    private ItemStack getCraftedScrapIngot() {
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.scrap)) {
            return ItemStacks.steelingot;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.ironscrap)) {
            return new ItemStack(Items.field_151042_j);
        }
        return null;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PULSEJET;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot != 0) {
            return false;
        }
        return RecipesPulseFurnace.getRecipes().getSmeltingResult(is) != null;
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 100;
    }

    public int getRedstoneOverride() {
        if (!this.canSmelt()) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)17, (boolean)true, (float)1.5f, (boolean)false, (boolean)ConfigRegistry.BLOCKDAMAGE.getState(), (float)12.0f);
    }

    public int getAccelerant() {
        return this.accel.getLevel();
    }

    public Fluid getAccelerantType() {
        return this.accel.getActualFluid();
    }

    public int getAccelerantCapacity() {
        return this.accel.getCapacity();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid fluid = resource.getFluid();
        if (!this.canFill(from, fluid)) {
            return 0;
        }
        if (fluid.equals(FluidRegistry.WATER)) {
            return this.water.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return this.fuel.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc oxygen"))) {
            return this.accel.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"oxygen"))) {
            return this.accel.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid.equals(FluidRegistry.WATER)) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc oxygen"))) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"oxygen"))) {
            return from.offsetY == 0;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.fuel.getInfo(), this.accel.getInfo()};
    }

    public int getWater() {
        return this.water.getLevel();
    }

    public int getFuel() {
        return this.fuel.getLevel();
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public void addFuel(int amt) {
        this.fuel.addLiquid(amt, FluidRegistry.getFluid((String)"rc jet fuel"));
    }

    public void addWater(int amt) {
        this.water.addLiquid(amt, FluidRegistry.WATER);
    }

    @Override
    public int getOperationTime() {
        return 20;
    }

    @Override
    public boolean areConditionsMet() {
        return this.canSmelt() && !this.fuel.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.fuel.isEmpty() ? "No Fuel" : (this.areConditionsMet() ? "Operational" : "Invalid or Missing Items");
    }

    public void removeFuel(int amt) {
        this.fuel.removeLiquid(amt);
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }
}

