/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Collections.ItemCollection;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.IActionHost"})
public class TileEntityAutoCrafter
extends InventoriedPowerReceiver
implements IActionHost {
    public static final int SIZE = 18;
    private final ItemCollection ingredients = new ItemCollection();
    public int[] crafting = new int[18];
    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private final StepTimer updateTimer = new StepTimer(50);
    private static final int MAX_TICK_DELAY = 100;
    private int tickTimer = 1;
    private int tick;
    private int[] threshold = new int[18];
    private CraftingMode mode = CraftingMode.REQUEST;
    private static final int OUTPUT_OFFSET = 18;
    private static final int CONTAINER_OFFSET = 36;

    public TileEntityAutoCrafter() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getMachine().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    private void craftMissingItems() {
        if (ModList.APPENG.isLoaded() && this.network != null) {
            for (int i = 0; i < 18; ++i) {
                long thresh;
                long missing;
                ItemStack is = this.getSlotRecipeOutput(i);
                if (is == null || (missing = (thresh = (long)this.getThreshold(i)) - this.network.getItemCount(is, false)) <= 0L) continue;
                int num = Math.min(is.func_77976_d(), (int)Math.min(missing, Integer.MAX_VALUE));
                this.attemptSlotCrafting(i, num);
            }
        }
    }

    public int getThreshold(int i) {
        return this.threshold[i];
    }

    public void setThreshold(int i, int amt) {
        this.threshold[i] = amt;
        this.syncAllData(true);
    }

    public void incrementMode() {
        this.mode = this.mode.next();
    }

    private void profileCraftingTime(long start) {
        long duration = System.nanoTime() - start;
        if (ConfigRegistry.CRAFTERPROFILE.getState() && duration > (long)(1000000 * this.tickTimer) && this.tickTimer < 100) {
            this.tickTimer += this.getTickIncrement();
        } else if (this.tickTimer > 0) {
            --this.tickTimer;
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        this.tickCraftingDisplay();
        this.updateTimer.update();
        if (this.updateTimer.checkCap() && !world.field_72995_K) {
            this.buildCache();
        }
        if (ModList.APPENG.isLoaded()) {
            if (this.network != null) {
                this.network.tick();
            }
            if (this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost(this.power >= this.MINPOWER ? 4.0 : 1.0);
            }
        }
        if (this.power >= this.MINPOWER) {
            ++this.tick;
            this.mode.tick(this);
            this.injectItems();
        }
    }

    private int getTickIncrement() {
        if (this.tickTimer < 10) {
            return 1;
        }
        if (this.tickTimer < 20) {
            return 2;
        }
        if (this.tickTimer < 40) {
            return 5;
        }
        return 10;
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    private void injectItems() {
        if (ModList.APPENG.isLoaded() && this.network != null) {
            for (int i = 0; i < 18; ++i) {
                ItemStack in = this.inv[i + 18];
                if (in != null) {
                    in.field_77994_a = (int)this.network.addItem(in, false);
                    if (in.field_77994_a <= 0) {
                        this.inv[i + 18] = null;
                    }
                }
                if ((in = this.inv[i + 36]) == null) continue;
                in.field_77994_a = (int)this.network.addItem(in, false);
                if (in.field_77994_a > 0) continue;
                this.inv[i + 36] = null;
            }
        }
    }

    private void tickCraftingDisplay() {
        for (int i = 0; i < 18; ++i) {
            this.crafting[i] = Math.max(this.crafting[i] - 1, 0);
        }
    }

    private void buildCache() {
        this.ingredients.clear();
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
        if (te instanceof IInventory) {
            this.ingredients.addInventory((IInventory)te);
        }
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            ((IGridNode)this.aeGridNode).updateState();
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
            }
        }
    }

    public void triggerCraftingCycle(int slot) {
        ItemStack out;
        if (this.power >= this.MINPOWER && (out = this.getSlotRecipeOutput(slot)) != null) {
            this.attemptSlotCrafting(slot, 0);
        }
    }

    public ItemStack getSlotRecipeOutput(int slot) {
        ItemStack is = this.inv[slot];
        if (is == null) {
            return null;
        }
        return this.getOutput(is);
    }

    private void attemptAllSlotCrafting() {
        for (int i = 0; i < 18; ++i) {
            this.attemptSlotCrafting(i, 0);
        }
    }

    private boolean attemptSlotCrafting(int i, int d) {
        return this.attemptSlotCrafting(i, 1, d);
    }

    private boolean attemptSlotCrafting(int i, int n, int d) {
        ItemStack is = this.inv[i];
        if (is == null) {
            return false;
        }
        ItemStack[] items = this.getIngredients(is);
        ItemStack out = this.getOutput(is);
        if (items != null && out != null) {
            boolean flag = false;
            for (int a = 0; a < n; ++a) {
                flag |= this.tryCrafting(i, out, items, d);
            }
            return flag;
        }
        return false;
    }

    private ItemStack[] getIngredients(ItemStack is) {
        if (is.func_77973_b() == ItemRegistry.CRAFTPATTERN.getItemInstance() && is.field_77990_d != null) {
            return ItemCraftPattern.getItems(is);
        }
        if (ModList.APPENG.isLoaded() && is.func_77973_b() instanceof ICraftingPatternItem) {
            ICraftingPatternDetails icpd = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b);
            if (icpd.isCraftable()) {
                ItemStack[] ret = new ItemStack[9];
                IAEItemStack[] in = icpd.getInputs();
                for (int i = 0; i < ret.length && i < in.length; ++i) {
                    if (in[i] == null) continue;
                    ret[i] = in[i].getItemStack();
                }
                return ret;
            }
            return null;
        }
        return null;
    }

    private ItemStack getOutput(ItemStack is) {
        if (is.func_77973_b() == ItemRegistry.CRAFTPATTERN.getItemInstance() && is.field_77990_d != null && ItemCraftPattern.getMode(is) == ItemCraftPattern.RecipeMode.CRAFTING) {
            return ItemCraftPattern.getRecipeOutput(is);
        }
        if (ModList.APPENG.isLoaded() && is.func_77973_b() instanceof ICraftingPatternItem) {
            ICraftingPatternDetails icpd = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b);
            return icpd.isCraftable() ? icpd.getCondensedOutputs()[0].getItemStack() : null;
        }
        return null;
    }

    private boolean tryCrafting(int i, ItemStack out, ItemStack[] items, int d) {
        int size;
        int slot = i + 18;
        int n = size = this.inv[slot] != null ? this.inv[slot].field_77994_a : 0;
        if ((this.inv[slot] == null || ReikaItemHelper.matchStacks((ItemStack)out, (ItemStack)this.inv[slot]) && size + out.field_77994_a <= out.func_77976_d()) && this.inv[i + 36] == null) {
            ItemHashMap counts = new ItemHashMap();
            for (int k = 0; k < 9; ++k) {
                if (items[k] == null) continue;
                Integer req = (Integer)counts.get(items[k]);
                int val = req != null ? req : 0;
                counts.put(items[k], (Object)(val + 1));
            }
            for (ItemStack is : counts.keySet()) {
                int has;
                int req;
                int missing;
                if (ReikaItemHelper.matchStacks((ItemStack)out, (ItemStack)is) || (missing = (req = ((Integer)counts.get(is)).intValue()) - (has = this.getAvailableIngredients(is))) <= 0 || d >= 40 || !this.canCraftIntermediates(out, (ItemHashMap<Integer>)counts) || this.tryCraftIntermediates(missing, is, d + 1)) continue;
                return false;
            }
            this.craft(slot, size, out, (ItemHashMap<Integer>)counts);
            return true;
        }
        return false;
    }

    private boolean canCraftIntermediates(ItemStack out, ItemHashMap<Integer> req) {
        Block b = Block.func_149634_a((Item)out.func_77973_b());
        if (b instanceof BlockCompressed) {
            return false;
        }
        if (this.isLoopable(out, req)) {
            return false;
        }
        return !out.func_77973_b().getClass().getName().equals("ItemReactorCondensator");
    }

    private boolean isLoopable(ItemStack out, ItemHashMap<Integer> req) {
        Collection c = req.keySet();
        if (ReikaItemHelper.collectionContainsItemStack((Collection)c, (ItemStack)out)) {
            return true;
        }
        for (ItemStack is : c) {
            ArrayList li = ReikaRecipeHelper.getAllRecipesByOutput((List)CraftingManager.func_77594_a().func_77592_b(), (ItemStack)is);
            for (IRecipe ir : li) {
                if (!ReikaItemHelper.collectionContainsItemStack((Collection)ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)ir), (ItemStack)out)) continue;
                return true;
            }
        }
        return false;
    }

    private int getAvailableIngredients(ItemStack is) {
        int count = 0;
        count += this.ingredients.getItemCount(is);
        if (ModList.APPENG.isLoaded() && this.network != null) {
            count = (int)((long)count + this.network.removeItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)is.func_77976_d()), true, false));
        }
        return count;
    }

    private boolean tryCraftIntermediates(int num, ItemStack is, int d) {
        int run = 0;
        CountMap ranSlots = new CountMap();
        for (int i = 0; i < 18 && run < num; ++i) {
            ItemStack out = this.getSlotRecipeOutput(i);
            if (out == null || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)out)) continue;
            while (run < num && this.attemptSlotCrafting(i, d)) {
                run += out.field_77994_a;
                ranSlots.set((Object)i, Math.min(num, ranSlots.get((Object)i) + out.field_77994_a));
            }
        }
        if (run >= num) {
            Iterator i$ = ranSlots.keySet().iterator();
            while (i$.hasNext()) {
                int slot = (Integer)i$.next();
                this.inv[slot + 18].field_77994_a -= ranSlots.get((Object)slot);
                if (this.inv[slot + 18].field_77994_a > 0) continue;
                this.inv[slot + 18] = null;
            }
            return true;
        }
        return false;
    }

    private void craft(int slot, int size, ItemStack out, ItemHashMap<Integer> counts) {
        this.inv[slot] = ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)(size + out.field_77994_a));
        if (out.field_77990_d != null) {
            this.inv[slot].field_77990_d = (NBTTagCompound)out.field_77990_d.func_74737_b();
        }
        for (ItemStack is : counts.keySet()) {
            int req = (Integer)counts.get(is);
            if (is.func_77960_j() == Short.MAX_VALUE) {
                int dec = req;
                for (int k = 0; k < Short.MAX_VALUE; ++k) {
                    ItemStack is2 = new ItemStack(is.func_77973_b(), 1, k);
                    int rem = this.ingredients.removeXItems(is2, req);
                    if ((dec -= rem) > 0) {
                        int diff = req - rem;
                        if (ModList.APPENG.isLoaded() && diff > 0 && this.network != null) {
                            ItemStack is2c = is2.func_77946_l();
                            is2c.field_77994_a = diff;
                            dec = (int)((long)dec - this.network.removeItem(is2, false, false));
                        }
                    }
                    if (dec > 0) {
                        continue;
                    }
                    break;
                }
            } else {
                int rem = this.ingredients.removeXItems(is, req);
                int diff = req - rem;
                if (ModList.APPENG.isLoaded() && diff > 0 && this.network != null) {
                    ItemStack isc = is.func_77946_l();
                    isc.field_77994_a = diff;
                    this.network.removeItem(isc, false, false);
                }
            }
            this.addContainers(is, req, slot - 18);
        }
        this.crafting[slot - 18] = 5;
        this.func_70296_d();
    }

    private void addContainers(ItemStack is, int req, int slot) {
        ItemStack con = is.func_77973_b().getContainerItem(is);
        if (con != null) {
            this.inv[36 + slot] = ReikaItemHelper.getSizedItemStack((ItemStack)con, (int)req);
        }
    }

    private boolean hasIngredient(ItemStack is) {
        return this.ingredients.hasItem(is);
    }

    public boolean func_102008_b(int i, ItemStack is, int j) {
        return i >= 18;
    }

    public int func_70302_i_() {
        return 54;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return i < 18 && ItemRegistry.CRAFTPATTERN.matchItem(is);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.CRAFTER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("mode", this.mode.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.mode = CraftingMode.list[NBT.func_74762_e("mode")];
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound fil = new NBTTagCompound();
        for (int i = 0; i < this.threshold.length; ++i) {
            fil.func_74768_a("thresh_" + i, this.threshold[i]);
        }
        NBT.func_74782_a("filter", (NBTBase)fil);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        NBTTagCompound fil = NBT.func_74775_l("filter");
        this.threshold = new int[this.threshold.length];
        for (int i = 0; i < this.threshold.length; ++i) {
            String name = "filter_" + i;
            this.threshold[i] = fil.func_74762_e("thresh_" + i);
        }
    }

    public CraftingMode getMode() {
        return this.mode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public void securityBreak() {
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    public static enum CraftingMode {
        REQUEST("Request", "Crafts one cycle per request.", 0xFF0000, "2"),
        CONTINUOUS("Continuous", "Crafts continuously as long as there are ingredients", 43775, "2"),
        SUSTAIN("Sustain", "Tries to sustain a given number of a certain item", 0xBB22FF, "4");

        public final String label;
        public final String desc;
        public final int color;
        public final String imageSuffix;
        private static final CraftingMode[] list;

        private CraftingMode(String l, String d, int c, String img) {
            this.label = l;
            this.desc = d;
            this.color = c;
            this.imageSuffix = img;
        }

        private void tick(TileEntityAutoCrafter te) {
            switch (this) {
                case REQUEST: {
                    break;
                }
                case CONTINUOUS: {
                    if (te.tick < te.tickTimer) break;
                    te.tick = 0;
                    long time = System.nanoTime();
                    te.attemptAllSlotCrafting();
                    te.profileCraftingTime(time);
                    break;
                }
                case SUSTAIN: {
                    te.tickTimer = 20;
                    if (te.tick < te.tickTimer) break;
                    te.tick = 0;
                    te.craftMissingItems();
                }
            }
        }

        public boolean isValid() {
            switch (this) {
                case SUSTAIN: {
                    return ModList.APPENG.isLoaded();
                }
            }
            return true;
        }

        public CraftingMode next() {
            CraftingMode mode = this.calcNext();
            while (!mode.isValid()) {
                mode = mode.calcNext();
            }
            return mode;
        }

        private CraftingMode calcNext() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = CraftingMode.values();
        }
    }
}

