/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.RotaryCraft.Auxiliary.HarvesterDamage;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityMobHarvester
extends TileEntityPowerReceiver
implements EnchantableMachine {
    private HashMap<Enchantment, Integer> enchantments = new HashMap();
    public String owner;
    public boolean laser;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        EntityPlayer ep = this.getPlacer();
        boolean oneplus = false;
        AxisAlignedBB box = this.getBox();
        List inbox = world.func_72872_a(EntityLiving.class, box);
        for (EntityLiving ent : inbox) {
            if (ent instanceof EntityVillager) continue;
            oneplus = true;
            if (ep != null && this.getDamage() > 0) {
                ent.func_70097_a((DamageSource)new HarvesterDamage(this), (float)this.getDamage());
                if (this.getEnchantment(Enchantment.field_77348_q) > 0 && rand.nextInt(20) == 0) {
                    ReikaEntityHelper.dropHead((EntityLivingBase)ent);
                }
                if (this.getEnchantment(Enchantment.field_77334_n) > 0) {
                    ent.func_70015_d(this.getEnchantment(Enchantment.field_77334_n) * 2);
                }
            }
            ent.field_70181_x = 0.0;
        }
        this.laser = oneplus;
    }

    public int getDamage() {
        double pdiff = 2.0 + 0.5 * (double)this.power / (double)this.MINPOWER;
        double ppdiff = ReikaMathLibrary.intpow((double)pdiff, (int)6);
        return (int)ReikaMathLibrary.logbase((double)ppdiff, (double)2.0) + 2 * this.getEnchantment(Enchantment.field_77338_j);
    }

    public AxisAlignedBB getBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + this.getHeight() + 1), (double)(this.field_145849_e + 1));
    }

    private int getHeight() {
        return 3;
    }

    public AxisAlignedBB getLaser() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.4), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.4), (double)((double)this.field_145851_c + 0.6), (double)(this.field_145848_d + 3), (double)((double)this.field_145849_e + 0.6));
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean flag = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77338_j, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77338_j, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77338_j, (ItemStack)is));
            flag = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77334_n, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77334_n, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77334_n, (ItemStack)is));
            flag = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77348_q, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77348_q, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77348_q, (ItemStack)is));
            flag = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77335_o, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77335_o, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77335_o, (ItemStack)is));
            flag = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77342_w, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77342_w, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77342_w, (ItemStack)is));
            flag = true;
        }
        return flag;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77338_j);
        li.add(Enchantment.field_77334_n);
        li.add(Enchantment.field_77348_q);
        li.add(Enchantment.field_77335_o);
        li.add(Enchantment.field_77342_w);
        return li;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.owner != null && !this.owner.isEmpty()) {
            NBT.func_74778_a("sowner", this.owner);
        }
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = this.getEnchantment(Enchantment.field_77331_b[i]);
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.owner = NBT.func_74779_i("sowner");
        this.enchantments = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a());
            this.enchantments.put(Enchantment.field_77331_b[i], lvl);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MOBHARVESTER;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

