/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.API.Interfaces.BlowableCrop;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFertilizer
extends InventoriedPowerLiquidReceiver
implements RangedEffect,
ConditionalOperation {
    private static final ArrayList<Block> fertilizables = new ArrayList();

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FERTILIZER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return this.hasFertilizer() ? 0 : 15;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(100, FluidRegistry.WATER);
            this.inv[0] = new ItemStack(Items.field_151100_aR, 64, 15);
        }
        if (!world.field_72995_K && this.hasFertilizer()) {
            int n = this.getUpdatesPerTick();
            for (int i = 0; i < n; ++i) {
                this.tickBlock(world, x, y, z);
            }
        }
    }

    private int getUpdatesPerTick() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        return 4 * ReikaMathLibrary.logbase2((long)this.omega);
    }

    private int getConsecutiveUpdates() {
        if (this.omega < 0x100000) {
            return 1;
        }
        return 1 + ReikaMathLibrary.logbase2((long)(this.omega / 0x100000));
    }

    private void tickBlock(World world, int x, int y, int z) {
        int r = this.getRange();
        int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
        int dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)r);
        int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        int ddx = dx - x;
        int ddy = dy - y;
        int ddz = dz - z;
        double dd = ReikaMathLibrary.py3d((double)ddx, (double)ddy, (double)ddz);
        if (id != Blocks.field_150350_a && dd <= (double)this.getRange()) {
            int n = this.getConsecutiveUpdates();
            for (int i = 0; i < n; ++i) {
                id.func_149674_a(world, dx, dy, dz, rand);
                BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)id, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
            }
            world.func_147471_g(dx, dy, dz);
            if (this.didSomething(world, dx, dy, dz)) {
                ReikaPacketHelper.sendUpdatePacket((String)"RotaryCraftData", (int)PacketRegistry.FERTILIZER.getMinValue(), (int)dx, (int)dy, (int)dz, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)dx, (double)dy, (double)dz, 32));
                if (ReikaRandomHelper.doWithChance((double)20.0)) {
                    this.consumeItem();
                }
            } else if (id == Blocks.field_150349_c) {
                ReikaPacketHelper.sendUpdatePacket((String)"RotaryCraftData", (int)PacketRegistry.FERTILIZER.getMinValue(), (int)dx, (int)dy, (int)dz, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)dx, (double)dy, (double)dz, 32));
            }
        }
    }

    private void consumeItem() {
        this.tank.removeLiquid(5);
        if (rand.nextInt(4) == 0) {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
                return;
            }
        }
    }

    private boolean didSomething(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)id);
        ModCropList mod = ModCropList.getModCrop((Block)id, (int)meta);
        ModWoodList sapling = ModWoodList.getModWoodFromSapling((Block)id, (int)meta);
        boolean fert = fertilizables.contains(id);
        if (crop != null) {
            return true;
        }
        if (mod != null) {
            return true;
        }
        if (sapling != null) {
            return true;
        }
        if (fert) {
            return true;
        }
        return id instanceof BlowableCrop;
    }

    @Override
    public int getRange() {
        if (this.torque <= 0) {
            return 0;
        }
        int r = 2 * (int)ReikaMathLibrary.logbase((long)this.torque, (int)2);
        if (r > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return r;
    }

    @Override
    public int getMaxRange() {
        return 32;
    }

    public int func_70302_i_() {
        return 18;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return this.isValidFertilizer(is);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean isValidFertilizer(ItemStack is) {
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ReikaItemHelper.bonemeal)) {
            return true;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.compost)) {
            return true;
        }
        return is.func_77973_b() == ForestryHandler.ItemEntry.FERTILIZER.getItem();
    }

    public boolean hasFertilizer() {
        if (this.tank.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null || !this.isValidFertilizer(this.inv[i])) continue;
            return true;
        }
        return false;
    }

    private static void addFertilizable(Block b) {
        fertilizables.add(b);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from != ForgeDirection.DOWN;
    }

    @Override
    public int getCapacity() {
        return 6000;
    }

    @Override
    public boolean areConditionsMet() {
        return !this.tank.isEmpty() && this.hasFertilizer();
    }

    @Override
    public String getOperationalStatus() {
        return this.tank.isEmpty() ? "No Water" : (this.areConditionsMet() ? "Operational" : "No Fertilizer Items");
    }

    static {
        TileEntityFertilizer.addFertilizable(Blocks.field_150345_g);
        TileEntityFertilizer.addFertilizable(Blocks.field_150434_aF);
        TileEntityFertilizer.addFertilizable(Blocks.field_150436_aH);
        TileEntityFertilizer.addFertilizable((Block)Blocks.field_150391_bh);
        TileEntityFertilizer.addFertilizable(Blocks.field_150394_bc);
        TileEntityFertilizer.addFertilizable(Blocks.field_150393_bb);
        TileEntityFertilizer.addFertilizable(Blocks.field_150395_bd);
    }
}

