/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.IdleComparator;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityAutoBreeder
extends InventoriedPowerReceiver
implements RangedEffect,
ConditionalOperation,
IdleComparator {
    public static final int FALLOFF = 2048;
    private static final MultiMap<Class, KeyedItemStack> feedItems = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());

    @Override
    public boolean isIdle() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack in = this.inv[i];
            if (in == null || !feedItems.containsValue((Object)new KeyedItemStack(in).setSimpleHash(true))) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return 18;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public int getRange() {
        int range = 8 + (int)((this.power - this.MINPOWER) / 2048L);
        if (range > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return range;
    }

    @Override
    public int getMaxRange() {
        return Math.max(24, ConfigRegistry.BREEDERRANGE.getValue());
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.power < this.MINPOWER) {
            return;
        }
        List<EntityAgeable> inrange = this.getEntities(world, x, y, z);
        this.breed(world, x, y, z, inrange);
    }

    private boolean canBreed(Entity ent) {
        return this.getFeedItem(ent) >= 0;
    }

    private int getFeedItem(Entity ent) {
        for (KeyedItemStack kis : feedItems.get(ent.getClass())) {
            int slot = ReikaInventoryHelper.locateInInventory((KeyedItemStack)kis, (ItemStack[])this.inv);
            if (slot == -1) continue;
            return slot;
        }
        return -1;
    }

    private void useFeedItem(Entity ent) {
        int slot = this.getFeedItem(ent);
        if (slot == -1) {
            return;
        }
        if (this.inv[slot] == null) {
            return;
        }
        ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
    }

    private void breed(World world, int x, int y, int z, List<EntityAgeable> inroom) {
        boolean pathing = false;
        if (this.tickcount >= 20) {
            this.tickcount = 0;
            pathing = true;
        }
        for (EntityAgeable ent : inroom) {
            if (!this.canBreed((Entity)ent)) continue;
            if ((!(ent instanceof EntityTameable) || ent instanceof EntityTameable && !((EntityTameable)ent).func_70906_o()) && pathing) {
                if (this.canDirectToMate(ent)) {
                    ent.func_70661_as().func_75499_g();
                    PathEntity path = ent.func_70661_as().func_75488_a((double)x, (double)y, (double)z);
                    ent.func_70661_as().func_75484_a(path, 1.0);
                } else {
                    ent.func_70661_as().func_75499_g();
                }
            }
            if (ent.func_70631_g_() || ent.func_70874_b() > 0 || !(ReikaMathLibrary.py3d((double)((double)x - ent.field_70165_t), (double)((double)y - ent.field_70163_u), (double)((double)z - ent.field_70161_v)) <= 2.4) || ent instanceof EntityTameable && (!(ent instanceof EntityTameable) || !((EntityTameable)ent).func_70909_n())) continue;
            this.breed(ent);
            int n = 1 + rand.nextInt(3);
            for (int i = 0; i < n; ++i) {
                double var4 = rand.nextGaussian() * 0.02;
                double var6 = rand.nextGaussian() * 0.02;
                double var8 = rand.nextGaussian() * 0.02;
                ent.field_70170_p.func_72869_a("heart", ent.field_70165_t + (double)(rand.nextFloat() * ent.field_70130_N * 2.0f) - (double)ent.field_70130_N, ent.field_70163_u + 0.5 + (double)(rand.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(rand.nextFloat() * ent.field_70130_N * 2.0f) - (double)ent.field_70130_N, var4, var6, var8);
            }
        }
    }

    private boolean canDirectToMate(EntityAgeable ent) {
        if (ent instanceof EntityAnimal && ((EntityAnimal)ent).func_70880_s()) {
            return false;
        }
        if (ent instanceof EntityVillager && ((EntityVillager)ent).func_70941_o()) {
            return false;
        }
        return !ent.func_70631_g_() && ent.func_70874_b() == 0;
    }

    private void breed(EntityAgeable e) {
        EntityVillager ent;
        boolean flag = false;
        if (e instanceof EntityAnimal) {
            EntityAnimal ent2 = (EntityAnimal)e;
            if (!ent2.func_70880_s()) {
                ent2.field_70881_d = 600;
                flag = true;
            }
        } else if (e instanceof EntityVillager && !(ent = (EntityVillager)e).func_70941_o()) {
            ent.func_70947_e(true);
            flag = true;
        }
        if (flag) {
            this.useFeedItem((Entity)e);
        }
    }

    private List<EntityAgeable> getEntities(World world, int x, int y, int z) {
        AxisAlignedBB room = this.getBox(x, y, z, this.getRange());
        List inroom = world.func_72872_a(EntityAgeable.class, room);
        return inroom;
    }

    private AxisAlignedBB getBox(int x, int y, int z, int range) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        return box;
    }

    private AxisAlignedBB getRoom(World world, int x, int y, int z) {
        int i;
        int minx = x;
        int maxx = x;
        int miny = y;
        int maxy = y;
        int minz = z;
        int maxz = z;
        boolean exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x + i + 1, y, z).func_149662_c()) {
                exit = true;
                continue;
            }
            maxx = x + i;
        }
        exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x - i, y, z).func_149662_c()) {
                exit = true;
                continue;
            }
            minx = x - i;
        }
        exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x, y + i + 1, z).func_149662_c()) {
                exit = true;
                continue;
            }
            maxy = y + i;
        }
        exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x, y - i, z).func_149662_c()) {
                exit = true;
                continue;
            }
            miny = x - i;
        }
        exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x, y, z + i + 1).func_149662_c()) {
                exit = true;
                continue;
            }
            maxz = z + i;
        }
        exit = false;
        for (i = 1; i < 15 && !exit; ++i) {
            if (world.func_147439_a(x, y, z - i).func_149662_c()) {
                exit = true;
                continue;
            }
            minz = z - i;
        }
        exit = false;
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.AUTOBREEDER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return feedItems.containsValue((Object)new KeyedItemStack(is).setSimpleHash(true));
    }

    public int getRedstoneOverride() {
        return this.isIdle() ? 15 : 0;
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Items";
    }

    private static void addFeedItem(Class entity, ItemStack food) {
        TileEntityAutoBreeder.addFeedItem(entity, new KeyedItemStack(food));
    }

    private static void addFeedItem(Class entity, Item food) {
        TileEntityAutoBreeder.addFeedItem(entity, new KeyedItemStack(food));
    }

    private static void addFeedItem(Class entity, KeyedItemStack food) {
        food.setSimpleHash(true).setSized(false);
        feedItems.addValue((Object)entity, (Object)food);
    }

    static {
        TileEntityAutoBreeder.addFeedItem(EntitySheep.class, Items.field_151015_O);
        TileEntityAutoBreeder.addFeedItem(EntityCow.class, Items.field_151015_O);
        TileEntityAutoBreeder.addFeedItem(EntityChicken.class, Items.field_151014_N);
        TileEntityAutoBreeder.addFeedItem(EntityPig.class, Items.field_151172_bF);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151147_al);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151157_am);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151082_bd);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151083_be);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151076_bf);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151077_bg);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151115_aP);
        TileEntityAutoBreeder.addFeedItem(EntityWolf.class, Items.field_151101_aQ);
        TileEntityAutoBreeder.addFeedItem(EntityOcelot.class, Items.field_151115_aP);
        TileEntityAutoBreeder.addFeedItem(EntityOcelot.class, Items.field_151101_aQ);
        TileEntityAutoBreeder.addFeedItem(EntitySheep.class, ItemStacks.canolaHusks);
        TileEntityAutoBreeder.addFeedItem(EntityCow.class, ItemStacks.canolaHusks);
        TileEntityAutoBreeder.addFeedItem(EntityChicken.class, ItemStacks.canolaHusks);
        TileEntityAutoBreeder.addFeedItem(EntityPig.class, ItemStacks.canolaHusks);
        TileEntityAutoBreeder.addFeedItem(EntityVillager.class, Items.field_151166_bC);
    }
}

