/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import streams.block.FixedFlowBlock;

public class TileEntityHydroEngine
extends TileEntityEngine {
    public boolean failed;
    private boolean bedrock;
    private Fluid fluidType;
    private double fluidFallSpeed;
    private boolean streamPower = false;
    private int streamTorque = 0;
    private int streamOmega = 0;

    @Override
    protected void consumeFuel() {
    }

    @Override
    protected void internalizeFuel() {
    }

    public boolean isBedrock() {
        return this.bedrock;
    }

    @Override
    public void setDataFromPlacer(ItemStack is) {
        if (is.field_77990_d != null) {
            this.bedrock = is.field_77990_d.func_74767_n("bed");
        }
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        boolean hasLube;
        boolean bl = hasLube = !this.lubricant.isEmpty() && this.lubricant.getActualFluid().equals(FluidRegistry.getFluid((String)"rc lubricant"));
        if (!hasLube) {
            return false;
        }
        this.distributeLubricant(world, x, y, z);
        if (this.doesBlockObstructBlades(world, x, y + 1, z)) {
            this.omega = 0;
            return false;
        }
        if (this.doesBlockObstructBlades(world, x, y - 1, z)) {
            this.omega = 0;
            return false;
        }
        int[] pos = this.getWaterColumnPos();
        for (int i = -1; i <= 1; ++i) {
            if (!this.doesBlockObstructBlades(world, 2 * x - pos[0], y + i, 2 * z - pos[1])) continue;
            this.omega = 0;
            return false;
        }
        Block b = world.func_147439_a(x, y - 1, z);
        if (InterfaceCache.STREAM.instanceOf((Object)b)) {
            return this.handleStream(world, x, y, z, meta, b, pos);
        }
        this.streamPower = false;
        if (!ReikaWorldHelper.isLiquidAColumn((World)world, (int)pos[0], (int)y, (int)pos[1])) {
            return false;
        }
        this.getFluidData(world, x, y, z, pos);
        if (this.fluidType != null) {
            if (this.fluidType.getTemperature() >= 900 && ReikaRandomHelper.doWithChance((double)2.0)) {
                world.func_147468_f(x, y, z);
                boolean lube = !this.lubricant.isEmpty();
                world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, lube ? 3.0f : 2.0f, lube, true);
            }
            if (this.fluidType.isGaseous() || this.fluidType.getDensity() <= 0) {
                return false;
            }
        }
        return true;
    }

    private boolean handleStream(World world, int x, int y, int z, int meta, Block b, int[] pos) {
        FixedFlowBlock ff = (FixedFlowBlock)b;
        double vel = this.getUsefulVelocity(ff.dx(), ff.dz(), meta);
        if (vel > 0.0) {
            this.streamPower = true;
            Block b2 = world.func_147439_a(pos[0], y, pos[1]);
            boolean fall = FluidRegistry.lookupFluidForBlock((Block)b2) == FluidRegistry.WATER && world.func_147439_a(pos[0], y - 1, pos[1]) instanceof FixedFlowBlock || b2 instanceof FixedFlowBlock && this.getUsefulVelocity(((FixedFlowBlock)b2).dx(), ((FixedFlowBlock)b2).dz(), meta) > 0.0;
            double grav = this.getGravity(world);
            double vh_sq = fall ? 2.0 * grav * 1.0 : 0.0;
            double vtot = Math.sqrt(vh_sq + vel * vel);
            this.streamOmega = (int)(vtot * 2.0);
            double F = 1000.0 * vtot * vtot;
            double fudge = 0.875;
            this.streamTorque = 2 * ReikaMathLibrary.ceil2exp((int)((int)(F * 0.5 * fudge)));
            return true;
        }
        this.streamPower = false;
        return false;
    }

    private double getUsefulVelocity(int dx, int dz, int meta) {
        double vx = Math.abs(2.0 * (double)dx);
        double vz = Math.abs(2.0 * (double)dz);
        switch (meta) {
            case 0: {
                return vz;
            }
            case 1: {
                return vz;
            }
            case 2: {
                return vx;
            }
            case 3: {
                return vx;
            }
        }
        return 0.0;
    }

    private void distributeLubricant(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (dir != this.getWriteDirection() && dir.getOpposite() != this.getWriteDirection()) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m == MachineRegistry.ENGINE) {
                TileEntityEngine eng = (TileEntityEngine)this.getAdjacentTileEntity(dir);
                if (!(eng instanceof TileEntityHydroEngine)) continue;
                TileEntityHydroEngine hy = (TileEntityHydroEngine)eng;
                int it = hy.lubricant.getLevel();
                int dL = this.lubricant.getLevel() - it;
                if (dL <= 3) continue;
                hy.lubricant.addLiquid(dL / 4, FluidRegistry.getFluid((String)"rc lubricant"));
                this.lubricant.removeLiquid(dL / 4);
                continue;
            }
            if (m != MachineRegistry.RESERVOIR) continue;
            TileEntityReservoir te = (TileEntityReservoir)this.getAdjacentTileEntity(dir);
            if (this.lubricant.isEmpty() || !te.canAcceptFluid(FluidRegistry.getFluid((String)"rc lubricant"))) continue;
            int amt = Math.min(this.getLube(), 64000 - te.getLevel());
            if (amt <= 0) continue;
            te.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
            this.lubricant.removeLiquid(amt);
        }
        if (!this.failed && !this.lubricant.isEmpty() && this.omega > 0 && world.func_72820_D() % 10L == 0L) {
            this.lubricant.removeLiquid(1);
        }
    }

    private boolean doesBlockObstructBlades(World world, int x, int y, int z) {
        return !this.failed && !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z);
    }

    private int[] getWaterColumnPos() {
        int[] pos = new int[]{this.field_145851_c, this.field_145849_e};
        switch (this.func_145832_p()) {
            case 0: {
                pos[1] = pos[1] + -1;
                break;
            }
            case 1: {
                pos[1] = pos[1] + 1;
                break;
            }
            case 2: {
                pos[0] = pos[0] + 1;
                break;
            }
            case 3: {
                pos[0] = pos[0] + -1;
            }
        }
        return pos;
    }

    private void getFluidData(World world, int x, int y, int z, int[] pos) {
        Fluid f;
        this.fluidType = f = ReikaWorldHelper.getFluid((World)world, (int)pos[0], (int)y, (int)pos[1]);
        if (f == null || f.isGaseous() || f.getDensity() <= 0) {
            this.fluidFallSpeed = 0.0;
            return;
        }
        double grav = this.getGravity(world);
        double dy = ReikaWorldHelper.findFluidSurface((World)world, (double)pos[0], (double)y, (double)pos[1]) - (double)y - 0.5;
        dy = Math.pow(dy, 1.5) / 32.0;
        this.fluidFallSpeed = 0.92 * Math.sqrt(2.0 * grav * dy) / Math.max(0.25, Math.pow(f.getViscosity() / 1000, 0.375));
    }

    private int getEffectiveSpeed(World world, int x, int y, int z) {
        if (this.streamPower) {
            return this.streamOmega;
        }
        double omg = this.fluidFallSpeed * 2.0;
        return Math.min((int)omg, this.type.getSpeed());
    }

    private int getEffectiveTorque(World world, int x, int y, int z) {
        if (this.streamPower) {
            return this.streamTorque;
        }
        double mdot = (double)Math.min(12000, this.fluidType.getDensity()) * this.fluidFallSpeed;
        double tau = 0.0625 * mdot * this.fluidFallSpeed;
        return Math.min((int)tau, this.type.getTorque());
    }

    private void dealPanelDamage(World world, int x, int y, int z, int meta) {
        boolean a = false;
        boolean b = false;
        if (meta < 2) {
            b = true;
        } else {
            a = true;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)a, 1.0, (double)b);
        List in = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : in) {
            ent.func_70097_a((DamageSource)RotaryCraft.hydrokinetic, 1.0f);
        }
    }

    private double getGravity(World world) {
        double grav = 9.81;
        if (InterfaceCache.IGALACTICWORLD.instanceOf((Object)world.field_73011_w)) {
            IGalacticraftWorldProvider ig = (IGalacticraftWorldProvider)world.field_73011_w;
            grav += (double)(ig.getGravity() * 20.0f);
        }
        return grav;
    }

    private boolean isPartOfArray() {
        return this.isBackEndOfArray() || this.isFrontOfArray();
    }

    public boolean isBackEndOfArray() {
        MachineRegistry to = this.getMachine(this.write);
        if (to == MachineRegistry.ENGINE) {
            TileEntityEngine te = (TileEntityEngine)this.getAdjacentTileEntity(this.write);
            return te.getEngineType() == EngineType.HYDRO && !((TileEntityHydroEngine)te).failed;
        }
        return false;
    }

    public boolean isFrontOfArray() {
        MachineRegistry from = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.backx, this.field_145848_d, this.backz);
        MachineRegistry to = this.getMachine(this.write);
        if (from == MachineRegistry.ENGINE && to != MachineRegistry.ENGINE) {
            TileEntityEngine te = (TileEntityEngine)this.field_145850_b.func_147438_o(this.backx, this.field_145848_d, this.backz);
            return te.getEngineType() == EngineType.HYDRO;
        }
        TileEntity te = this.getAdjacentTileEntity(this.write);
        if (te instanceof TileEntityHydroEngine) {
            return ((TileEntityHydroEngine)te).failed;
        }
        return false;
    }

    private int getArrayTorqueMultiplier() {
        ArrayList<TileEntityHydroEngine> li = new ArrayList<TileEntityHydroEngine>();
        int size = 1;
        TileEntity te = this.getAdjacentTileEntity(this.write.getOpposite());
        while (te instanceof TileEntityHydroEngine && te != this && !li.contains(te)) {
            TileEntityHydroEngine eng = (TileEntityHydroEngine)te;
            li.add(eng);
            if (!eng.getRequirements(this.field_145850_b, eng.field_145851_c, eng.field_145848_d, eng.field_145849_e, eng.func_145832_p())) continue;
            if (eng.omega == this.omega && !eng.failed) {
                ++size;
                te = eng.getAdjacentTileEntity(eng.write.getOpposite());
                continue;
            }
            ReikaParticleHelper.CRITICAL.spawnAroundBlock(this.field_145850_b, eng.field_145851_c, eng.field_145848_d, eng.field_145849_e, 5);
            if (rand.nextInt(3) != 0) break;
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)eng.field_145851_c, (int)eng.field_145848_d, (int)eng.field_145849_e, (String)"mob.blaze.hit");
            break;
        }
        return size;
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        if (this.isFrontOfArray() || !this.isPartOfArray()) {
            SoundRegistry.HYDRO.playSoundAtBlock(world, x, y, z, 1.0f * volume, 0.9f * pitchMultiplier);
        }
    }

    @Override
    public int getFuelLevel() {
        return 0;
    }

    @Override
    protected int getMaxSpeed(World world, int x, int y, int z, int meta) {
        return Math.max(1, this.getEffectiveSpeed(world, x, y, z));
    }

    @Override
    protected int getGenTorque(World world, int x, int y, int z, int meta) {
        if (this.failed) {
            return 1;
        }
        int torque = this.getEffectiveTorque(world, x, y, z) * this.getArrayTorqueMultiplier();
        int r = this.bedrock ? 16 : 4;
        double ratio = (double)torque / (double)EngineType.HYDRO.getTorque();
        if (ratio > (double)r) {
            this.fail(world, x, y, z);
        }
        return torque;
    }

    private void fail(World world, int x, int y, int z) {
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.break");
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)0.2f, (float)0.5f);
        this.failed = true;
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
        this.dealPanelDamage(world, x, y, z, meta);
        this.spawnParticles(world, x, y, z);
        if (this.failed) {
            ForgeDirection dir = this.getWriteDirection();
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            for (int i = -1; i <= y; ++i) {
                ReikaWorldHelper.dropAndDestroyBlockAt((World)world, (int)(x + left.offsetX), (int)(y + i), (int)(z + left.offsetZ), null, (boolean)false, (boolean)true);
            }
            ReikaWorldHelper.dropAndDestroyBlockAt((World)world, (int)x, (int)(y + 1), (int)z, null, (boolean)false, (boolean)true);
            ReikaWorldHelper.dropAndDestroyBlockAt((World)world, (int)x, (int)(y - 1), (int)z, null, (boolean)false, (boolean)true);
        }
    }

    private void spawnParticles(World world, int x, int y, int z) {
        int[] xz = this.getWaterColumnPos();
        ReikaParticleHelper.RAIN.spawnAroundBlock(world, x, y, z, 16);
        ReikaParticleHelper.RAIN.spawnAroundBlock(world, xz[0], y, xz[1], 16);
        if (this.failed) {
            if (rand.nextInt(5) == 0) {
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"mob.blaze.hit");
            }
            ReikaParticleHelper.CRITICAL.spawnAroundBlockWithOutset(world, x, y, z, 3, 0.25);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.failed = NBT.func_74767_n("fail");
        this.bedrock = NBT.func_74767_n("bedrock");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("fail", this.failed);
        NBT.func_74757_a("bedrock", this.bedrock);
    }

    public void makeBedrock() {
        this.bedrock = true;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList psl = super.getPowerSources(io, caller);
        ArrayList<TileEntityHydroEngine> li = new ArrayList<TileEntityHydroEngine>();
        ArrayList<TileEntityHydroEngine> li2 = new ArrayList<TileEntityHydroEngine>();
        TileEntity te = this.getAdjacentTileEntity(this.write.getOpposite());
        while (te instanceof TileEntityHydroEngine && te != this && !li2.contains(te)) {
            TileEntityHydroEngine eng = (TileEntityHydroEngine)te;
            li2.add(eng);
            if (!eng.getRequirements(this.field_145850_b, eng.field_145851_c, eng.field_145848_d, eng.field_145849_e, eng.func_145832_p()) || eng.omega != this.omega || eng.failed) continue;
            li.add(eng);
            te = eng.getAdjacentTileEntity(eng.write.getOpposite());
        }
        for (int i = 0; i < li.size(); ++i) {
            psl.addSource((PowerGenerator)li.get(i));
        }
        return psl;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(1.0, 1.0, 1.0);
    }
}

