/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Decorative;

import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityProjector
extends InventoriedPowerReceiver
implements RangedEffect {
    public static final int MAXCHANNELS = 24;
    public static final int DELAY = 400;
    public int channel = 0;
    public boolean on = false;
    public boolean emptySlide = true;

    public boolean canProject(int x2, int y2, int z2) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER) {
            this.on = false;
            return;
        }
        this.on = true;
        if (this.tickcount >= 400) {
            this.tickcount = 0;
        }
        this.getChannelFromActiveSlide();
    }

    protected void onPositiveRedstoneEdge() {
        this.cycleInv();
    }

    private void getChannelFromActiveSlide() {
        if (this.inv[0] == null) {
            this.emptySlide = true;
            this.channel = 0;
            return;
        }
        if (this.inv[0].func_77973_b() == Items.field_151061_bv) {
            this.emptySlide = false;
            this.channel = -1;
        }
        if (this.inv[0].func_77973_b() == Items.field_151113_aN) {
            this.emptySlide = false;
            this.channel = -3;
        }
        if (this.inv[0].func_77973_b() != ItemRegistry.SLIDE.getItemInstance()) {
            this.emptySlide = true;
            return;
        }
        this.emptySlide = false;
        this.channel = this.inv[0].func_77960_j() == 24 ? -2 : this.inv[0].func_77960_j();
    }

    public String getCustomImagePath() {
        if (this.inv[0] == null || this.inv[0].field_77990_d == null) {
            return "";
        }
        NBTTagCompound nbt = this.inv[0].field_77990_d;
        return nbt.func_74779_i("file");
    }

    public void cycleInv() {
        ItemStack active = this.inv[0];
        for (int i = 0; i < this.inv.length - 1; ++i) {
            this.inv[i] = this.inv[i + 1];
        }
        this.inv[this.inv.length - 1] = active;
        SoundRegistry.PROJECTOR.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.0f);
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int getRange() {
        switch (this.func_145832_p()) {
            case 0: {
                int x;
                for (x = this.field_145851_c - 1; x >= this.field_145851_c - 12 && this.field_145850_b.func_147439_a(x, this.field_145848_d, this.field_145849_e) == Blocks.field_150350_a; --x) {
                }
                return x - this.field_145851_c + 1;
            }
            case 1: {
                int x;
                for (x = this.field_145851_c + 1; x <= this.field_145851_c + 12 + 1 && (this.field_145850_b.func_147439_a(x, this.field_145848_d, this.field_145849_e) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(x, this.field_145848_d, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, x, this.field_145848_d, this.field_145849_e)); ++x) {
                }
                return -(x - this.field_145851_c);
            }
            case 2: {
                int z;
                for (z = this.field_145849_e + 1; z <= this.field_145849_e + 1 + 12 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, z) == Blocks.field_150350_a; ++z) {
                }
                return -(z - this.field_145849_e);
            }
            case 3: {
                int z;
                for (z = this.field_145849_e - 1; z >= this.field_145849_e - 12 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, z) == Blocks.field_150350_a; --z) {
                }
                return z - this.field_145849_e + 1;
            }
        }
        return 0;
    }

    public boolean canShow() {
        Block id;
        int i;
        int k;
        int r = this.getRange();
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int a = 0;
        int b = 0;
        switch (this.func_145832_p()) {
            case 0: {
                x += r - 1;
                a = 1;
                break;
            }
            case 1: {
                x -= r;
                a = 1;
                break;
            }
            case 2: {
                z -= r;
                b = 1;
                break;
            }
            case 3: {
                z += r - 1;
                b = 1;
            }
        }
        int x2 = x;
        int z2 = z;
        switch (this.func_145832_p()) {
            case 0: {
                ++x2;
                break;
            }
            case 1: {
                --x2;
                break;
            }
            case 2: {
                --z2;
                break;
            }
            case 3: {
                ++z2;
            }
        }
        World world = this.field_145850_b;
        for (k = 0; k <= 4; ++k) {
            for (i = -3; i <= 3; ++i) {
                id = world.func_147439_a(x + b * i, y + k, z + a * i);
                if (id == Blocks.field_150350_a || !id.func_149662_c()) {
                    return false;
                }
                if (this.canProject(x + b * i, y + k, z + a * i)) continue;
                return false;
            }
        }
        for (k = 0; k <= 4; ++k) {
            for (i = -3; i <= 3; ++i) {
                id = world.func_147439_a(x2 + b * i, y + k, z2 + a * i);
                if (id == Blocks.field_150350_a) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PROJECTOR;
    }

    public int func_70302_i_() {
        return 24;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77973_b() == ItemRegistry.SLIDE.getItemInstance();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.channel = NBT.func_74762_e("ch");
        this.emptySlide = NBT.func_74767_n("empty");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("ch", this.channel);
        NBT.func_74757_a("empty", this.emptySlide);
    }

    @Override
    public int getMaxRange() {
        return 8;
    }

    public int getRedstoneOverride() {
        if (!this.canShow()) {
            return 15;
        }
        return 0;
    }
}

