/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Decorative;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.API.Event.NoteEvent;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityMusicBox
extends TileEntityPowerReceiver
implements GuiController,
BreakAction,
TriggerableAction {
    private final ArrayList<Note>[] musicQueue;
    private boolean isOneTimePlaying = false;
    public static final int LOOPPOWER = 1024;
    private int[] playDelay = new int[16];
    private int[] playIndex = new int[16];
    private static final int[] channelColors = new int[]{0x3636FF, 13842175, 0xFFACAC, 0xFF3636, 16755766, 0xD3D336, 6667407, 0x36D336, 0x36FFFF, 5811193, 0x8484FF, 0xFF36FF, 8664831, 11836554, 9415093, 9745793};

    public TileEntityMusicBox() {
        this.musicQueue = new ArrayList[16];
        for (int i = 0; i < 16; ++i) {
            this.musicQueue[i] = new ArrayList();
        }
    }

    public static int getColorForChannel(int channel) {
        return channelColors[channel];
    }

    public int getMusicLength() {
        int size = -1;
        for (int i = 0; i < 16; ++i) {
            size = Math.max(size, this.musicQueue[i].size());
        }
        return size;
    }

    public int getChannelLength(int channel) {
        return this.musicQueue[channel].size();
    }

    public ArrayList<Note> getNotesAtIndex(int index) {
        ArrayList<Note> li = new ArrayList<Note>();
        for (int i = 0; i < 16; ++i) {
            if (this.musicQueue[i].size() <= index) continue;
            li.add(this.musicQueue[i].get(index));
        }
        return li;
    }

    public List<Note> getNotesInChannel(int channel) {
        return Collections.unmodifiableList(this.musicQueue[channel]);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (this.hasSavedFile()) {
            this.read();
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (world.field_72995_K) {
            return;
        }
        if (this.power < 1024L) {
            if (!this.isOneTimePlaying) {
                this.startPlaying();
                return;
            }
        } else {
            this.isOneTimePlaying = false;
        }
        if (this.isOneTimePlaying || this.power >= 1024L) {
            for (int i = 0; i < 16; ++i) {
                if (this.playDelay[i] > 0) {
                    int n = i;
                    this.playDelay[n] = this.playDelay[n] - 1;
                }
                if (this.playDelay[i] != 0) continue;
                if (!this.musicQueue[i].isEmpty()) {
                    Note n;
                    if (this.playIndex[i] >= this.musicQueue[i].size() || (n = this.musicQueue[i].get(this.playIndex[i])) == null) continue;
                    this.playNote(i, n);
                    continue;
                }
                this.playIndex[i] = 0;
            }
        }
        if (this.isAtEnd() && this.hasNoDelays()) {
            this.resetPlayback();
        }
    }

    protected void onPositiveRedstoneEdge() {
        this.isOneTimePlaying = true;
        this.startPlaying();
    }

    private boolean hasNoDelays() {
        for (int i = 0; i < 16; ++i) {
            if (this.playDelay[i] <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isAtEnd() {
        for (int i = 0; i < 16; ++i) {
            if (this.playIndex[i] >= this.musicQueue[i].size() - 1) continue;
            return false;
        }
        return true;
    }

    private void resetPlayback() {
        for (int i = 0; i < 16; ++i) {
            this.playIndex[i] = 0;
        }
        this.isOneTimePlaying = false;
    }

    private void startPlaying() {
        for (int i = 0; i < 16; ++i) {
            this.playIndex[i] = 0;
            this.playDelay[i] = 0;
        }
    }

    private void playNote(int channel, Note n) {
        if (!n.isRest()) {
            for (int i = 0; i < 3; ++i) {
                n.play(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            ReikaPacketHelper.sendUpdatePacket((String)"RotaryCraftData", (int)PacketRegistry.MUSICPARTICLE.getMinValue(), (TileEntity)this, (PacketTarget)new PacketTarget.RadiusTarget((TileEntity)this, 32));
        }
        this.playDelay[channel] = n.length.tickLength;
        int n2 = channel;
        this.playIndex[n2] = this.playIndex[n2] + 1;
        NoteEvent e = new NoteEvent((TileEntity)this, n.pitch, n.getTickLength(), channel);
        MinecraftForge.EVENT_BUS.post((Event)e);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void addNote(int channel, Note n) {
        this.musicQueue[channel].add(n);
    }

    public void addRest(int channel, Note n) {
        n = n.getRest();
        this.musicQueue[channel].add(n);
    }

    public void backspace(int channel) {
        this.musicQueue[channel].remove(this.musicQueue[channel].size() - 1);
    }

    public void clearChannel(int channel) {
        this.musicQueue[channel].clear();
    }

    public void clearMusic() {
        for (int i = 0; i < 16; ++i) {
            this.clearChannel(i);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("onetime", this.isOneTimePlaying);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isOneTimePlaying = NBT.func_74767_n("onetime");
    }

    public void save() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            File f;
            File save = DimensionManager.getCurrentSaveRootDirectory();
            String name = "musicbox@" + String.format("%d,%d,%d", this.field_145851_c, this.field_145848_d, this.field_145849_e) + ".rcmusic";
            File dir = new File(save.getPath() + "/RotaryCraft/");
            if (!dir.exists()) {
                dir.mkdir();
            }
            if ((f = new File(save.getPath() + "/RotaryCraft/" + name)).exists()) {
                f.delete();
            }
            f.createNewFile();
            PrintWriter p = new PrintWriter(f);
            f.createNewFile();
            int length = this.getMusicLength();
            for (int i = 0; i < length; ++i) {
                for (int k = 0; k < 16; ++k) {
                    if (this.musicQueue[k].size() > i) {
                        Note n = this.musicQueue[k].get(i);
                        String s = n.toSerialString();
                        p.append(s + ";");
                        continue;
                    }
                    p.append("-;");
                }
                p.append("\n");
            }
            p.close();
        }
        catch (Exception e) {
            ReikaChatHelper.write((Object)(e.getCause() + " caused the save to fail!"));
            e.printStackTrace();
        }
    }

    public boolean hasSavedFile() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        File save = DimensionManager.getCurrentSaveRootDirectory();
        String base = save.getPath();
        String name = "musicbox@" + String.format("%d,%d,%d", this.field_145851_c, this.field_145848_d, this.field_145849_e) + ".rcmusic";
        File f = new File(base + "/RotaryCraft/" + name);
        return f.exists();
    }

    public void read() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        File save = DimensionManager.getCurrentSaveRootDirectory();
        String name = "musicbox@" + String.format("%d,%d,%d", this.field_145851_c, this.field_145848_d, this.field_145849_e) + ".rcmusic";
        String path = save.getPath() + "/RotaryCraft/" + name;
        this.readFile(path, false);
    }

    private void readFile(String path, boolean internal) {
        this.clearMusic();
        int linecount = -1;
        try {
            BufferedReader p = internal ? new BufferedReader(new InputStreamReader(RotaryCraft.class.getResourceAsStream(path))) : ReikaFileReader.getReader((String)path);
            String line = p.readLine();
            while (line != null) {
                ++linecount;
                String[] pieces = line.split(";");
                for (int i = 0; i < 16; ++i) {
                    Note n = Note.getFromSerialString(pieces[i]);
                    if (n == null) continue;
                    this.musicQueue[i].add(n);
                }
                line = p.readLine();
            }
            p.close();
        }
        catch (Exception e) {
            if (linecount >= 0) {
                RotaryCraft.logger.log((Object)("LINE " + linecount + ":\n"));
            }
            e.printStackTrace();
            ReikaChatHelper.write((Object)(e.getMessage() + " caused the read to fail!"));
        }
    }

    public void loadDemo() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        String path = "Resources/demomusic.rcmusic";
        this.readFile(path, true);
        this.isOneTimePlaying = true;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MUSICBOX;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void setMusicFromDisc(ItemStack is) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (is.func_77973_b() != ItemRegistry.DISK.getItemInstance()) {
            return;
        }
        if (is.field_77990_d == null) {
            return;
        }
        this.clearMusic();
        try {
            for (int i = 0; i < 16; ++i) {
                if (!is.field_77990_d.func_74764_b("ch" + i)) continue;
                NBTTagList li = is.field_77990_d.func_150295_c("ch" + i, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
                for (int k = 0; k < li.func_74745_c(); ++k) {
                    NBTTagCompound nbt = li.func_150305_b(k);
                    Note n = Note.readFromNBT(nbt);
                    this.addNote(i, n);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMusicToDisk(ItemStack is) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (is.func_77973_b() != ItemRegistry.DISK.getItemInstance()) {
            return;
        }
        is.field_77990_d = new NBTTagCompound();
        for (int i = 0; i < 16; ++i) {
            NBTTagList li = new NBTTagList();
            ArrayList<Note> channel = this.musicQueue[i];
            for (int k = 0; k < channel.size(); ++k) {
                Note n = channel.get(k);
                NBTTagCompound nbt = n.writeToNBT();
                li.func_74742_a((NBTBase)nbt);
            }
            is.field_77990_d.func_74782_a("ch" + i, (NBTBase)li);
        }
    }

    private void deleteFiles(int x, int y, int z) {
        File save = DimensionManager.getCurrentSaveRootDirectory();
        String name = "musicbox@" + String.format("%d,%d,%d", this.field_145851_c, this.field_145848_d, this.field_145849_e) + ".rcmusic";
        File f = new File(save.getPath() + "/RotaryCraft/" + name);
        if (f.exists()) {
            f.delete();
        }
    }

    public void breakBlock() {
        this.deleteFiles(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean trigger() {
        this.startPlaying();
        return true;
    }

    public static enum Instrument {
        REST(0, -1),
        GUITAR(1, 18),
        BASS(2, 32),
        PLING(3, 98),
        BASSDRUM(4, 116),
        SNARE(5, 48),
        CLAVE(6, 0);

        public final int index;
        public final int MIDIvalue;

        private Instrument(int index, int mid) {
            this.index = index;
            this.MIDIvalue = mid;
        }

        public boolean isPitched() {
            return this.index < 4;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum NoteLength {
        WHOLE(48),
        HALF(24),
        QUARTER(12),
        EIGHTH(6),
        SIXTEENTH(3);

        public final int tickLength;

        private NoteLength(int length) {
            this.tickLength = length;
        }

        public String toString() {
            return ReikaStringParser.capFirstChar((String)this.name());
        }
    }

    public static final class Note {
        public final NoteLength length;
        public final int pitch;
        public final Instrument voice;
        private static final String[] notes = new String[]{"C", "C#", "D", "Eb", "E", "F", "F#", "G", "G#", "A", "Bb", "B"};

        public Note(NoteLength length, int pitch, Instrument voice) {
            this.length = length;
            this.pitch = pitch;
            this.voice = voice;
        }

        public static String getNoteName(int pitch) {
            return notes[pitch % 12];
        }

        public String getName() {
            return notes[this.pitch % 12];
        }

        public int getTickLength() {
            return this.length.tickLength;
        }

        public boolean isRest() {
            return this.pitch < 0;
        }

        public Note getRest() {
            return new Note(this.length, -1, this.voice);
        }

        public void play(TileEntityMusicBox te) {
            this.play(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }

        public void play(World world, int x, int y, int z) {
            String pit;
            if (this.isRest()) {
                return;
            }
            float pitch = (float)Math.pow(2.0, (double)(this.pitch - 24) / 12.0);
            float volume = 2.0f;
            if (pitch < 0.5f) {
                pitch *= 2.0f;
                pit = "low";
            } else if (pitch > 2.0f) {
                pitch *= 0.25f;
                pit = "hi";
            } else {
                pit = "";
            }
            switch (this.voice) {
                case GUITAR: {
                    SoundRegistry.getNoteFromVoiceAndPitch(SoundRegistry.HARP, pit).playSoundAtBlock(world, x, y, z, volume, pitch);
                    break;
                }
                case BASS: {
                    SoundRegistry.getNoteFromVoiceAndPitch(SoundRegistry.BASS, pit).playSoundAtBlock(world, x, y, z, volume, pitch);
                    break;
                }
                case PLING: {
                    SoundRegistry.getNoteFromVoiceAndPitch(SoundRegistry.PLING, pit).playSoundAtBlock(world, x, y, z, volume, pitch);
                    break;
                }
                case BASSDRUM: {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.bd", volume, pitch);
                    break;
                }
                case SNARE: {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.snare", volume, pitch);
                    break;
                }
                case CLAVE: {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.hat", volume, pitch);
                    break;
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof Note) {
                Note n = (Note)o;
                return n.length == this.length && n.pitch == this.pitch && n.voice == this.voice;
            }
            return false;
        }

        public String toString() {
            if (this.isRest()) {
                return ReikaStringParser.capFirstChar((String)this.length.name()) + " Rest";
            }
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.voice);
            sb.append(" plays ");
            sb.append((Object)this.length);
            sb.append(" ");
            sb.append(this.pitch);
            return sb.toString();
        }

        public String toSerialString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.length.ordinal());
            sb.append(":");
            sb.append(this.pitch);
            sb.append(":");
            sb.append(this.voice.ordinal());
            return sb.toString();
        }

        protected static Note getFromSerialString(String s) {
            if (s.equals("-")) {
                return null;
            }
            String[] sgs = s.split(":");
            int l1 = Integer.parseInt(sgs[0]);
            int note = Integer.parseInt(sgs[1]);
            int i1 = Integer.parseInt(sgs[2]);
            return new Note(NoteLength.values()[l1], note, Instrument.values()[i1]);
        }

        public static Note readFromNBT(NBTTagCompound NBT) {
            int length = NBT.func_74762_e("len");
            int pitch = NBT.func_74762_e("pch");
            int voice = NBT.func_74762_e("vc");
            return new Note(NoteLength.values()[length], pitch, Instrument.values()[voice]);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            NBT.func_74768_a("len", this.length.ordinal());
            NBT.func_74768_a("pch", this.pitch);
            NBT.func_74768_a("vc", this.voice.ordinal());
            return NBT;
        }

        public ReikaMusicHelper.MusicKey getMusicKey() {
            return ReikaMusicHelper.MusicKey.getByIndex((int)(ReikaMusicHelper.MusicKey.F2.ordinal() + this.pitch));
        }
    }
}

