/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.DMI;

import Reika.DragonAPI.IO.ReikaImageLoader;
import Reika.DragonAPI.Instantiable.Rendering.PixelRenderer;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.ModelProjector;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityProjector;
import java.awt.Color;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderProjector
extends RotaryTERenderer {
    private PixelRenderer p = new PixelRenderer(0.0, 0.0, 0.0, false, 112, 80, 7.0, 5.0, false);
    private ModelProjector ProjectorModel = new ModelProjector();
    private boolean[] hasImages = new boolean[24];

    public RenderProjector() {
        for (int i = 0; i < this.hasImages.length; ++i) {
            String name = "/Reika/RotaryCraft/Textures/Projector/image" + String.valueOf(i) + ".png";
            if (!ReikaImageLoader.imageFileExists(RotaryCraft.class, (String)name)) continue;
            this.hasImages[i] = true;
        }
    }

    public void renderTileEntityProjectorAt(TileEntityProjector tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelProjector var14 = this.ProjectorModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/projtex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 270;
                    break;
                }
                case 3: {
                    var11 = 90;
                }
            }
            GL11.glRotatef((float)((float)var11 + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glEnable((int)2896);
        }
        var14.renderAll((TileEntity)tile, null, 0.0f, 0.0f);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityProjectorAt((TileEntityProjector)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
            this.renderScreen((TileEntityProjector)tile, par2, par4, par6);
            ReikaRenderHelper.exitGeoDraw();
        }
    }

    private void renderScreen(TileEntityProjector te, double p2, double p4, double p6) {
        if (te == null) {
            return;
        }
        if (!te.on) {
            return;
        }
        ReikaRenderHelper.prepareGeoDraw((boolean)false);
        Tessellator v5 = Tessellator.field_78398_a;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = (double)(-te.getRange()) - 0.001;
        if (d > 11.999) {
            d = 11.999;
        }
        if (d < -11.999) {
            d = -11.999;
        }
        if (te.getRange() == 0) {
            return;
        }
        if (!te.canShow()) {
            return;
        }
        switch (te.func_145832_p()) {
            case 0: {
                a = d;
                b = 2.0;
                c = 3.0;
                break;
            }
            case 1: {
                a = -d;
                b = 2.0;
                c = 3.0;
                break;
            }
            case 2: {
                a = 3.0;
                b = 2.0;
                c = d;
                break;
            }
            case 3: {
                a = 3.0;
                b = 2.0;
                c = -d;
            }
        }
        double voffset = b;
        if (ConfigRegistry.PROJECTORLINES.getState()) {
            this.drawBeam(voffset, te.func_145832_p(), v5, a, b, c, p2, p4, p6, te.channel == -3);
        }
        if (te.channel == -1) {
            this.drawEasterEgg(a, b, c, voffset, te, p2, p4, p6);
            return;
        }
        if (te.channel == -3) {
            this.drawClock(a, b, c, voffset, te, p2, p4, p6);
            return;
        }
        if (te.channel != -2 && (te.emptySlide || te.channel < 0 || te.channel >= this.hasImages.length || !this.hasImages[te.channel])) {
            this.renderErrorScreen(a, b, c, voffset, te, p2, p4, p6);
            ReikaRenderHelper.exitGeoDraw();
            return;
        }
        ReikaRenderHelper.exitGeoDraw();
        ReikaRenderHelper.disableLighting();
        if (te.channel == -2) {
            ReikaTextureHelper.bindRawTexture((String)te.getCustomImagePath());
        } else {
            this.bindTextureByName("/Reika/RotaryCraft/Textures/Projector/image" + String.valueOf(te.channel) + ".png");
        }
        GL11.glTranslated((double)0.0, (double)voffset, (double)0.0);
        boolean u = false;
        boolean v = false;
        boolean du = true;
        boolean dv = true;
        if (te.func_145832_p() % 2 == 0) {
            GL11.glFrontFace((int)2304);
        } else {
            u = true;
            du = false;
        }
        if (te.func_145832_p() < 2) {
            v5.func_78382_b();
            v5.func_78374_a(p2 - a, p4 + b + 1.0, p6 - c, (double)du, (double)v);
            v5.func_78374_a(p2 - a, p4 - b, p6 - c, (double)du, (double)dv);
            v5.func_78374_a(p2 - a, p4 - b, p6 + 1.0 + c, (double)u, (double)dv);
            v5.func_78374_a(p2 - a, p4 + b + 1.0, p6 + 1.0 + c, (double)u, (double)v);
            v5.func_78381_a();
        } else {
            v5.func_78382_b();
            v5.func_78374_a(p2 - a, p4 + b + 1.0, p6 - (c *= -1.0), (double)du, (double)v);
            v5.func_78374_a(p2 - a, p4 - b, p6 - c, (double)du, (double)dv);
            v5.func_78374_a(p2 + 1.0 + a, p4 - b, p6 - c, (double)u, (double)dv);
            v5.func_78374_a(p2 + 1.0 + a, p4 + b + 1.0, p6 - c, (double)u, (double)v);
            v5.func_78381_a();
        }
        GL11.glTranslated((double)0.0, (double)(-voffset), (double)0.0);
        ReikaRenderHelper.enableLighting();
        GL11.glFrontFace((int)2305);
    }

    private void drawClock(double a, double b, double c, double voffset, TileEntityProjector te, double p2, double p4, double p6) {
        double r = 2.5;
        Color frame = new Color(0, 127, 255);
        Color hourhand = Color.white;
        Color minutehand = Color.white;
        Color text = new Color(150, 212, 255);
        long time = te.field_145850_b.func_72820_D() + 6000L;
        int perday = (int)(time % 24000L);
        double hour = (double)perday / 1000.0;
        int houri = perday / 1000;
        double minute = (double)(perday - houri * 1000) / 16.67;
        int angph = 30;
        int angpm = 6;
        double angh = hour * (double)angph;
        double angm = minute * (double)angpm;
        double dxh = Math.cos(Math.toRadians(90.0 - angh)) * r * 0.6;
        double dyh = Math.sin(Math.toRadians(90.0 - angh)) * r * 0.6;
        double dxm = Math.cos(Math.toRadians(90.0 - angm)) * r * 0.9;
        double dym = Math.sin(Math.toRadians(90.0 - angm)) * r * 0.9;
        ReikaRenderHelper.prepareGeoDraw((boolean)false);
        GL11.glTranslated((double)0.0, (double)voffset, (double)0.0);
        boolean u = false;
        boolean v = false;
        boolean du = true;
        boolean dv = true;
        Tessellator v5 = Tessellator.field_78398_a;
        if (te.func_145832_p() % 2 == 0) {
            GL11.glFrontFace((int)2304);
        } else {
            u = true;
            du = false;
        }
        GL11.glTranslated((double)p2, (double)p4, (double)p6);
        if (te.func_145832_p() < 2) {
            double d = 0.01;
            if (te.func_145832_p() == 0) {
                d = -0.01;
                dxm = -dxm;
                dxh = -dxh;
            }
            GL11.glTranslated((double)(-a - d), (double)0.5, (double)0.5);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReikaRenderHelper.renderVCircle((double)r, (double)0.0, (double)0.0, (double)0.0, (int)ReikaColorAPI.RGBtoHex((int)frame.getRed(), (int)frame.getGreen(), (int)frame.getBlue()), (double)0.0, (int)5);
            ReikaRenderHelper.renderVCircle((double)(r * 0.015), (double)0.0, (double)0.0, (double)0.0, (int)ReikaColorAPI.RGBtoHex((int)frame.getRed(), (int)frame.getGreen(), (int)frame.getBlue()), (double)0.0, (int)5);
            ReikaRenderHelper.prepareGeoDraw((boolean)false);
            v5.func_78371_b(1);
            v5.func_78376_a(hourhand.getRed(), hourhand.getGreen(), hourhand.getBlue());
            v5.func_78377_a(0.0, 0.0, 0.0);
            v5.func_78377_a(0.0, dyh, dxh);
            v5.func_78381_a();
            v5.func_78371_b(1);
            v5.func_78376_a(minutehand.getRed(), minutehand.getGreen(), minutehand.getBlue());
            v5.func_78377_a(0.0, 0.0, 0.0);
            v5.func_78377_a(0.0, dym, dxm);
            v5.func_78381_a();
            GL11.glEnable((int)3553);
            double s = 0.0625;
            GL11.glScaled((double)s, (double)(-s), (double)(-s));
            if (te.func_145832_p() == 0) {
                GL11.glScaled((double)1.0, (double)1.0, (double)-1.0);
                GL11.glFrontFace((int)2305);
            }
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            int textcolor = text.getRGB();
            this.getFontRenderer().func_78276_b(String.valueOf(12), -5, -38, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(1), 15, -32, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(2), 27, -20, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(3), 32, -3, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(4), 26, 13, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(5), 14, 25, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(6), -2, 31, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(7), -20, 25, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(8), -33, 12, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(9), -37, -3, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(10), -33, -20, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(11), -22, -32, textcolor);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            if (te.func_145832_p() == 0) {
                GL11.glScaled((double)1.0, (double)1.0, (double)-1.0);
            }
            GL11.glFrontFace((int)2305);
            GL11.glScaled((double)(1.0 / s), (double)(-1.0 / s), (double)(-1.0 / s));
            GL11.glTranslated((double)(a + d), (double)-0.5, (double)-0.5);
        } else {
            c *= -1.0;
            double d = 0.01;
            if (te.func_145832_p() == 2) {
                d = -0.01;
                dxm = -dxm;
                dxh = -dxh;
            }
            GL11.glTranslated((double)0.5, (double)0.5, (double)(-c + d));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReikaRenderHelper.renderVCircle((double)r, (double)0.0, (double)0.0, (double)0.0, (int)ReikaColorAPI.RGBtoHex((int)frame.getRed(), (int)frame.getGreen(), (int)frame.getBlue()), (double)90.0, (int)5);
            ReikaRenderHelper.renderVCircle((double)(r * 0.015), (double)0.0, (double)0.0, (double)0.0, (int)ReikaColorAPI.RGBtoHex((int)frame.getRed(), (int)frame.getGreen(), (int)frame.getBlue()), (double)90.0, (int)5);
            ReikaRenderHelper.prepareGeoDraw((boolean)false);
            v5.func_78371_b(1);
            v5.func_78376_a(hourhand.getRed(), hourhand.getGreen(), hourhand.getBlue());
            v5.func_78377_a(0.0, 0.0, 0.0);
            v5.func_78377_a(dxh, dyh, 0.0);
            v5.func_78381_a();
            v5.func_78371_b(1);
            v5.func_78376_a(minutehand.getRed(), minutehand.getGreen(), minutehand.getBlue());
            v5.func_78377_a(0.0, 0.0, 0.0);
            v5.func_78377_a(dxm, dym, 0.0);
            v5.func_78381_a();
            GL11.glEnable((int)3553);
            double s = 0.0625;
            GL11.glScaled((double)s, (double)(-s), (double)(-s));
            if (te.func_145832_p() == 2) {
                GL11.glScaled((double)-1.0, (double)1.0, (double)1.0);
                GL11.glFrontFace((int)2305);
            }
            int textcolor = text.getRGB();
            this.getFontRenderer().func_78276_b(String.valueOf(12), -5, -38, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(1), 15, -32, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(2), 27, -20, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(3), 32, -3, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(4), 26, 13, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(5), 14, 25, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(6), -2, 31, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(7), -20, 25, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(8), -33, 12, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(9), -37, -3, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(10), -33, -20, textcolor);
            this.getFontRenderer().func_78276_b(String.valueOf(11), -22, -32, textcolor);
            if (te.func_145832_p() == 2) {
                GL11.glScaled((double)-1.0, (double)1.0, (double)1.0);
            }
            GL11.glFrontFace((int)2305);
            GL11.glScaled((double)(1.0 / s), (double)(-1.0 / s), (double)(-1.0 / s));
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)(c - d));
        }
        GL11.glTranslated((double)(-p2), (double)(-p4), (double)(-p6));
        GL11.glTranslated((double)0.0, (double)(-voffset), (double)0.0);
        ReikaRenderHelper.exitGeoDraw();
        GL11.glFrontFace((int)2305);
    }

    private void drawEasterEgg(double a, double b, double c, double voffset, TileEntityProjector te, double p2, double p4, double p6) {
        ReikaRenderHelper.exitGeoDraw();
        ReikaRenderHelper.disableLighting();
        GL11.glEnable((int)3553);
        GL11.glTranslated((double)0.0, (double)voffset, (double)0.0);
        switch (te.func_145832_p()) {
            case 0: {
                this.p.setMirror(false);
                this.p.setFlip(false);
                this.p.setPlane(false);
                this.p.setPosition(p2 - a, p4 + b + 1.0, p6 + c - 6.0);
                break;
            }
            case 1: {
                this.p.setMirror(true);
                this.p.setFlip(true);
                this.p.setPlane(false);
                this.p.setPosition(p2 - a, p4 + b + 1.0, p6 + c - 6.0);
                break;
            }
            case 2: {
                this.p.setMirror(false);
                this.p.setFlip(false);
                this.p.setPlane(true);
                this.p.setPosition(p2 + c - 6.0, p4 + b + 1.0, p6 - a);
                break;
            }
            case 3: {
                this.p.setMirror(true);
                this.p.setFlip(true);
                this.p.setPlane(true);
                this.p.setPosition(p2 + c - 6.0, p4 + b + 1.0, p6 - a);
            }
        }
        if (te.func_145832_p() == 2) {
            GL11.glTranslated((double)(te.getRange() + 3), (double)0.0, (double)(-0.001 - (double)te.getRange() + 3.0));
        }
        if (te.func_145832_p() == 3) {
            GL11.glTranslated((double)(-te.getRange() + 3), (double)0.0, (double)(0.001 + (double)te.getRange() + 3.0));
        }
        this.p.setColor(Color.BLACK);
        this.p.draw(48, 0, 63, 1);
        this.p.draw(46, 2, 49, 3);
        this.p.draw(62, 2, 65, 3);
        this.p.draw(46, 2, 47, 17);
        this.p.draw(64, 2, 65, 17);
        this.p.draw(46, 16, 49, 17);
        this.p.draw(62, 16, 65, 17);
        this.p.draw(48, 18, 51, 19);
        this.p.draw(60, 18, 63, 19);
        this.p.draw(50, 18, 51, 41);
        this.p.draw(60, 18, 61, 41);
        this.p.draw(48, 40, 51, 41);
        this.p.draw(60, 40, 63, 41);
        this.p.draw(46, 42, 49, 43);
        this.p.draw(62, 42, 65, 43);
        this.p.draw(40, 44, 47, 45);
        this.p.draw(64, 44, 71, 45);
        this.p.draw(38, 46, 41, 47);
        this.p.draw(70, 46, 73, 47);
        this.p.draw(36, 48, 39, 49);
        this.p.draw(72, 48, 75, 49);
        this.p.draw(34, 50, 37, 51);
        this.p.draw(74, 50, 77, 51);
        this.p.draw(32, 52, 35, 53);
        this.p.draw(76, 52, 79, 53);
        this.p.draw(30, 54, 33, 55);
        this.p.draw(78, 54, 81, 55);
        this.p.draw(30, 54, 31, 61);
        this.p.draw(80, 54, 81, 61);
        this.p.draw(30, 60, 33, 61);
        this.p.draw(78, 60, 81, 61);
        this.p.draw(32, 62, 35, 63);
        this.p.draw(76, 62, 79, 63);
        this.p.draw(34, 64, 37, 65);
        this.p.draw(74, 64, 77, 65);
        this.p.draw(36, 66, 43, 67);
        this.p.draw(68, 66, 75, 67);
        this.p.draw(42, 66, 43, 73);
        this.p.draw(68, 66, 69, 73);
        this.p.draw(36, 72, 43, 73);
        this.p.draw(68, 72, 75, 73);
        this.p.draw(34, 74, 37, 75);
        this.p.draw(74, 74, 77, 75);
        this.p.draw(34, 74, 35, 79);
        this.p.draw(76, 74, 77, 79);
        this.p.draw(34, 78, 53, 79);
        this.p.draw(58, 78, 77, 79);
        this.p.draw(52, 70, 53, 79);
        this.p.draw(58, 70, 59, 79);
        this.p.draw(52, 70, 59, 71);
        this.p.setColor(84, 252, 84, 255);
        this.p.draw(60, 2, 61, 17);
        this.p.draw(62, 4, 63, 15);
        this.p.draw(56, 18, 59, 41);
        this.p.draw(52, 42, 61, 53);
        this.p.draw(48, 46, 51, 53);
        this.p.draw(40, 50, 47, 53);
        this.p.draw(36, 54, 39, 61);
        this.p.draw(40, 58, 41, 61);
        this.p.draw(42, 60, 43, 61);
        this.p.draw(62, 44, 63, 53);
        this.p.draw(64, 46, 69, 53);
        this.p.draw(70, 48, 71, 53);
        this.p.draw(72, 50, 73, 65);
        this.p.draw(74, 52, 75, 63);
        this.p.draw(76, 54, 77, 61);
        this.p.draw(78, 56, 79, 59);
        this.p.draw(70, 58, 71, 65);
        this.p.draw(68, 60, 69, 65);
        this.p.draw(66, 62, 67, 63);
        this.p.draw(64, 64, 67, 65);
        this.p.draw(44, 62, 45, 65);
        this.p.draw(52, 42, 61, 53);
        this.p.draw(46, 64, 47, 65);
        this.p.draw(52, 42, 61, 53);
        this.p.draw(48, 66, 67, 69);
        this.p.draw(48, 70, 51, 77);
        this.p.draw(40, 74, 47, 77);
        this.p.draw(64, 70, 67, 77);
        this.p.draw(68, 74, 73, 77);
        this.p.draw(74, 76, 75, 77);
        this.p.setColor(0, 168, 0, 255);
        this.p.draw(50, 2, 51, 17);
        this.p.draw(48, 4, 49, 15);
        this.p.draw(52, 18, 55, 41);
        this.p.draw(50, 42, 51, 45);
        this.p.draw(48, 44, 49, 45);
        this.p.draw(42, 46, 47, 49);
        this.p.draw(40, 48, 41, 49);
        this.p.draw(38, 50, 39, 53);
        this.p.draw(36, 52, 37, 53);
        this.p.draw(34, 54, 35, 61);
        this.p.draw(32, 56, 33, 59);
        this.p.draw(36, 62, 43, 63);
        this.p.draw(38, 64, 43, 65);
        this.p.draw(44, 66, 47, 73);
        this.p.draw(36, 76, 37, 77);
        this.p.draw(38, 74, 39, 77);
        this.p.draw(60, 70, 63, 77);
        this.p.setColor(Color.WHITE);
        this.p.draw(52, 2, 59, 5);
        this.p.draw(52, 14, 59, 17);
        this.p.draw(52, 62, 59, 65);
        this.p.setColor(Color.BLACK);
        this.p.draw(52, 6, 59, 13);
        this.p.draw(40, 54, 71, 57);
        this.p.draw(42, 58, 69, 59);
        this.p.draw(44, 60, 67, 61);
        this.p.draw(46, 62, 51, 63);
        this.p.draw(60, 62, 65, 63);
        this.p.draw(48, 64, 51, 65);
        this.p.draw(60, 64, 63, 65);
        if (te.func_145832_p() == 2) {
            GL11.glTranslated((double)(-te.getRange() - 3), (double)0.0, (double)(0.001 + (double)te.getRange() - 3.0));
        }
        if (te.func_145832_p() == 3) {
            GL11.glTranslated((double)(te.getRange() + 3), (double)0.0, (double)(-0.001 - (double)te.getRange() - 3.0));
        }
        GL11.glTranslated((double)0.0, (double)(-voffset), (double)0.0);
        ReikaRenderHelper.enableLighting();
    }

    private void renderErrorScreen(double a, double b, double c, double voffset, TileEntityProjector te, double p2, double p4, double p6) {
        ReikaRenderHelper.disableLighting();
        GL11.glPushMatrix();
        GL11.glTranslated((double)p2, (double)(p4 + 2.0), (double)(p6 + 1.0));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78376_a(255, 255, 255);
        GL11.glTranslated((double)0.0, (double)voffset, (double)0.0);
        double h = 1.0 + 2.0 * b;
        if (te.func_145832_p() < 2) {
            double w = 1.0 + 2.0 * c;
            this.drawError(te.func_145832_p() == 1, v5, a, b, c, p2, p4, p6, w, h);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(w - 1.0));
        } else {
            double w = 1.0 + 2.0 * a;
            this.drawError2(te.func_145832_p() == 3, v5, a, b, c, p2, p4, p6, w, h);
            GL11.glTranslated((double)(w - 1.0), (double)0.0, (double)0.0);
        }
        GL11.glEnable((int)3553);
        GL11.glTranslated((double)0.0, (double)(-voffset), (double)0.0);
        ReikaRenderHelper.enableLighting();
    }

    private void drawBeam(double vo, int meta, Tessellator v5, double a, double b, double c, double p2, double p4, double p6, boolean circle) {
        if (circle) {
            return;
        }
        switch (meta) {
            case 0: {
                v5.func_78371_b(2);
                v5.func_78377_a(p2, p4 + 0.5, p6 + 0.4375);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 - c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2, p4 + 0.5, p6 + 0.5625);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + 1.0 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2, p4 + 0.375, p6 + 0.5625);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + 1.0 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2, p4 + 0.375, p6 + 0.4375);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 - c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 - c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 - c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + 1.0 + c);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + 1.0 + c);
                v5.func_78381_a();
                break;
            }
            case 1: {
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 1.0, p4 + 0.5, p6 + 0.4375);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 - c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 1.0, p4 + 0.5, p6 + 0.5625);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + 1.0 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 1.0, p4 + 0.375, p6 + 0.5625);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + 1.0 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 1.0, p4 + 0.375, p6 + 0.4375);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 - c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 - c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 - c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + 1.0 + c);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + 1.0 + c);
                v5.func_78381_a();
                break;
            }
            case 2: {
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.5625, p4 + 0.5, p6 + 1.0);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.4375, p4 + 0.5, p6 + 1.0);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.5625, p4 + 0.375, p6 + 1.0);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 - b, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.4375, p4 + 0.375, p6 + 1.0);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + c);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 - b, p6 + c);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
                break;
            }
            case 3: {
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.5625, p4 + 0.5, p6);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.4375, p4 + 0.5, p6);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.5625, p4 + 0.375, p6);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 - b, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 + 0.4375, p4 + 0.375, p6);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + c);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78377_a(p2 - a, vo + p4 + b + 1.0, p6 + c);
                v5.func_78377_a(p2 - a, vo + p4 - b, p6 + c);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 - b, p6 + c);
                v5.func_78377_a(p2 + a + 1.0, vo + p4 + b + 1.0, p6 + c);
                v5.func_78381_a();
            }
        }
    }

    private void drawError(boolean flip, Tessellator v5, double a, double b, double c, double p2, double p4, double p6, double w, double h) {
        GL11.glColor3d((double)0.8, (double)0.8, (double)0.8);
        if (flip) {
            c *= -1.0;
            GL11.glTranslated((double)0.0, (double)0.0, (double)((w *= -1.0) / 7.0));
        }
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)w);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        GL11.glColor3d((double)0.8, (double)0.8, (double)0.8);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 7.0));
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.67, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        double bscale = 0.17857;
        GL11.glTranslated((double)0.0, (double)0.0, (double)(w - 1.0));
        if (flip) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-w * 2.0 / 7.0));
        }
        GL11.glColor3d((double)0.0235, (double)0.2431, (double)0.349);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w * bscale);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w * bscale);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w * bscale));
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w * bscale);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w * bscale);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w * bscale));
        GL11.glColor3d((double)0.2313, (double)0.0, (double)0.494);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w * bscale);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w * bscale);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w * bscale));
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w * bscale);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w * bscale);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w * bscale));
        GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w / 21.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 21.0);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 21.0));
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w / 21.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 21.0);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 21.0));
        GL11.glColor3d((double)0.153, (double)0.153, (double)0.153);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w / 21.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 21.0);
        v5.func_78381_a();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-w / 21.0));
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h, p6 + c + 1.0 - w / 7.0);
        v5.func_78377_a(p2 - a, p4 + b + 1.0 - h * 0.75, p6 + c + 1.0 - w / 7.0);
        v5.func_78381_a();
        if (flip) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)(w - 4.0));
        }
    }

    private void drawError2(boolean flip, Tessellator v5, double a, double b, double c, double p2, double p4, double p6, double w, double h) {
        GL11.glColor3d((double)0.8, (double)0.8, (double)0.8);
        double bscale = 0.17857;
        c *= -1.0;
        if (flip) {
            a *= -1.0;
            GL11.glTranslated((double)((w *= -1.0) / 7.0), (double)0.0, (double)0.0);
        }
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)w, (double)0.0, (double)0.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glColor3d((double)0.8, (double)0.8, (double)0.8);
        GL11.glTranslated((double)(-w / 7.0), (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.67, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(w - 1.0), (double)0.0, (double)0.0);
        if (flip) {
            GL11.glTranslated((double)(-w * 2.0 / 7.0), (double)0.0, (double)0.0);
        }
        GL11.glColor3d((double)0.0235, (double)0.2431, (double)0.349);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w * bscale), (double)0.0, (double)0.0);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w * bscale), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.2313, (double)0.0, (double)0.494);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w * bscale), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w * bscale, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w * bscale), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w / 21.0), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w / 21.0), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.153, (double)0.153, (double)0.153);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 21.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        GL11.glTranslated((double)(-w / 21.0), (double)0.0, (double)0.0);
        GL11.glColor3d((double)0.0745, (double)0.0745, (double)0.0745);
        v5.func_78382_b();
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78377_a(p2 + a + 1.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h, p6 - c);
        v5.func_78377_a(p2 + a + 1.0 - w / 7.0, p4 + b + 1.0 - h * 0.75, p6 - c);
        v5.func_78381_a();
        if (flip) {
            GL11.glTranslated((double)(w - 4.0), (double)0.0, (double)0.0);
        }
    }

    public String getImageFileName(RenderFetcher te) {
        return "projtex.png";
    }
}

