/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.net.URL;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum SoundRegistry implements SoundEnum
{
    ELECTRIC("#elecengine"),
    WIND("#windengine"),
    STEAM("#steamengine"),
    CAR("#gasengine"),
    HYDRO("#hydroengine"),
    MICRO("#microengine"),
    JET("#jetengine"),
    KNOCKBACK("knockback"),
    PULSEJET("#pulsejet"),
    PUMP("#pump"),
    PILEDRIVER("piledriver"),
    SMOKE("smokealarm"),
    SPRINKLER("#sprinkler"),
    FLYWHEEL("#flywheel"),
    PROJECTOR("projector"),
    LOWBASS("basslo"),
    BASS("bass"),
    HIBASS("basshi"),
    LOWHARP("harplo"),
    HARP("harp"),
    HIHARP("harphi"),
    LOWPLING("plinglo"),
    PLING("pling"),
    HIPLING("plinghi"),
    FRICTION("#friction"),
    CRAFT("#craft"),
    AIRCOMP("#compress"),
    PNEUMATIC("#pneu"),
    LINEBUILDER("linebuild"),
    JETPACK("pack"),
    DIESEL("#diesel"),
    BELT("#belt"),
    FAN("#fan"),
    SPARK("spark"),
    DYNAMO("#dynamo"),
    INGESTION("ingest_short"),
    FRIDGE("#fridge"),
    JETSTART("#jetstart"),
    SONIC("#sonic"),
    SHORTJET("shortjet"),
    AFTERBURN("afterburner"),
    RUMBLE("rumble2"),
    COIL("#coil"),
    GATLINGRELOAD("gatlingreload"),
    GATLING("gatling");

    public static final SoundRegistry[] soundList;
    public static final String PREFIX = "Reika/RotaryCraft/";
    public static final String SOUND_FOLDER = "Sounds/";
    private static final String SOUND_PREFIX = "Reika.RotaryCraft.Sounds.";
    private static final String SOUND_DIR = "Sounds/";
    private static final String SOUND_EXT = ".ogg";
    private static final String MUSIC_FOLDER = "music/";
    private static final String MUSIC_PREFIX = "music.";
    private final String path;
    private final String name;
    private boolean isVolumed = false;

    private SoundRegistry(String n2) {
        if (n2.startsWith("#")) {
            this.isVolumed = true;
            n2 = n2.substring(1);
        }
        this.name = n2;
        this.path = this.isNote() ? "Reika/RotaryCraft/Sounds/music/" + this.name + SOUND_EXT : "Reika/RotaryCraft/Sounds/" + this.name + SOUND_EXT;
    }

    public float getSoundVolume() {
        float vol = ConfigRegistry.MACHINEVOLUME.getFloat();
        if (this.isEngineSound()) {
            vol *= ConfigRegistry.ENGINEVOLUME.getFloat();
        }
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        return vol;
    }

    public float getModulatedVolume() {
        if (!this.isVolumed) {
            return 1.0f;
        }
        return this.getSoundVolume();
    }

    public void playSound(Entity e) {
        this.playSound(e, 1.0f, 1.0f);
    }

    public void playSound(Entity e, float vol, float pitch) {
        this.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (String)"RotaryCraftData", (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch, boolean attenuate) {
        if (world.field_72995_K) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (String)"RotaryCraftData", (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)attenuate);
    }

    public void playSoundAtBlock(World world, int x, int y, int z, float vol, float pitch) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
    }

    public void playSoundAtBlock(World world, int x, int y, int z) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, 1.0f);
    }

    public void playSoundAtBlock(TileEntity te) {
        this.playSoundAtBlock(te, 1.0f, 1.0f);
    }

    public void playSoundAtBlock(TileEntity te, float vol, float pitch) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, vol, pitch);
    }

    public void playSoundAtBlock(WorldLocation loc) {
        this.playSoundAtBlock(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public String getName() {
        return this.name();
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL() {
        if (this.isNote()) {
            return RotaryCraft.class.getResource("Sounds/music/" + this.name + SOUND_EXT);
        }
        return RotaryCraft.class.getResource("Sounds/" + this.name + SOUND_EXT);
    }

    public boolean isNote() {
        return this.name().contains("HARP") || this.name().contains("BASS") || this.name().contains("PLING");
    }

    public static SoundRegistry getNoteFromVoiceAndPitch(SoundRegistry voice, String pitch) {
        return SoundRegistry.getSoundByName(pitch.toUpperCase() + voice.name());
    }

    public static SoundRegistry getSoundByName(String name) {
        for (int i = 0; i < soundList.length; ++i) {
            if (!soundList[i].name().equals(name)) continue;
            return soundList[i];
        }
        RotaryCraft.logger.logError((Object)("\"" + name + "\" does not correspond to a registered sound!"));
        return null;
    }

    public SoundCategory getCategory() {
        return SoundCategory.MASTER;
    }

    public boolean canOverlap() {
        return this == JETPACK || this == RUMBLE;
    }

    private boolean isEngineSound() {
        return this.name.endsWith("engine");
    }

    public boolean attenuate() {
        return true;
    }

    public boolean preload() {
        return this == JETSTART;
    }

    static {
        soundList = SoundRegistry.values();
    }
}

