/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum MaterialRegistry {
    WOOD(1.1E7, 6.2E8, 2.0E7, 1.16E7, 800.0),
    STONE(5.0E10, 8.0E9, 1.0E8, 4.0E7, 3000.0),
    STEEL(2.1E11, 7.93E10, 4.0E8, 2.8E8, 7800.0),
    DIAMOND(1.22E12, 4.78E11, 5.0E9, 2.9E9, 3500.0),
    BEDROCK(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 3000.0);

    private double Emod;
    private double Smod;
    private double tensile;
    private double shear;
    private double rho;
    public static final MaterialRegistry[] matList;

    private MaterialRegistry(double E, double G, double TS, double S, double den) {
        this.Emod = E;
        this.Smod = G;
        this.tensile = TS;
        this.shear = S;
        this.rho = den;
    }

    public static MaterialRegistry setType(int type) {
        return matList[type];
    }

    public double getElasticModulus() {
        return this.Emod;
    }

    public double getShearModulus() {
        return this.Smod;
    }

    public double getTensileStrength() {
        return this.tensile;
    }

    public double getShearStrength() {
        return this.shear;
    }

    public double getDensity() {
        return this.rho;
    }

    public boolean isDamageableGear() {
        return !this.isInfiniteStrength();
    }

    public boolean isInfiniteStrength() {
        return this == BEDROCK;
    }

    public boolean needsLubricant() {
        return this != WOOD && this.isDamageableGear();
    }

    public boolean consumesLubricant() {
        return this == STONE || this == STEEL;
    }

    public boolean takesTemperatureDamage() {
        return this == WOOD || this == STONE;
    }

    public boolean isFlammable() {
        return this == WOOD;
    }

    public String getDamageNoise() {
        if (this == WOOD) {
            return "dig.wood";
        }
        if (this == STONE) {
            return "dig.stone";
        }
        return "mob.blaze.hit";
    }

    public boolean isHarvestablePickaxe(ItemStack tool) {
        if (this == WOOD) {
            return true;
        }
        if (tool == null) {
            return false;
        }
        Item item = tool.func_77973_b();
        if (item == ItemRegistry.BEDPICK.getItemInstance()) {
            return true;
        }
        if (item == ItemRegistry.STEELPICK.getItemInstance()) {
            return this != BEDROCK;
        }
        if (item instanceof ItemPickaxe) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return item.canHarvestBlock(Blocks.field_150366_p, tool);
                }
                case DIAMOND: {
                    return item.canHarvestBlock(Blocks.field_150482_ag, tool);
                }
                case BEDROCK: {
                    return item.canHarvestBlock(Blocks.field_150343_Z, tool);
                }
            }
            return false;
        }
        if (TinkerToolHandler.getInstance().isPick(tool)) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return TinkerToolHandler.getInstance().isStoneOrBetter(tool);
                }
                case DIAMOND: {
                    return TinkerToolHandler.getInstance().isIronOrBetter(tool);
                }
                case BEDROCK: {
                    return TinkerToolHandler.getInstance().isDiamondOrBetter(tool);
                }
            }
            return false;
        }
        if (MekToolHandler.getInstance().isPickTypeTool(tool)) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return item.canHarvestBlock(Blocks.field_150366_p, tool);
                }
                case DIAMOND: {
                    return item.canHarvestBlock(Blocks.field_150482_ag, tool);
                }
                case BEDROCK: {
                    return item.canHarvestBlock(Blocks.field_150343_Z, tool);
                }
            }
            return false;
        }
        if (item == RedstoneArsenalHandler.getInstance().pickID) {
            return RedstoneArsenalHandler.getInstance().pickLevel >= this.ordinal() - 1;
        }
        switch (this) {
            case STONE: {
                return item.canHarvestBlock(Blocks.field_150348_b, tool);
            }
            case STEEL: {
                return item.canHarvestBlock(Blocks.field_150366_p, tool);
            }
            case DIAMOND: {
                return item.canHarvestBlock(Blocks.field_150482_ag, tool);
            }
            case BEDROCK: {
                return item.canHarvestBlock(Blocks.field_150343_Z, tool);
            }
        }
        return false;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("material." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public double getMaxShaftTorque() {
        if (this.isInfiniteStrength()) {
            return Double.POSITIVE_INFINITY;
        }
        double r = 0.0625;
        double tau = this.getShearStrength();
        return 1.5707963267948966 * r * r * r * tau / 16.0;
    }

    public double getMaxShaftSpeed() {
        if (this.isInfiniteStrength()) {
            return Double.POSITIVE_INFINITY;
        }
        double f = 1.0 / (1.0 - 0.11 * (double)this.ordinal());
        double rho = this.getDensity();
        double r = 0.0625;
        double sigma = this.getTensileStrength();
        double base = Math.sqrt(2.0 * sigma / (rho * r * r));
        return Math.pow(base, f);
    }

    public static int[] getAllLimitLoads() {
        int[] loads = new int[matList.length * 2 - 2];
        for (int i = 0; i < loads.length; i += 2) {
            int j = i / 2;
            MaterialRegistry m = matList[j];
            loads[i] = (int)m.getMaxShaftTorque();
            loads[i + 1] = (int)m.getMaxShaftSpeed();
        }
        return loads;
    }

    public ItemStack getShaftItem() {
        return MachineRegistry.SHAFT.getCraftedMetadataProduct(this.ordinal());
    }

    public ItemStack getGearboxItem(int ratio) {
        int type = this.ordinal();
        ratio = (int)ReikaMathLibrary.logbase((long)ratio, (int)2) - 1;
        return MachineRegistry.GEARBOX.getCraftedMetadataProduct(5 * ratio + type);
    }

    public static MaterialRegistry getMaterialFromItem(ItemStack is) {
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftitem)) {
            return STEEL;
        }
        if (ItemRegistry.SHAFTCRAFT.matchItem(is)) {
            if (ReikaMathLibrary.isValueInsideBoundsIncl((int)ItemStacks.gearunit.func_77960_j(), (int)ItemStacks.gearunit16.func_77960_j(), (int)is.func_77960_j())) {
                return STEEL;
            }
        } else {
            if (ItemRegistry.GEARUNITS.matchItem(is)) {
                int dmg = is.func_77960_j() / 4;
                return dmg > 1 ? matList[dmg + 1] : matList[dmg];
            }
            if (is.func_77973_b() == Items.field_151055_y) {
                return WOOD;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.stonerod)) {
                return STONE;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.diamondshaft)) {
                return DIAMOND;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.bedrockshaft)) {
                return BEDROCK;
            }
        }
        return null;
    }

    public ItemStack getGearItem() {
        switch (this) {
            case BEDROCK: {
                return ItemStacks.bedrockgear;
            }
            case DIAMOND: {
                return ItemStacks.diamondgear;
            }
            case STEEL: {
                return ItemStacks.steelgear;
            }
            case STONE: {
                return ItemStacks.stonegear;
            }
            case WOOD: {
                return ItemStacks.woodgear;
            }
        }
        return null;
    }

    public ItemStack getGearUnitItem(int ratio) {
        int log = ReikaMathLibrary.logbase2((long)ratio) - 1;
        if (this == STEEL) {
            return ItemRegistry.SHAFTCRAFT.getStackOfMetadata(5 + log);
        }
        int o = this == BEDROCK || this == DIAMOND ? this.ordinal() - 1 : this.ordinal();
        return ItemRegistry.GEARUNITS.getStackOfMetadata(log + o * 4);
    }

    public ItemStack getShaftUnitItem() {
        switch (this) {
            case BEDROCK: {
                return ItemStacks.bedrockshaft;
            }
            case DIAMOND: {
                return ItemStacks.diamondshaft;
            }
            case STEEL: {
                return ItemStacks.shaftitem;
            }
            case STONE: {
                return ItemStacks.stonerod;
            }
            case WOOD: {
                return new ItemStack(Items.field_151055_y);
            }
        }
        return null;
    }

    static {
        matList = MaterialRegistry.values();
    }
}

