/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAimedCannon;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityLaunchCannon;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityHeater;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityMirror;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityMusicBox;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityParticleEmitter;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityProjector;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import Reika.RotaryCraft.TileEntities.Farming.TileEntitySpawnerController;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityAutoCrafter;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityScaleableChest;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityGPR;
import Reika.RotaryCraft.TileEntities.TileEntityBlower;
import Reika.RotaryCraft.TileEntities.TileEntityItemCannon;
import Reika.RotaryCraft.TileEntities.TileEntityItemFilter;
import Reika.RotaryCraft.TileEntities.TileEntityPlayerDetector;
import Reika.RotaryCraft.TileEntities.TileEntityVacuum;
import Reika.RotaryCraft.TileEntities.TileEntityWinder;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBevelGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityMultiClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityContainment;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityForceField;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntitySonicWeapon;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityTNTCannon;
import Reika.RotaryCraft.TileEntities.World.TileEntityDefoliator;
import Reika.RotaryCraft.TileEntities.World.TileEntityTerraformer;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketHandlerCore
implements PacketHandler {
    protected PacketRegistry pack;
    private static final Random rand = new Random();

    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        boolean readinglong = false;
        NBTTagCompound NBT = null;
        String stringdata = null;
        UUID id = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case FULLSOUND: {
                    break;
                }
                case SOUND: {
                    control = inputStream.readInt();
                    SoundRegistry s = SoundRegistry.soundList[control];
                    double sx = inputStream.readDouble();
                    double sy = inputStream.readDouble();
                    double sz = inputStream.readDouble();
                    float v = inputStream.readFloat();
                    float p = inputStream.readFloat();
                    boolean att = inputStream.readBoolean();
                    ReikaSoundHelper.playClientSound((SoundEnum)s, (double)sx, (double)sy, (double)sz, (float)v, (float)p, (boolean)att);
                    return;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    break;
                }
                case DATA: {
                    int i;
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case POS: {
                    int i;
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    dx = inputStream.readDouble();
                    dy = inputStream.readDouble();
                    dz = inputStream.readDouble();
                    int len = this.pack.getNumberDataInts();
                    if (len <= 0) break;
                    data = new int[len];
                    for (i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData((World)world, (int)x, (int)y, (int)z, (String)name, (DataInputStream)inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData((World)world, (int)x, (int)y, (int)z, (String)tank, (int)level);
                    return;
                }
                case RAW: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (int i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case PREFIXED: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = inputStream.readInt();
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case NBT: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    NBT = ((ReikaPacketHelper.DataPacket)packet).asNBT();
                    break;
                }
                case STRINGINT: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    data = new int[this.pack.getNumberDataInts()];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UUID: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    long l1 = inputStream.readLong();
                    long l2 = inputStream.readLong();
                    id = new UUID(l1, l2);
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        try {
            switch (this.pack) {
                case BORER: {
                    TileEntityBorer borer = (TileEntityBorer)te;
                    if (borer != null) {
                        if (control == PacketRegistry.BORER.getMinValue() + 2) {
                            for (int i = 0; i < 5; ++i) {
                                for (int j = 0; j < 7; ++j) {
                                    borer.cutShape[j][i] = !borer.cutShape[j][i];
                                    borer.syncAllData(true);
                                }
                            }
                        }
                        if (control == PacketRegistry.BORER.getMinValue() + 3) {
                            borer.reset();
                        }
                        if (control == PacketRegistry.BORER.getMinValue() + 1) {
                            borer.drops = !borer.drops;
                        }
                        if (control == PacketRegistry.BORER.getMinValue()) {
                            int cols;
                            int roworld;
                            if (data[0] > 0 && data[0] < 100) {
                                roworld = data[0] / 7;
                                cols = data[0] - roworld * 7;
                                borer.cutShape[cols][roworld] = false;
                            }
                            if (data[0] < 0 && data[0] > -100) {
                                roworld = -data[0] / 7;
                                cols = -data[0] - roworld * 7;
                                borer.cutShape[cols][roworld] = true;
                            }
                            if (data[0] == 100) {
                                borer.cutShape[0][0] = false;
                            }
                            if (data[0] == -100) {
                                borer.cutShape[0][0] = true;
                            }
                        }
                    }
                    break;
                }
                case BEVEL: {
                    ((TileEntityBevelGear)te).direction = data[0];
                    break;
                }
                case SPLITTER: {
                    if (control != PacketRegistry.SPLITTER.getMinValue()) break;
                    ((TileEntitySplitter)te).setMode(data[0]);
                    break;
                }
                case SPAWNER: {
                    TileEntitySpawnerController spawner = (TileEntitySpawnerController)te;
                    if (data[0] == -1) {
                        spawner.disable = true;
                        break;
                    }
                    spawner.disable = false;
                    spawner.setDelay = data[0];
                    break;
                }
                case DETECTOR: {
                    ((TileEntityPlayerDetector)te).selectedrange = data[0];
                    break;
                }
                case HEATER: {
                    ((TileEntityHeater)te).setTemperature = data[0];
                    break;
                }
                case CVT: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    if (control == PacketRegistry.CVT.getMinValue()) {
                        adv.isRedstoneControlled = !adv.isRedstoneControlled;
                        break;
                    }
                    if (control == PacketRegistry.CVT.getMinValue() + 1) {
                        if (adv.isRedstoneControlled) {
                            adv.incrementCVTState(true);
                            break;
                        }
                        adv.setRatio(data[0]);
                        break;
                    }
                    if (control == PacketRegistry.CVT.getMinValue() + 2) {
                        adv.incrementCVTState(false);
                    }
                    break;
                }
                case CANNON: {
                    TileEntityLaunchCannon cannon = (TileEntityLaunchCannon)te;
                    if (data[0] == 0) {
                        if (control == PacketRegistry.CANNON.getMinValue()) {
                            cannon.phi = data[1];
                        }
                        if (control == PacketRegistry.CANNON.getMinValue() + 1) {
                            cannon.theta = data[1] > cannon.getMaxTheta() ? cannon.getMaxTheta() : data[1];
                        }
                        if (control == PacketRegistry.CANNON.getMinValue() + 2) {
                            cannon.velocity = data[1] > cannon.getMaxLaunchVelocity() ? cannon.getMaxLaunchVelocity() : data[1];
                        }
                    } else {
                        double ddz;
                        double ddx;
                        double dd;
                        if (control == PacketRegistry.CANNON.getMinValue()) {
                            cannon.target[0] = data[1];
                        }
                        if (control == PacketRegistry.CANNON.getMinValue() + 1) {
                            cannon.target[1] = data[1];
                        }
                        if (control == PacketRegistry.CANNON.getMinValue() + 2) {
                            cannon.target[2] = data[1];
                        }
                        if ((dd = ReikaMathLibrary.py3d((double)(ddx = (double)(cannon.target[0] - cannon.field_145851_c)), (double)0.0, (double)(ddz = (double)(cannon.target[2] - cannon.field_145849_e)))) > cannon.getMaxLaunchDistance()) {
                            cannon.target[0] = cannon.field_145851_c;
                            cannon.target[1] = 512;
                            cannon.target[2] = cannon.field_145849_e;
                        }
                    }
                    if (control == PacketRegistry.CANNON.getMinValue() + 3 && cannon instanceof TileEntityTNTCannon) {
                        ((TileEntityTNTCannon)cannon).selectedFuse = data[1];
                    }
                    break;
                }
                case SONIC: {
                    TileEntitySonicWeapon sonic = (TileEntitySonicWeapon)te;
                    if (control == PacketRegistry.SONIC.getMinValue()) {
                        sonic.setpitch = longdata;
                    }
                    if (control == PacketRegistry.SONIC.getMinValue() + 1) {
                        sonic.setvolume = longdata;
                    }
                    break;
                }
                case FORCE: {
                    ((TileEntityForceField)te).setRange = data[0];
                    break;
                }
                case CHEST: {
                    TileEntityScaleableChest chest = (TileEntityScaleableChest)te;
                    chest.page = data[0];
                    ep.openGui((Object)RotaryCraft.instance, 24000 + data[0], chest.field_145850_b, chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
                    break;
                }
                case COIL: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    if (control == PacketRegistry.COIL.getMinValue()) {
                        adv.setReleaseOmega(data[0]);
                    }
                    if (control != PacketRegistry.COIL.getMinValue() + 1) break;
                    adv.setReleaseTorque(data[0]);
                    break;
                }
                case MUSIC: {
                    TileEntityMusicBox.Note n;
                    TileEntityMusicBox music = (TileEntityMusicBox)te;
                    if (control == PacketRegistry.MUSIC.getMinValue()) {
                        n = new TileEntityMusicBox.Note(TileEntityMusicBox.NoteLength.values()[data[2]], data[0], TileEntityMusicBox.Instrument.values()[data[3]]);
                        for (int i = 0; i < 3; ++i) {
                            n.play(world, x, y, z);
                        }
                        music.addNote(data[1], n);
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 1) {
                        music.save();
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 2) {
                        music.read();
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 3) {
                        music.loadDemo();
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 4) {
                        n = new TileEntityMusicBox.Note(TileEntityMusicBox.NoteLength.values()[data[1]], 0, TileEntityMusicBox.Instrument.GUITAR);
                        music.addRest(data[0], n);
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 5) {
                        music.backspace(data[0]);
                    }
                    if (control == PacketRegistry.MUSIC.getMinValue() + 6) {
                        music.clearChannel(data[0]);
                    }
                    if (control != PacketRegistry.MUSIC.getMinValue() + 7) break;
                    music.clearMusic();
                    break;
                }
                case VACUUM: {
                    ((TileEntityVacuum)te).spawnXP();
                    break;
                }
                case WINDER: {
                    TileEntityWinder winder = (TileEntityWinder)te;
                    winder.winding = !winder.winding;
                    winder.iotick = 512;
                    break;
                }
                case PROJECTOR: {
                    ((TileEntityProjector)te).cycleInv();
                    break;
                }
                case CONTAINMENT: {
                    ((TileEntityContainment)te).setRange = data[0];
                    break;
                }
                case ITEMCANNON: {
                    TileEntityItemCannon icannon = (TileEntityItemCannon)te;
                    if (control != PacketRegistry.ITEMCANNON.getMinValue()) break;
                    icannon.selectNewTarget(data[0], data[1], data[2], data[3]);
                    break;
                }
                case MIRROR: {
                    ((TileEntityMirror)te).breakMirror(world, x, y, z);
                    break;
                }
                case SAFEPLAYER: {
                    ((TileEntityAimedCannon)te).removePlayerFromWhiteList(stringdata);
                    break;
                }
                case ENGINEBACKFIRE: {
                    ((TileEntityJetEngine)te).backFire(world, x, y, z);
                    break;
                }
                case MUSICPARTICLE: {
                    world.func_72869_a("note", (double)x + 0.2 + rand.nextDouble() * 0.6, (double)y + 1.2, (double)z + 0.2 + rand.nextDouble() * 0.6, rand.nextDouble(), 0.0, 0.0);
                    break;
                }
                case REDGEAR: {
                    ((TileEntityMultiClutch)te).setSideOfState(data[0], data[1]);
                    break;
                }
                case TERRAFORMER: {
                    ((TileEntityTerraformer)te).setTarget(BiomeGenBase.field_76773_a[data[0]]);
                    break;
                }
                case PNEUMATIC: {
                    EnergyToPowerBase eng = (EnergyToPowerBase)te;
                    if (control == PacketRegistry.PNEUMATIC.getMinValue()) {
                        eng.decrementOmega();
                    }
                    if (control == PacketRegistry.PNEUMATIC.getMinValue() + 1) {
                        eng.incrementOmega();
                    }
                    if (control != PacketRegistry.PNEUMATIC.getMinValue() + 2) break;
                    eng.incrementRedstoneState();
                    break;
                }
                case JETPACK: {
                    break;
                }
                case FERTILIZER: {
                    if (!world.field_72995_K) break;
                    ReikaParticleHelper.BONEMEAL.spawnAroundBlock(world, x, y, z, 4);
                    break;
                }
                case GRAVELGUN: {
                    ReikaParticleHelper.EXPLODE.spawnAroundBlock(world, x, y, z, 1);
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 1.0f, 1.0f);
                    break;
                }
                case SLIDE: {
                    ItemStack is = ep.func_71045_bC();
                    is.field_77990_d = new NBTTagCompound();
                    is.field_77990_d.func_74778_a("file", stringdata);
                    break;
                }
                case POWERBUS: {
                    TileEntityPowerBus bus = (TileEntityPowerBus)te;
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[data[0] + 2];
                    bus.setMode(dir, !bus.isSideSpeedMode(dir));
                    break;
                }
                case PARTICLES: {
                    ((TileEntityParticleEmitter)te).particleType = ReikaParticleHelper.particleList[data[0]];
                    break;
                }
                case BLOWER: {
                    TileEntityBlower blower = (TileEntityBlower)te;
                    if (control == PacketRegistry.BLOWER.getMinValue()) {
                        boolean bl = blower.isWhitelist = !blower.isWhitelist;
                    }
                    if (control == PacketRegistry.BLOWER.getMinValue() + 1) {
                        boolean bl = blower.checkMeta = !blower.checkMeta;
                    }
                    if (control == PacketRegistry.BLOWER.getMinValue() + 2) {
                        boolean bl = blower.checkNBT = !blower.checkNBT;
                    }
                    if (control != PacketRegistry.BLOWER.getMinValue() + 3) break;
                    blower.useOreDict = !blower.useOreDict;
                    break;
                }
                case DEFOLIATOR: {
                    ((TileEntityDefoliator)te).onBlockBreak(world, data[0], data[1], data[2]);
                    break;
                }
                case GPR: {
                    TileEntityGPR gpr = (TileEntityGPR)te;
                    int direction = data[0];
                    gpr.shift(gpr.getGuiDirection(), direction);
                    break;
                }
                case CRAFTER: {
                    if (control == PacketRegistry.CRAFTER.getMinValue()) {
                        ((TileEntityAutoCrafter)te).triggerCraftingCycle(data[0]);
                        break;
                    }
                    if (control == PacketRegistry.CRAFTER.getMinValue() + 1) {
                        ((TileEntityAutoCrafter)te).setThreshold(data[0], data[1]);
                        break;
                    }
                    if (control != PacketRegistry.CRAFTER.getMinValue() + 2) break;
                    ((TileEntityAutoCrafter)te).incrementMode();
                    break;
                }
                case POWERSYNC: {
                    long pwr;
                    TileEntityIOMachine io = (TileEntityIOMachine)te;
                    io.torque = data[0];
                    io.omega = data[1];
                    io.power = pwr = (long)data[3] << 32 | (long)data[2] & 0xFFFFFFFFL;
                    break;
                }
                case AFTERBURN: {
                    ((TileEntityJetEngine)te).setBurnerActive(data[0] > 0);
                    break;
                }
                case CRAFTPATTERNMODE: {
                    if (control == PacketRegistry.CRAFTPATTERNMODE.getMinValue()) {
                        ItemCraftPattern.setMode(ep.func_71045_bC(), ItemCraftPattern.RecipeMode.list[data[0]]);
                        break;
                    }
                    if (control != PacketRegistry.CRAFTPATTERNMODE.getMinValue() + 1) break;
                    ItemCraftPattern.changeStackLimit(ep.func_71045_bC(), data[0]);
                    break;
                }
                case FILTERSETTING: {
                    x = NBT.func_74762_e("posX");
                    y = NBT.func_74762_e("posY");
                    z = NBT.func_74762_e("posZ");
                    te = world.func_147438_o(x, y, z);
                    TileEntityItemFilter.MatchData dat = TileEntityItemFilter.MatchData.createFromNBT(NBT);
                    ((TileEntityItemFilter)te).setData(dat);
                }
            }
        }
        catch (NullPointerException e) {
            RotaryCraft.logger.logError((Object)("Machine/item was deleted before its packet " + (Object)((Object)this.pack) + " could be received!"));
            if (DragonOptions.CHATERRORS.getState()) {
                ReikaChatHelper.writeString((String)("Machine/item was deleted before its packet " + (Object)((Object)this.pack) + " could be received!"));
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPowerSyncPacket(TileEntityIOMachine iotile, EntityPlayerMP ep) {
        int p1 = (int)iotile.power;
        int p2 = (int)(iotile.power >> 32);
        if (ep != null) {
            ReikaPacketHelper.sendDataPacket((String)"RotaryCraftData", (int)PacketRegistry.POWERSYNC.getMinValue(), (TileEntity)iotile, (EntityPlayerMP)ep, (int[])new int[]{iotile.torque, iotile.omega, p1, p2});
        } else {
            ReikaPacketHelper.sendDataPacket((String)"RotaryCraftData", (int)PacketRegistry.POWERSYNC.getMinValue(), (TileEntity)iotile, (int)iotile.torque, (int)iotile.omega, (int)p1, (int)p2);
        }
    }
}

