/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Minetweaker;

import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesGrinder;
import Reika.RotaryCraft.ModInterface.Minetweaker.MinetweakerHelper;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityGrinder;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rotarycraft.Grinder")
public class GrinderTweaker {
    private static final RecipesGrinder grinder = RecipesGrinder.getRecipes();

    @ZenMethod
    public static void addRecipe(IIngredient input, IIngredient output) {
        ItemStack out = MinetweakerHelper.getStack(output);
        if (!GrinderTweaker.isValid(out)) {
            throw new IllegalArgumentException("You cannot add alternate recipes for native RotaryCraft items!");
        }
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(input, output));
    }

    @ZenMethod
    public static void addSeed(IIngredient input, double factor) {
        MineTweakerAPI.apply((IUndoableAction)new AddSeed(input, (float)factor));
    }

    private static boolean isValid(ItemStack out) {
        return !out.func_77973_b().getClass().getName().startsWith("Reika.RotaryCraft.Items");
    }

    private static class AddSeed
    implements IUndoableAction {
        private ArrayList<ItemStack> seeds = new ArrayList();
        private float factor;

        public AddSeed(IIngredient input, float factor) {
            List<ItemStack> toAddSeed = MinetweakerHelper.getStacks(input);
            for (ItemStack in : toAddSeed) {
                if (TileEntityGrinder.isGrindableSeed(in)) continue;
                this.seeds.add(in);
            }
        }

        public void apply() {
            for (ItemStack in : this.seeds) {
                TileEntityGrinder.addGrindableSeed(in, this.factor);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack in : this.seeds) {
                TileEntityGrinder.removeGrindableSeed(in);
            }
        }

        public String describe() {
            return "Adding " + this.seeds.size() + " seed" + (this.seeds.size() > 1 ? "s" : "") + " to Grinder";
        }

        public String describeUndo() {
            return "Removing " + this.seeds.size() + " seed" + (this.seeds.size() > 1 ? "s" : "") + " to Grinder";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipe
    implements IUndoableAction {
        private ArrayList<ItemStack> inputs = new ArrayList();
        private ItemStack output;

        public AddRecipe(IIngredient input, IIngredient output) {
            List<ItemStack> toAddRecipe = MinetweakerHelper.getStacks(input);
            for (ItemStack in : toAddRecipe) {
                if (grinder.isGrindable(in)) continue;
                this.inputs.add(in);
            }
        }

        public void apply() {
            for (ItemStack in : this.inputs) {
                grinder.addCustomRecipe(in, this.output);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack in : this.inputs) {
                grinder.removeRecipe(in + ">" + this.output);
            }
        }

        public String describe() {
            return "Adding " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Grinder for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Grinder for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

