/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items;

import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.TileEntities.TileEntityDecoTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class ItemBlockDecoTank
extends ItemBlock
implements Fillable {
    public static final int FILL = 25;

    public ItemBlockDecoTank(Block b) {
        super(b);
    }

    public int func_77647_b(int meta) {
        return 0;
    }

    @Override
    public int getCapacity(ItemStack is) {
        return 25;
    }

    @Override
    public int getCurrentFillLevel(ItemStack is) {
        return is.field_77990_d != null && is.field_77990_d.func_74764_b("level") ? is.field_77990_d.func_74762_e("level") : 0;
    }

    @Override
    public int addFluid(ItemStack is, Fluid f, int amt) {
        if (this.isValidFluid(f, is) && !this.isFull(is)) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            int currentlevel = is.field_77990_d.func_74762_e("level");
            int toadd = Math.min(amt, this.getCapacity(is) - currentlevel);
            is.field_77990_d.func_74768_a("level", currentlevel + toadd);
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
            return toadd;
        }
        return 0;
    }

    @Override
    public boolean isFull(ItemStack is) {
        return this.getCurrentFillLevel(is) >= this.getCapacity(is);
    }

    public void func_150895_a(Item id, CreativeTabs tab, List li) {
        li.add(new ItemStack(id, 1, 0));
        li.add(new ItemStack(id, 1, 1));
    }

    @Override
    public boolean isValidFluid(Fluid f, ItemStack is) {
        return is.field_77990_d != null ? f.equals(ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d)) : true;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity te;
        Block b;
        boolean flag = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (flag && (b = world.func_147439_a(x, y, z)) == BlockRegistry.DECOTANK.getBlockInstance() && (te = world.func_147438_o(x, y, z)) instanceof TileEntityDecoTank) {
            ((TileEntityDecoTank)te).setLiquid(stack);
            ((TileEntityDecoTank)te).setFlags(stack);
        }
        return flag;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (is.field_77990_d != null) {
            Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
            if (f != null && this.getCurrentFillLevel(is) >= 25) {
                li.add("Full of " + f.getLocalizedName());
            } else {
                li.add("Empty");
            }
        } else {
            li.add("Empty");
        }
        for (int i = 0; i < TileEntityDecoTank.TankFlags.list.length; ++i) {
            TileEntityDecoTank.TankFlags f = TileEntityDecoTank.TankFlags.list[i];
            li.add(f.displayName + ": " + f.apply(is));
        }
    }

    @Override
    public Fluid getCurrentFluid(ItemStack is) {
        return is.field_77990_d != null ? ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d) : null;
    }

    public String func_77653_i(ItemStack is) {
        return BlockRegistry.DECOTANK.getMultiValuedName(is.func_77960_j());
    }
}

