/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.BlockModelledMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEngine
extends BlockModelledMachine {
    public BlockEngine(Material mat) {
        super(mat);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int side, float par7, float par8, float par9) {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        ItemStack is = ep.func_71045_bC();
        if (te instanceof TileEntityEngine) {
            if (is != null && is.func_77973_b() == ItemRegistry.FUEL.getItemInstance()) {
                return false;
            }
            TileEntityEngine tile = (TileEntityEngine)te;
            if (is != null && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.turbine) && tile.getEngineType() == EngineType.JET && ((TileEntityJetEngine)tile).FOD > 0) {
                ((TileEntityJetEngine)tile).repairJet();
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
                return true;
            }
            if (is != null && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.compressor) && tile.getEngineType() == EngineType.JET && ((TileEntityJetEngine)tile).FOD > 0) {
                ((TileEntityJetEngine)tile).repairJetPartial();
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
                return true;
            }
            if (is != null && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.bedrockshaft) && tile.getEngineType() == EngineType.HYDRO && !((TileEntityHydroEngine)tile).isBedrock()) {
                ((TileEntityHydroEngine)tile).makeBedrock();
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
                return true;
            }
            if (is != null && is.field_77994_a == 1) {
                if (is.func_77973_b() == Items.field_151133_ar) {
                    if (tile.getEngineType().isEthanolFueled()) {
                        if (tile.getFuelLevel() >= 1000) {
                            ep.func_70062_b(0, ItemStacks.ethanolbucket.func_77946_l());
                            tile.subtractFuel(1000);
                        } else {
                            if (ConfigRegistry.CLEARCHAT.getState()) {
                                ReikaChatHelper.clearChat();
                            }
                            ReikaChatHelper.write((Object)"Engine does not have enough fuel to extract!");
                        }
                        return true;
                    }
                    if (tile.getEngineType().isJetFueled()) {
                        if (tile.getFuelLevel() >= 1000) {
                            ep.func_70062_b(0, ItemStacks.fuelbucket.func_77946_l());
                            tile.subtractFuel(1000);
                        } else {
                            if (ConfigRegistry.CLEARCHAT.getState()) {
                                ReikaChatHelper.clearChat();
                            }
                            ReikaChatHelper.write((Object)"Engine does not have enough fuel to extract!");
                        }
                        return true;
                    }
                    if (tile.getEngineType().requiresLubricant()) {
                        if (tile.getLube() >= 1000) {
                            ep.func_70062_b(0, ItemStacks.lubebucket.func_77946_l());
                            tile.removeLubricant(1000);
                        } else {
                            if (ConfigRegistry.CLEARCHAT.getState()) {
                                ReikaChatHelper.clearChat();
                            }
                            ReikaChatHelper.write((Object)"Engine does not have enough fuel to extract!");
                        }
                        return true;
                    }
                }
                if (tile.getEngineType().isJetFueled() && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.fuelbucket)) {
                    if (tile.getFuelLevel() <= 240000 - 1000) {
                        if (!ep.field_71075_bZ.field_75098_d) {
                            ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                        }
                        tile.addFuel(1000);
                    } else {
                        if (ConfigRegistry.CLEARCHAT.getState()) {
                            ReikaChatHelper.clearChat();
                        }
                        ReikaChatHelper.write((Object)"Engine is too full to add fuel!");
                    }
                    return true;
                }
                if (tile.getEngineType().isEthanolFueled() && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.ethanolbucket)) {
                    if (tile.getFuelLevel() <= 240000 - 1000) {
                        if (!ep.field_71075_bZ.field_75098_d) {
                            ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                        }
                        tile.addFuel(1000);
                    } else {
                        if (ConfigRegistry.CLEARCHAT.getState()) {
                            ReikaChatHelper.clearChat();
                        }
                        ReikaChatHelper.write((Object)"Engine is too full to add fuel!");
                    }
                    return true;
                }
                if (tile.getEngineType().requiresLubricant() && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.lubebucket)) {
                    if (tile.getLube() <= 24000 - 1000) {
                        if (!ep.field_71075_bZ.field_75098_d) {
                            ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                        }
                        tile.addLubricant(1000);
                    } else {
                        if (ConfigRegistry.CLEARCHAT.getState()) {
                            ReikaChatHelper.clearChat();
                        }
                        ReikaChatHelper.write((Object)"Engine is too full to add lubricant!");
                    }
                    return true;
                }
                if (tile.getEngineType().needsWater() && is != null && is.func_77973_b() == Items.field_151131_as) {
                    if (tile.getWater() <= 60000 - 1000) {
                        if (!ep.field_71075_bZ.field_75098_d) {
                            ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                        }
                        tile.addWater(1000);
                    } else {
                        if (ConfigRegistry.CLEARCHAT.getState()) {
                            ReikaChatHelper.clearChat();
                        }
                        ReikaChatHelper.write((Object)"Engine is too full to add water!");
                    }
                    return true;
                }
            }
        }
        return super.func_149727_a(world, x, y, z, ep, side, par7, par8, par9);
    }

    @Override
    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        float minx = (float)this.field_149759_B;
        float maxx = (float)this.field_149755_E;
        float miny = (float)this.field_149760_C;
        float maxy = (float)this.field_149756_F;
        float minz = (float)this.field_149754_D;
        float maxz = (float)this.field_149757_G;
        TileEntityEngine tile = (TileEntityEngine)par1IBlockAccess.func_147438_o(x, y, z);
        if (tile == null) {
            return;
        }
        switch (tile.getEngineType()) {
            case DC: {
                maxy -= 0.1875f;
                break;
            }
            case STEAM: {
                maxy -= 0.125f;
                break;
            }
            case GAS: {
                maxy -= 0.0625f;
                break;
            }
            case MICRO: {
                maxy -= 0.125f;
                break;
            }
            case JET: {
                maxy -= 0.125f;
                break;
            }
        }
        this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return RotaryAux.canHarvestSteelMachine(ep);
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityEngine eng = (TileEntityEngine)world.func_147438_o(x, y, z);
        if (eng != null) {
            if (eng.getEngineType() == EngineType.JET && ((TileEntityJetEngine)eng).FOD >= 8) {
                ItemStack todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelgear, (int)(1 + this.par5Random.nextInt(5)));
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)item);
                }
                todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(16 + this.par5Random.nextInt(17)));
                item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
            } else {
                ItemStack todrop = eng.getEngineType().getCraftedProduct();
                if (eng.getEngineType() == EngineType.JET) {
                    TileEntityJetEngine tj = (TileEntityJetEngine)eng;
                    if (tj.FOD > 0) {
                        if (todrop.field_77990_d == null) {
                            todrop.field_77990_d = new NBTTagCompound();
                        }
                        todrop.field_77990_d.func_74768_a("damage", tj.FOD);
                    }
                } else if (eng.getEngineType() == EngineType.HYDRO) {
                    if (todrop.field_77990_d == null) {
                        todrop.field_77990_d = new NBTTagCompound();
                    }
                    todrop.field_77990_d.func_74757_a("bed", ((TileEntityHydroEngine)eng).isBedrock());
                }
                if (eng.isUnHarvestable()) {
                    todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
                }
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
                for (int i = 0; i < eng.func_70302_i_(); ++i) {
                    if (eng.func_70301_a(i) == null) continue;
                    todrop = eng.func_70301_a(i);
                    item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                    item.field_145804_b = 10;
                    if (world.field_72995_K || ep.field_71075_bZ.field_75098_d) continue;
                    world.func_72838_d((Entity)item);
                }
            }
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        return EngineType.engineList[meta].newTileEntity();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityEngine te = (TileEntityEngine)world.func_147438_o(x, y, z);
        if (te != null) {
            te.temperature = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        }
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityEngine tile = (TileEntityEngine)world.func_147438_o(x, y, z);
        if (tile == null) {
            return ret;
        }
        ItemStack is = tile.getEngineType().getCraftedProduct();
        ret.add(is);
        if (tile.getEngineType() == EngineType.JET) {
            TileEntityJetEngine tj = (TileEntityJetEngine)tile;
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("damage", tj.FOD);
        }
        return ret;
    }
}

