/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Blocks.BlockBlastGlass;
import Reika.RotaryCraft.CommonProxy;
import Reika.RotaryCraft.ConnectedGlassRenderer;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.TileEntityDecoTank;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class BlockDecoTank
extends Block
implements ConnectedTextureGlass {
    private final ArrayList<Integer> allDirs = new ArrayList();
    private final IIcon[] icons = new IIcon[10];

    public BlockDecoTank() {
        super(Material.field_151592_s);
        this.func_149752_b(2.0f);
        this.func_149711_c(0.35f);
        this.func_149713_g(0);
        this.func_149647_a(RotaryCraft.instance.isLocked() ? null : RotaryCraft.tabRotary);
        for (int i = 1; i < 10; ++i) {
            this.allDirs.add(i);
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        float h = super.func_149712_f(world, x, y, z);
        return TileEntityDecoTank.TankFlags.RESISTANT.apply((IBlockAccess)world, x, y, z) ? h * 2.0f : h;
    }

    public float getExplosionResistance(Entity e, World world, int x, int y, int z, double eX, double eY, double eZ) {
        float r = super.getExplosionResistance(e, world, x, y, z, eX, eY, eZ);
        return TileEntityDecoTank.TankFlags.RESISTANT.apply((IBlockAccess)world, x, y, z) ? 600000.0f : r;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147479_m(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block id, int meta) {
        super.func_149749_a(world, x, y, z, id, meta);
        world.func_147479_m(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList li = super.getDrops(world, x, y, z, meta, fortune);
        TileEntityDecoTank te = (TileEntityDecoTank)world.func_147438_o(x, y, z);
        if (te != null) {
            Fluid f = te.getFluid();
            ItemStack is = (ItemStack)li.get(0);
            if (f != null) {
                is.field_77990_d = new NBTTagCompound();
                ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
                is.field_77990_d.func_74768_a("level", 25);
            }
            int dropmeta = 0;
            for (int k = 0; k < TileEntityDecoTank.TankFlags.list.length; ++k) {
                TileEntityDecoTank.TankFlags fg = TileEntityDecoTank.TankFlags.list[k];
                if (!te.getFlag(fg)) continue;
                dropmeta |= fg.getItemMetadataBit();
            }
            is.func_77964_b(dropmeta);
        } else {
            li.clear();
        }
        return li;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.connectedRender;
    }

    public boolean canRenderInPass(int pass) {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        ConnectedGlassRenderer.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean renderCentralTextureForItem(int meta) {
        return !TileEntityDecoTank.TankFlags.CLEAR.applyItem(meta);
    }

    public ArrayList<Integer> getEdgesForFace(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.addAll(this.allDirs);
        if (TileEntityDecoTank.TankFlags.CLEAR.apply(world, x, y, z)) {
            li.remove(new Integer(5));
        }
        if (face.offsetX != 0) {
            if (world.func_147439_a(x, y, z + 1) == this) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x, y, z - 1) == this) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x, y + 1, z) == this) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x, y - 1, z) == this) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x, y + 1, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x, y - 1, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x, y + 1, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
            if (world.func_147439_a(x, y - 1, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
        }
        if (face.offsetY != 0) {
            if (world.func_147439_a(x, y, z + 1) == this) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x, y, z - 1) == this) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x + 1, y, z) == this) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x - 1, y, z) == this) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x + 1, y, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x - 1, y, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x + 1, y, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
            if (world.func_147439_a(x - 1, y, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
        }
        if (face.offsetZ != 0) {
            if (world.func_147439_a(x, y + 1, z) == this) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x, y - 1, z) == this) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x + 1, y, z) == this) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x - 1, y, z) == this) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x + 1, y + 1, z) == this && !li.contains(2) && !li.contains(4)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x - 1, y - 1, z) == this && !li.contains(8) && !li.contains(6)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x + 1, y - 1, z) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
            if (world.func_147439_a(x - 1, y + 1, z) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
        }
        return li;
    }

    public IIcon getIconForEdge(IBlockAccess world, int x, int y, int z, int edge) {
        return TileEntityDecoTank.TankFlags.RESISTANT.apply(world, x, y, z) ? ((BlockBlastGlass)BlockRegistry.BLASTGLASS.getBlockInstance()).getIconForEdge(world, x, y, z, edge) : this.icons[edge];
    }

    public IIcon getIconForEdge(int itemMeta, int edge) {
        return TileEntityDecoTank.TankFlags.RESISTANT.applyItem(itemMeta) ? ((BlockBlastGlass)BlockRegistry.BLASTGLASS.getBlockInstance()).getIconForEdge(itemMeta, edge) : this.icons[edge];
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta];
    }

    public void func_149651_a(IIconRegister ico) {
        if (RotaryCraft.instance.isLocked()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.icons[i] = ico.func_94245_a("rotarycraft:tank/tank_" + i);
        }
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        return iba.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != this;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityDecoTank();
    }

    public Fluid getFluid(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        Block id = world.func_147439_a(x, y, z);
        if (id == this && (te = world.func_147438_o(x, y, z)) instanceof TileEntityDecoTank) {
            return ((TileEntityDecoTank)te).getFluid();
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (TileEntityDecoTank.TankFlags.LIGHTED.apply(world, x, y, z)) {
            return 15;
        }
        Fluid f = this.getFluid(world, x, y, z);
        return f != null ? f.getLuminosity() : 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityDecoTank te = (TileEntityDecoTank)world.func_147438_o(x, y, z);
        ItemStack is = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0).get(0);
        return is;
    }

    public int func_149692_a(int dmg) {
        return 0;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
    }
}

