/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.Instantiable.Comparators;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityAreaFiller
extends TileEntityPowerReceiver
implements DiscreteFunction {
    private BlockArray blocks = new BlockArray();
    private Comparator<Coordinate> distanceComparator;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            return;
        }
        this.getSummativeSidedPower();
        this.legacyFunction(world, x, y, z, meta);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.distanceComparator = new Comparators.CoordinateDistanceComparator(new Coordinate((TileEntity)this));
    }

    private void legacyFunction(World world, int x, int y, int z, int meta) {
        BlockKey bk;
        ++this.tickcount;
        if (this.power >= this.MINPOWER && this.hasRemainingBlocks() && (bk = this.getNextPlacedBlock()) != null && this.power >= this.getRequiredPower()) {
            if (this.blocks.isEmpty()) {
                int r = ConfigRegistry.SPILLERRANGE.getValue();
                if (r > 0) {
                    this.blocks.recursiveAddWithBounds(world, x, y - 1, z, Blocks.field_150350_a, x - r, 0, z - r, x + r, y - 1, z + r);
                    if (ReikaBlockHelper.isLiquid((Block)bk.blockID)) {
                        this.blocks.recursiveAddWithBoundsNoFluidSource(world, x, y - 1, z, bk.blockID, x - r, 0, z - r, x + r, y - 1, z + r);
                    }
                }
                this.blocks.sort(this.distanceComparator);
                this.blocks.sortBlocksByHeight(false);
            }
            if (this.tickcount >= this.getOperationTime() && !this.blocks.isEmpty()) {
                this.tickcount = 0;
                Coordinate c = this.blocks.getNextAndMoveOn();
                c.setBlock(world, bk.blockID, bk.metadata);
                bk.blockID.func_149726_b(world, c.xCoord, c.yCoord, c.zCoord);
                world.func_147471_g(c.xCoord, c.yCoord, c.zCoord);
                String snd = bk.blockID.field_149762_H.func_150495_a();
                float f = 1.0f;
                if (ReikaBlockHelper.isLiquid((Block)bk.blockID)) {
                    f = 0.5f + rand.nextFloat();
                    snd = "game.neutral.swim";
                }
                ReikaSoundHelper.playSoundFromServerAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)snd, (float)1.0f, (float)f, (boolean)true);
                this.onBlockPlaced();
            }
        }
    }

    protected abstract long getRequiredPower();

    protected abstract void onBlockPlaced();

    protected abstract boolean hasRemainingBlocks();

    protected abstract BlockKey getNextPlacedBlock();

    @Override
    public int getOperationTime() {
        return DurationRegistry.FILLER.getOperationTime(this.omega);
    }
}

