/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Interfaces.Block.SidedTextureIndex;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartItemHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.BlockRotaryCraftMachine;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidBase;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidIO;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidProducer;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidReceiver;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.GuiRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.RotaryNames;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityPerformanceEngine;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityCaveFinder;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityFlywheel;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class BlockBasicMachine
extends BlockRotaryCraftMachine
implements SidedTextureIndex {
    protected Random par5Random = new Random();
    public IIcon[][] icons = new IIcon[16][6];

    public BlockBasicMachine(Material par3Material) {
        super(par3Material);
        this.func_149711_c(4.0f);
        this.func_149752_b(15.0f);
        this.func_149715_a(0.0f);
        if (par3Material == Material.field_151573_f) {
            this.func_149672_a(field_149777_j);
        }
    }

    public final boolean hasTileEntity(int meta) {
        return true;
    }

    public abstract IIcon func_149691_a(int var1, int var2);

    public abstract void func_149651_a(IIconRegister var1);

    public int func_149645_b() {
        return 0;
    }

    public final int func_149692_a(int par1) {
        return 0;
    }

    public final int func_149745_a(Random par1Random) {
        return 0;
    }

    public final Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        float minx = (float)this.field_149759_B;
        float maxx = (float)this.field_149755_E;
        float miny = (float)this.field_149760_C;
        float maxy = (float)this.field_149756_F;
        float minz = (float)this.field_149754_D;
        float maxz = (float)this.field_149757_G;
        this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int side, float par7, float par8, float par9) {
        TileEntityAdvancedGear tile;
        super.func_149727_a(world, x, y, z, ep, side, par7, par8, par9);
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        ItemStack is = ep.func_71045_bC();
        if (ModList.DARTCRAFT.isLoaded() && DartItemHandler.getInstance().isWrench(is)) {
            ep.func_70062_b(0, null);
            ep.func_85030_a("random.break", 1.0f, 1.0f);
            ep.func_70097_a(DamageSource.field_76368_d, 4.0f);
            ReikaChatHelper.write((Object)"Your tool has shattered into a dozen pieces.");
            return true;
        }
        if (ep.func_70093_af() && !(te instanceof TileEntityCaveFinder)) {
            return false;
        }
        ItemRegistry ir = ItemRegistry.getEntry(is);
        if (ir != null && ir.overridesRightClick(is)) {
            return false;
        }
        if (te instanceof TileEntityAdvancedGear && (tile = (TileEntityAdvancedGear)te).getGearType().isLubricated() && tile.canAcceptAnotherLubricantBucket() && is != null && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.lubebucket)) {
            tile.addLubricant(1000);
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
            }
            return true;
        }
        if (te != null && RotaryAux.hasGui(world, x, y, z, ep) && ((RotaryCraftTileEntity)te).isPlayerAccessible(ep)) {
            ep.openGui((Object)RotaryCraft.instance, GuiRegistry.MACHINE.ordinal(), world, x, y, z);
            return true;
        }
        return false;
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        MachineRegistry m = MachineRegistry.getMachineFromIDandMetadata((Block)this, meta);
        if (m == null) {
            return null;
        }
        if (m == MachineRegistry.ENGINE) {
            TileEntityEngine eng = (TileEntityEngine)world.func_147438_o(x, y, z);
            if (eng == null) {
                return null;
            }
            if (eng.getEngineType() == null) {
                return null;
            }
            return eng.getEngineType().getCraftedProduct();
        }
        if (m == MachineRegistry.GEARBOX) {
            TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
            meta = gbx.func_145832_p();
            if (gbx.getGearboxType() == null) {
                return null;
            }
            int dmg = gbx.getGearboxType().ordinal();
            switch (gbx.getRatio()) {
                case 4: {
                    dmg += 5;
                    break;
                }
                case 8: {
                    dmg += 10;
                    break;
                }
                case 16: {
                    dmg += 15;
                }
            }
            return new ItemStack(ItemRegistry.GEARBOX.getItemInstance(), 1, dmg);
        }
        if (m == MachineRegistry.SHAFT) {
            TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
            meta = sha.func_145832_p();
            if (meta >= 6) {
                return new ItemStack(ItemRegistry.SHAFT.getItemInstance(), 1, RotaryNames.getNumberShaftTypes() - 1);
            }
            if (sha.getShaftType() == null) {
                return null;
            }
            return new ItemStack(ItemRegistry.SHAFT.getItemInstance(), 1, sha.getShaftType().ordinal());
        }
        if (m == MachineRegistry.FLYWHEEL) {
            TileEntityFlywheel fly = (TileEntityFlywheel)world.func_147438_o(x, y, z);
            meta = fly.func_145832_p();
            return new ItemStack(ItemRegistry.FLYWHEEL.getItemInstance(), 1, meta / 4);
        }
        if (m == MachineRegistry.ADVANCEDGEARS) {
            TileEntityAdvancedGear adv = (TileEntityAdvancedGear)world.func_147438_o(x, y, z);
            meta = adv.func_145832_p();
            ItemStack is = new ItemStack(ItemRegistry.ADVGEAR.getItemInstance(), 1, meta / 4);
            if (adv.isBedrockCoil()) {
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("bedrock", true);
            }
            return is;
        }
        if (m != null && m.isPipe()) {
            return ((TileEntityPiping)world.func_147438_o(x, y, z)).getMachine().getCraftedProduct();
        }
        return m.getCraftedProduct();
    }

    public final boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return ForgeHooks.canHarvestBlock((Block)this, (EntityPlayer)player, (int)meta);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            ReikaItemHelper.dropInventory((World)world, (int)x, (int)y, (int)z);
        }
        if (te instanceof BreakAction) {
            ((BreakAction)te).breakBlock();
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public final String getTextureFile() {
        return "/Reika/RotaryCraft/Textures/Terrain/textures.png";
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        Fluid in;
        PoweredLiquidBase liq;
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)acc.getTileEntity();
        te.syncAllData(false);
        if (te instanceof TemperatureTE && !(te instanceof TileEntityEngine)) {
            currenttip.add(String.format("Temperature: %dC", ((TemperatureTE)((Object)te)).getTemperature()));
        }
        if (te instanceof PressureTE) {
            currenttip.add(String.format("Pressure: %dkPa", ((PressureTE)((Object)te)).getPressure()));
        }
        if (te instanceof PoweredLiquidIO) {
            liq = (PoweredLiquidIO)te;
            in = ((PoweredLiquidIO)liq).getFluidInInput();
            Fluid out = ((PoweredLiquidIO)liq).getFluidInOutput();
            int amtin = ((PoweredLiquidIO)liq).getInputLevel();
            int amtout = ((PoweredLiquidIO)liq).getOutputLevel();
            String input = in != null ? String.format("%d/%d mB of %s", amtin, liq.getCapacity(), in.getLocalizedName()) : "Empty";
            String output = in != null ? String.format("%d/%d mB of %s", amtout, liq.getCapacity(), out.getLocalizedName()) : "Empty";
            currenttip.add("Input Tank: " + input);
            currenttip.add("Output Tank: " + output);
        }
        if (te instanceof PoweredLiquidReceiver) {
            liq = (PoweredLiquidReceiver)te;
            in = ((PoweredLiquidReceiver)liq).getContainedFluid();
            int amt = ((PoweredLiquidReceiver)liq).getLevel();
            String input = in != null ? String.format("%d/%d mB of %s", amt, liq.getCapacity(), in.getLocalizedName()) : "Empty";
            currenttip.add("Tank: " + input);
        }
        if (te instanceof PoweredLiquidProducer) {
            liq = (PoweredLiquidProducer)te;
            in = ((PoweredLiquidProducer)liq).getContainedFluid();
            int amt = ((PoweredLiquidProducer)liq).getLevel();
            String input = in != null ? String.format("%d/%d mB of %s", amt, liq.getCapacity(), in.getLocalizedName()) : "Empty";
            currenttip.add("Tank: " + input);
        }
        if (te instanceof TileEntityGearbox) {
            TileEntityGearbox gbx = (TileEntityGearbox)te;
            if (gbx.getGearboxType().isDamageableGear()) {
                currenttip.add(String.format("Damage: %d%s", gbx.getDamagePercent(), "%"));
            }
            if (gbx.getGearboxType().needsLubricant()) {
                String s = gbx.isLiving() ? String.format("Mana: %d%%", gbx.getLubricant() * 100 / gbx.getMaxLubricant()) : String.format("Lubricant: %d mB", gbx.getLubricant());
                currenttip.add(s);
            }
        }
        if (te instanceof TileEntityAdvancedGear) {
            TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
            if (adv.getGearType().consumesLubricant()) {
                currenttip.add(String.format("Lubricant: %d mB", adv.getLubricant()));
            }
            if (adv.getGearType() == TileEntityAdvancedGear.GearType.HIGH) {
                currenttip.add(adv.torquemode ? "Torque Mode" : "Speed Mode");
            }
        }
        if (te instanceof TileEntityEngine) {
            TileEntityEngine eng = (TileEntityEngine)te;
            if (eng.getEngineType().requiresLubricant()) {
                currenttip.add(String.format("Lubricant: %d mB", eng.getLube()));
            }
            if (eng.getEngineType().burnsFuel()) {
                currenttip.add(String.format("Fuel: %d mB", eng.getFuelLevel()));
            }
            if (eng instanceof TileEntityPerformanceEngine) {
                currenttip.add(String.format("Additives: %d mB", ((TileEntityPerformanceEngine)eng).additives));
                currenttip.add(String.format("Water: %d mB", ((TileEntityPerformanceEngine)eng).getWater()));
            }
            if (eng.hasTemperature()) {
                currenttip.add(String.format("Temperature: %dC", eng.getTemperature()));
            }
        }
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }
}

