/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBusController;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ShaftPowerBus {
    private final TileEntityBusController hub;
    private final ArrayList<TileEntityPowerBus> blocks = new ArrayList();
    private int sides = 0;

    public ShaftPowerBus(TileEntityBusController hub) {
        this.hub = hub;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Power Bus Receiving " + this.getInputTorque() + " Nm @ " + this.getSpeed() + " rad/s\n");
        sb.append(this.getInputPower() + "W is being split to " + this.getTotalOutputSides() + " devices\n");
        sb.append("(Power per side is " + this.getInputPower() / (long)this.getTotalOutputSides() + "W)");
        return sb.toString();
    }

    public void removeBlock(TileEntityPowerBus bus) {
        this.blocks.remove(bus);
        this.rebuild();
    }

    private void rebuild() {
        BlockArray b = new BlockArray();
        int x = this.hub.field_145851_c;
        int y = this.hub.field_145848_d;
        int z = this.hub.field_145849_e;
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.hub.field_145850_b, dx, dy, dz);
            if (m != MachineRegistry.POWERBUS) continue;
            b.recursiveAddWithMetadata(this.hub.field_145850_b, dx, dy, dz, m.getBlock(), m.getBlockMetadata());
        }
        Iterator<TileEntityPowerBus> it = this.blocks.iterator();
        while (it.hasNext()) {
            TileEntityPowerBus te = it.next();
            if (b.hasBlock(te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
            te.clearBus();
            it.remove();
        }
    }

    public boolean addBlock(TileEntityPowerBus bus) {
        if (this.blocks.contains(bus)) {
            return false;
        }
        this.blocks.add(bus);
        this.update();
        return true;
    }

    public TileEntityBusController getController() {
        return this.hub;
    }

    public long getInputPower() {
        return this.hub.power;
    }

    public int getSpeed() {
        return this.hub.omega;
    }

    public int getInputTorque() {
        return this.hub.torque;
    }

    public void recalcTotalOutputSides() {
        this.sides = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            TileEntityPowerBus te = this.blocks.get(i);
            for (int k = 2; k < 6; ++k) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
                if (!te.canOutputToSide(dir)) continue;
                ++this.sides;
            }
        }
    }

    public int getTotalOutputSides() {
        return Math.max(this.sides, 1);
    }

    public void update() {
        this.recalcTotalOutputSides();
    }

    public void clear() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            TileEntityPowerBus te = this.blocks.get(i);
            te.clearBus();
        }
        this.blocks.clear();
    }

    public Collection<TileEntityPowerBus> getBlocks() {
        return Collections.unmodifiableCollection(this.blocks);
    }

    public int getSize() {
        return this.blocks.size();
    }
}

