/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ForestryRecipeHelper;
import Reika.DragonAPI.ModInteract.ReikaXPFluidHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesCentrifuge
extends RecipeHandler
implements RecipeInterface.CentrifugeManager {
    private static final RecipesCentrifuge CentrifugeBase = new RecipesCentrifuge();
    private ItemHashMap<CentrifugeRecipe> recipeList = new ItemHashMap();
    private ArrayList<ItemStack> outputs = new ArrayList();

    public static final RecipesCentrifuge getRecipes() {
        return CentrifugeBase;
    }

    private RecipesCentrifuge() {
        super(MachineRegistry.CENTRIFUGE);
        RecipeInterface.centrifuge = this;
        this.addRecipe(Items.field_151064_bs, null, RecipeHandler.RecipeLevel.PERIPHERAL, Items.field_151123_aH, 100, Items.field_151065_br, 100);
        this.addRecipe(Items.field_151127_ba, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151081_bc, 4), 100);
        this.addRecipe(Blocks.field_150423_aK, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151080_bb, 12), 100);
        this.addRecipe(Items.field_151015_O, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151014_N, 4), 100);
        this.addRecipe(Blocks.field_150351_n, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151145_ak), 50, new ItemStack((Block)Blocks.field_150354_m), 75);
        this.addRecipe(ItemStacks.netherrackdust, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151114_aO), 25, new ItemStack(Items.field_151016_H), 80, ExtractorModOres.getSmeltedIngot(ModOreList.SULFUR), 40);
        this.addRecipe(Blocks.field_150346_d, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack((Block)Blocks.field_150354_m), 80, new ItemStack(Blocks.field_150435_aG), 10, new ItemStack(Items.field_151014_N), Float.valueOf(2.0f), new ItemStack(Items.field_151080_bb), Float.valueOf(0.125f), new ItemStack(Items.field_151081_bc), Float.valueOf(0.125f), new ItemStack(Blocks.field_150345_g), Float.valueOf(0.03125f), new ItemStack((Block)Blocks.field_150329_H, 1, 1), Float.valueOf(0.0625f));
        this.addRecipe(Items.field_151065_br, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151016_H), 100, ExtractorModOres.getSmeltedIngot(ModOreList.SULFUR), 75);
        this.addRecipe(ItemStacks.slipperyComb, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), 50), 60.0f, RecipeHandler.RecipeLevel.PROTECTED, ItemStacks.slipperyPropolis, 80);
        this.addRecipe(ItemStacks.slipperyPropolis, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), 150), 100.0f, RecipeHandler.RecipeLevel.PROTECTED, new Object[0]);
        int amt = ReikaMathLibrary.roundUpToX((int)10, (int)((int)((float)DifficultyEffects.CANOLA.getAverageAmount() * 0.75f)));
        this.addRecipe(ItemStacks.canolaHusks, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), amt), 100.0f, RecipeHandler.RecipeLevel.CORE, new Object[0]);
    }

    public void addRecipe(ItemStack in, ChancedOutputList out, FluidOut fs, RecipeHandler.RecipeLevel rl) {
        out.lock();
        for (ItemStack isout : out.keySet()) {
            if (ReikaItemHelper.collectionContainsItemStack(this.outputs, (ItemStack)isout)) continue;
            this.outputs.add(isout);
        }
        CentrifugeRecipe rec = new CentrifugeRecipe(in, out, fs);
        this.recipeList.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    private void addRecipe(ItemStack in, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(in, ChancedOutputList.parseFromArray((boolean)true, (Object[])items), fs, rl);
    }

    @Override
    public void addAPIRecipe(ItemStack item, FluidStack fs, float fc, Object ... items) {
        this.addRecipe(item, fs != null ? new FluidOut(fs, fc) : null, RecipeHandler.RecipeLevel.API, items);
    }

    private void addRecipe(ItemStack item, FluidStack fs, float fc, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(item, new FluidOut(fs, fc), rl, items);
    }

    private void addRecipe(Block item, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(new ItemStack(item), fs, rl, items);
    }

    private void addRecipe(Item item, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(new ItemStack(item), fs, rl, items);
    }

    public ChancedOutputList getRecipeResult(ItemStack item) {
        CentrifugeRecipe cr = item != null ? (CentrifugeRecipe)this.recipeList.get(item) : null;
        return cr != null ? cr.out : null;
    }

    private Collection<ItemStack> getRecipeOutputs(ItemStack item) {
        CentrifugeRecipe cr = item != null ? (CentrifugeRecipe)this.recipeList.get(item) : null;
        return cr != null ? cr.out.keySet() : null;
    }

    public float getItemChance(ItemStack in, ItemStack out) {
        ChancedOutputList c = this.getRecipeResult(in);
        return c.getItemChance(out);
    }

    private FluidOut getFluidOut(ItemStack item) {
        CentrifugeRecipe cr = item != null ? (CentrifugeRecipe)this.recipeList.get(item) : null;
        return cr != null ? cr.fluid : null;
    }

    public FluidStack getFluidResult(ItemStack item) {
        FluidOut fo = this.getFluidOut(item);
        return fo != null ? fo.fluid.copy() : null;
    }

    public float getFluidChance(ItemStack item) {
        FluidOut fo = this.getFluidOut(item);
        return fo != null ? fo.chance : 0.0f;
    }

    public ArrayList<ItemStack> getSources(ItemStack result) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack in : this.recipeList.keySet()) {
            Collection<ItemStack> out = this.getRecipeOutputs(in);
            if (!ReikaItemHelper.collectionContainsItemStack(out, (ItemStack)result)) continue;
            li.add(in.func_77946_l());
        }
        return li;
    }

    public ArrayList<ItemStack> getSources(Fluid result) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack in : this.recipeList.keySet()) {
            FluidStack fs = this.getFluidResult(in);
            if (fs == null || !fs.getFluid().equals(result)) continue;
            li.add(in.func_77946_l());
        }
        return li;
    }

    public boolean isProduct(ItemStack result) {
        return ReikaItemHelper.collectionContainsItemStack(this.outputs, (ItemStack)result);
    }

    public boolean isCentrifugable(ItemStack ingredient) {
        return this.getRecipeResult(ingredient) != null;
    }

    public Collection<ItemStack> getAllCentrifugables() {
        return Collections.unmodifiableCollection(this.recipeList.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
        ItemStack drop;
        FluidStack fs;
        if (ModList.FORESTRY.isLoaded()) {
            Fluid f;
            FluidStack fs2;
            Collection centrifuge = ForestryRecipeHelper.getInstance().getCentrifugeRecipes();
            for (ItemStack in : centrifuge) {
                ChancedOutputList out = ForestryRecipeHelper.getInstance().getRecipeOutput(in);
                out.manipulateChances((ChancedOutputList.ChanceManipulator)new ChancedOutputList.ChanceExponentiator(3.0));
                out.manipulateChances((ChancedOutputList.ChanceManipulator)new ChanceRounder());
                this.addRecipe(in, out, null, RecipeHandler.RecipeLevel.MODINTERACT);
            }
            ItemStack drop2 = new ItemStack(ForestryHandler.ItemEntry.HONEY.getItem());
            ChancedOutputList out = new ChancedOutputList(true);
            out.addItem(new ItemStack(ForestryHandler.ItemEntry.PROPOLIS.getItem()), 25.0f);
            this.addRecipe(drop2, out, new FluidOut(new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 150), 100.0f), RecipeHandler.RecipeLevel.MODINTERACT);
            drop2 = new ItemStack(ForestryHandler.ItemEntry.HONEYDEW.getItem());
            this.addRecipe(drop2, new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 150), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)0);
            if (drop2 != null && ReikaXPFluidHelper.fluidsExist()) {
                fs2 = ReikaXPFluidHelper.getFluid((int)30);
                this.addRecipe(drop2, fs2, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, ItemStacks.lapisoreflakes, 2);
            }
            if ((drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)1)) != null && ReikaXPFluidHelper.fluidsExist()) {
                fs2 = ReikaXPFluidHelper.getFluid((int)15);
                this.addRecipe(drop2, fs2, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)2)) != null && (f = FluidRegistry.getFluid((String)"redstone")) != null) {
                this.addRecipe(drop2, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)3)) != null && (f = FluidRegistry.getFluid((String)"coal")) != null) {
                this.addRecipe(drop2, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)4)) != null && (f = FluidRegistry.getFluid((String)"glowstone")) != null) {
                this.addRecipe(drop2, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop2 = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)5)) != null && (f = FluidRegistry.getFluid((String)"ender")) != null) {
                this.addRecipe(drop2, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
        }
        if (ReikaItemHelper.oreItemsExist((String[])new String[]{"dustLead", "dustSilver"})) {
            ItemStack lead = (ItemStack)OreDictionary.getOres((String)"dustLead").get(0);
            ItemStack silver = (ItemStack)OreDictionary.getOres((String)"dustSilver").get(0);
            this.addRecipe(ExtractorModOres.getSmeltedIngot(ModOreList.GALENA), null, RecipeHandler.RecipeLevel.PERIPHERAL, lead, 100, silver, 100);
        }
        if (ModList.TINKERER.isLoaded()) {
            ItemStack berry = OreBerryBushHandler.BerryTypes.XP.getStack();
            if (berry != null && ReikaXPFluidHelper.fluidsExist()) {
                fs = ReikaXPFluidHelper.getFluid((int)30);
                this.addRecipe(berry, fs, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            ItemStack chaff = ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.BIOCHAFF.getItem() != null ? IC2Handler.IC2Stacks.BIOCHAFF.getItem() : ReikaItemHelper.tallgrass;
            ItemStack blueslime = ReikaItemHelper.lookupItem((String)"TConstruct:strangeFood");
            this.addRecipe(ModWoodList.SLIME.getSaplingID(), null, RecipeHandler.RecipeLevel.MODINTERACT, new ItemStack(Items.field_151123_aH), 70, blueslime, 20, chaff, 100);
        }
        if (ModList.MAGICCROPS.isLoaded() && (drop = MagicCropHandler.EssenceType.XP.getEssence()) != null && ReikaXPFluidHelper.fluidsExist()) {
            fs = ReikaXPFluidHelper.getFluid((int)5);
            this.addRecipe(drop, fs, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
        }
        ItemStack is = ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.BIOCHAFF.getItem() != null ? IC2Handler.IC2Stacks.BIOCHAFF.getItem() : ReikaItemHelper.tallgrass;
        this.addRecipe(new ItemStack(Blocks.field_150435_aG), new FluidStack(FluidRegistry.WATER, 20), 40.0f, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Blocks.field_150346_d), 100, ItemStacks.silicondust, 75, ItemStacks.ironoreflakes, Float.valueOf(0.5f), ItemStacks.goldoreflakes, Float.valueOf(0.2f), is, Float.valueOf(2.5f));
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.removeValue((Object)((CentrifugeRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = crl.parseItemString(lb.getString("input"), null, false);
        FluidOut fo = null;
        ChancedOutputList co = new ChancedOutputList(false);
        if (lb.hasChild("output_fluid")) {
            LuaBlock fluid = lb.getChild("output_fluid");
            String s = fluid.getString("type");
            Fluid f = FluidRegistry.getFluid((String)s);
            if (f == null) {
                throw new IllegalArgumentException("Fluid '" + s + "' does not exist!");
            }
            this.verifyOutputFluid(f);
            FluidStack fs = new FluidStack(f, fluid.getInt("amount"));
            fo = new FluidOut(fs, (float)fluid.getDouble("chance"));
        }
        if (lb.hasChild("output_items")) {
            LuaBlock items = lb.getChild("output_items");
            for (LuaBlock entry : items.getChildren()) {
                ItemStack is = crl.parseItemString(entry.getString("item"), entry.getChild("nbt"), true);
                this.verifyOutputItem(is);
                if (is == null) continue;
                co.addItem(is, (float)entry.getDouble("chance"));
            }
        }
        this.addRecipe(in, co, fo, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    private static class FluidOut {
        private final FluidStack fluid;
        private final float chance;

        private FluidOut(FluidStack fs, float c) {
            this.fluid = fs;
            this.chance = c;
        }

        public int getRandomAmount(Random r) {
            return (int)(r.nextFloat() * (float)this.fluid.amount);
        }

        public int getAmount() {
            return this.fluid.amount;
        }

        public final String toString() {
            return this.fluid.amount + " mB of " + this.fluid.getFluid().getName() + " (" + this.chance + "%)";
        }
    }

    private static class ChanceRounder
    implements ChancedOutputList.ChanceManipulator {
        private ChanceRounder() {
        }

        public float getChance(float original) {
            return (float)Math.round(2.0 * (double)original) / 2.0f;
        }
    }

    public static class CentrifugeRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack in;
        private final ChancedOutputList out;
        private final FluidOut fluid;

        private CentrifugeRecipe(ItemStack is, ChancedOutputList li, FluidOut fs) {
            this.in = is;
            this.out = li;
            this.fluid = fs;
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.in) + ">" + this.out.toString() + "&" + (this.fluid != null ? this.fluid.toString() : "X");
        }

        @Override
        public String getAllInfo() {
            return "Centrifuge " + RecipeHandler.fullID(this.in) + " to items[" + this.out + "] and fluid " + this.fluid;
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>(this.out.keySet());
            li.add(this.in);
            return li;
        }
    }
}

