/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.Instantiable.Alert;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandbookNotifications {
    public static final HandbookNotifications instance = new HandbookNotifications();
    private final HashMap<UUID, ArrayList<Alert>> data = new HashMap();
    private final HashMap<UUID, Boolean> alert = new HashMap();

    private HandbookNotifications() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean newAlerts() {
        UUID uid = Minecraft.func_71410_x().field_71439_g.func_110124_au();
        return this.alert.containsKey(uid);
    }

    @SideOnly(value=Side.CLIENT)
    public void clearAlert() {
        this.alert.remove(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    @SideOnly(value=Side.CLIENT)
    public List<Alert> getNewAlerts() {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ArrayList<Alert> li = this.data.get(ep.func_110124_au());
        return li != null ? Collections.unmodifiableList(li) : new ArrayList<Alert>();
    }

    private void addAlert(EntityPlayer ep, ConfigRegistry c, Level lvl, String msg) {
        Alert a = new Alert(c.name().toLowerCase(Locale.ENGLISH), (ConfigList)c, lvl, msg);
        ArrayList<Object> li = this.data.get(ep.func_110124_au());
        if (li == null) {
            li = new ArrayList();
            this.data.put(ep.func_110124_au(), li);
        }
        if (!li.contains(a)) {
            li.add(a);
        }
    }

    public static class HandbookConfigVerifier
    implements PlayerHandler.PlayerTracker {
        public static final HandbookConfigVerifier instance = new HandbookConfigVerifier();
        private static final String NBT_TAG = "rc_config_alerts";
        private HashMap<ConfigRegistry, String> data = new HashMap();
        private HashMap<ConfigRegistry, Level> levels = new HashMap();

        private HandbookConfigVerifier() {
            this.addEntry(ConfigRegistry.ALLOWTNTCANNON, Level.INFO, "The TNT Cannon has been disabled.");
            this.addEntry(ConfigRegistry.ALLOWLIGHTBRIDGE, Level.INFO, "The Light Bridge has been disabled.");
            this.addEntry(ConfigRegistry.ALLOWEMP, Level.INFO, "The EMP has been disabled.");
            this.addEntry(ConfigRegistry.ATTACKBLOCKS, Level.WARNING, "Machines like the heat ray and EMP will not break blocks.");
            this.addEntry(ConfigRegistry.RAILGUNDAMAGE, Level.WARNING, "The Railgun will not cause block damage.");
            this.addEntry(ConfigRegistry.BANRAIN, Level.WARNING, "The Silver Iodide Cannon's ability to make rain has been disabled.");
            this.addEntry(ConfigRegistry.BEDPICKSPAWNERS, Level.WARNING, "The bedrock pickaxe's ability to harvest spawners has been disabled.");
            this.addEntry(ConfigRegistry.DIFFICULTY, Level.SEVERE, "The mod difficulty has been changed from the default.");
            this.addEntry(ConfigRegistry.EXTRACTORMAINTAIN, Level.SEVERE, "The Extractor has been set to require drill maintenance.");
            this.addEntry(ConfigRegistry.GRAVELPLAYER, Level.WARNING, "Gravel Gun PvP has been disabled.");
            this.addEntry(ConfigRegistry.HARDGRAVELGUN, Level.SEVERE, "Gravel Gun damage has been reduced.");
            this.addEntry(ConfigRegistry.HSLADICT, Level.INFO, "HSLA has been made usable in other mods' recipes.");
            this.addEntry(ConfigRegistry.INSTACUT, Level.WARNING, "The Woodcutter has been changed to not cut trees as cleanly or effectively.");
            this.addEntry(ConfigRegistry.MODORES, Level.SEVERE, "Forced mod ore compatibility has been disabled.");
            this.addEntry(ConfigRegistry.SPAWNERLEAK, Level.WARNING, "Mob spawn when breaking monster spawners has been disabled.");
            this.addEntry(ConfigRegistry.TABLEMACHINES, Level.INFO, "Machines can be crafted in tables other than the Worktable.");
            this.addEntry(ConfigRegistry.TURRETPLAYERS, Level.WARNING, "Turrets' ability to target players has been disabled.");
            this.addEntry(ConfigRegistry.VOIDHOLE, Level.WARNING, "The bedrock breaker has been made able to open holes to the Void.");
            this.addEntry(ConfigRegistry.NOMINERS, Level.SEVERE, "All automining machines have been disabled.");
            this.addEntry(ConfigRegistry.BORERMAINTAIN, Level.SEVERE, "The Borer has been set to require maintenance.");
            this.addEntry(ConfigRegistry.JETFUELPACK, Level.WARNING, "The jetpack requires jet fuel to operate.");
            this.addEntry(ConfigRegistry.CONVERTERLOSS, Level.SEVERE, ConfigRegistry.enableConverters() ? "RC to Mod Power Converter Losses Added." : "RC to Mod Power Converters Disabled.");
            this.addEntry(ConfigRegistry.BEEYEAST, Level.WARNING, "Yeast is a bee product, not a Fermenter output.");
        }

        private void addEntry(ConfigRegistry cfg, Level lvl, String sg) {
            this.data.put(cfg, sg);
            this.levels.put(cfg, lvl);
            if (this.isChanged(cfg)) {
                RotaryCraft.logger.log((Object)("Config Change: \"" + cfg.getLabel() + "\" from default!"));
            }
        }

        public void onPlayerLogin(EntityPlayer ep) {
            NBTTagCompound eptag = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
            NBTTagCompound nbt = eptag.func_74764_b(NBT_TAG) ? eptag.func_74775_l(NBT_TAG) : new NBTTagCompound();
            boolean empty = true;
            for (ConfigRegistry cfg : this.data.keySet()) {
                String tag = cfg.name().toLowerCase(Locale.ENGLISH);
                boolean mark = nbt.func_74767_n(tag);
                boolean chg = this.isChanged(cfg);
                if (chg != mark) {
                    empty = false;
                }
                if (chg) {
                    instance.addAlert(ep, cfg, this.levels.get((Object)cfg), this.data.get((Object)cfg));
                }
                nbt.func_74757_a(tag, chg);
            }
            if (!empty) {
                instance.alert.put(ep.func_110124_au(), true);
            }
            eptag.func_74782_a(NBT_TAG, (NBTBase)nbt);
        }

        public boolean isChanged(ConfigRegistry option) {
            if (option.isBoolean()) {
                return option.getDefaultState() != option.getState();
            }
            if (option.isNumeric()) {
                return option.getDefaultValue() != option.getValue();
            }
            if (option.isDecimal()) {
                return option.getDefaultFloat() != option.getFloat();
            }
            return true;
        }

        public void onPlayerLogout(EntityPlayer player) {
        }

        public void onPlayerChangedDimension(EntityPlayer player, int dimFrom, int dimTo) {
        }

        public void onPlayerRespawn(EntityPlayer player) {
        }
    }
}

