/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.IWG.ColorTreeGenerator;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeShaper {
    public static final int LUMPY_CHANCE = 10;
    public static final int TALL_CHANCE = 30;
    public static final int NORMAL_CHANCE = 60;
    private static final Block leafID = ChromaBlocks.DECAY.getBlockInstance();
    private static final TreeShaper instance = new TreeShaper();
    private final Random rand = new Random();
    private final ArrayList<ItemStack> validLogs = new ArrayList();

    public boolean isLogTypeEverAllowed(ModWoodList wood) {
        return wood != ModWoodList.BAMBOO && wood != ModWoodList.LIGHTED && wood != ModWoodList.SLIME && wood != ModWoodList.TAINTED;
    }

    private TreeShaper() {
        ReikaTreeHelper tree;
        int i;
        for (i = 0; i < ReikaTreeHelper.treeList.length; ++i) {
            tree = ReikaTreeHelper.treeList[i];
            if (ChromatiCraft.config.shouldGenerateLogType(tree)) {
                this.validLogs.add(tree.getLog());
                ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getName() + " logs: Enabled"));
                continue;
            }
            ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getName() + " logs: Disabled"));
        }
        for (i = 0; i < ModWoodList.woodList.length; ++i) {
            tree = ModWoodList.woodList[i];
            if (this.isLogTypeEverAllowed((ModWoodList)tree)) {
                if (tree.exists()) {
                    if (ChromatiCraft.config.shouldGenerateLogType((ModWoodList)tree)) {
                        this.validLogs.add(tree.getItem());
                        ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Enabled"));
                        continue;
                    }
                    ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Config Option)"));
                    continue;
                }
                ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Not Loaded)"));
                continue;
            }
            ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Disallowed)"));
        }
        if (this.validLogs.isEmpty()) {
            throw new InstallationException((DragonAPIMod)ChromatiCraft.instance, "You must enable at least one log type!");
        }
    }

    public static TreeShaper getInstance() {
        return instance;
    }

    public void generateRandomWeightedTree(World world, int x, int y, int z, ReikaDyeHelper color, boolean forceGen) {
        int chance;
        int val = this.rand.nextInt(100);
        if (val < (chance = 10)) {
            this.generateLumpyTree(world, x, y, z, color, forceGen);
            return;
        }
        if (val < (chance += 30)) {
            this.generateTallTree(world, x, y, z, color, forceGen);
            return;
        }
        this.generateNormalTree(world, x, y, z, color, forceGen);
    }

    public ItemStack getLogType() {
        return this.validLogs.get(this.rand.nextInt(this.validLogs.size()));
    }

    public void generateNormalTree(World world, int x, int y, int z, ReikaDyeHelper color, boolean force) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int j;
            int i;
            int meta = color.ordinal();
            ItemStack log = this.getLogType();
            int w = 2;
            int h = 5 + this.rand.nextInt(3);
            for (i = 0; i < h; ++i) {
                ReikaWorldHelper.setBlock((World)world, (int)x, (int)(y + i), (int)z, (ItemStack)log);
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 3, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 3, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 2, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 2, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 1, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 1, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0 || !this.canGenerateLeavesAt(world, x + i, y + h, z + j)) continue;
                    world.func_147465_d(x + i, y + h, z + j, leafID, meta, 3);
                }
            }
        }
    }

    public void generateTallTree(World world, int x, int y, int z, ReikaDyeHelper color, boolean force) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int j;
            int i;
            int h = 10 + this.rand.nextInt(3);
            ItemStack log = this.getLogType();
            int meta = color.ordinal();
            int w = 2;
            for (i = 0; i < h; ++i) {
                ReikaWorldHelper.setBlock((World)world, (int)x, (int)(y + i), (int)z, (ItemStack)log);
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0 || !this.canGenerateLeavesAt(world, x + i, y + h - 8, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 8, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 7, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 7, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w || !this.canGenerateLeavesAt(world, x + i, y + h - 6, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 6, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w || !this.canGenerateLeavesAt(world, x + i, y + h - 5, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 5, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 4, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 4, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w || !this.canGenerateLeavesAt(world, x + i, y + h - 3, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 3, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w || !this.canGenerateLeavesAt(world, x + i, y + h - 2, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 2, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!this.canGenerateLeavesAt(world, x + i, y + h - 1, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 1, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0 || !this.canGenerateLeavesAt(world, x + i, y + h, z + j)) continue;
                    world.func_147465_d(x + i, y + h, z + j, leafID, meta, 3);
                }
            }
        }
    }

    public void generateLumpyTree(World world, int x, int y, int z, ReikaDyeHelper color, boolean force) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int i;
            int h = 8 + this.rand.nextInt(4);
            ItemStack log = this.getLogType();
            int meta = color.ordinal();
            for (i = 0; i < h; ++i) {
                ReikaWorldHelper.setBlock((World)world, (int)x, (int)(y + i), (int)z, (ItemStack)log);
            }
            for (i = 1; i < 2; ++i) {
                int m;
                int k;
                int j;
                int dx = x + i;
                int dy = y + h - 2;
                int dz = z;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x - i;
                dz = z;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z - i;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z + i;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x + i;
                dy = y + h - 6;
                dz = z;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x - i;
                dz = z;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z - i;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z + i;
                ReikaWorldHelper.setBlock((World)world, (int)dx, (int)dy, (int)dz, (ItemStack)log);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0 || !this.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
            }
            int dy = y + h - 4;
            for (int i2 = 1; i2 < 2; ++i2) {
                if (this.canGenerateLeavesAt(world, x + i2, dy, z)) {
                    world.func_147465_d(x + i2, dy, z, leafID, meta, 3);
                }
                if (this.canGenerateLeavesAt(world, x - i2, dy, z)) {
                    world.func_147465_d(x - i2, dy, z, leafID, meta, 3);
                }
                if (this.canGenerateLeavesAt(world, x, dy, z + i2)) {
                    world.func_147465_d(x, dy, z + i2, leafID, meta, 3);
                }
                if (!this.canGenerateLeavesAt(world, x, dy, z - i2)) continue;
                world.func_147465_d(x, dy, z - i2, leafID, meta, 3);
            }
            dy = y + h;
            for (int k = -1; k <= 1; ++k) {
                for (int m = -1; m <= 1; ++m) {
                    if (k * m != 0 || !this.canGenerateLeavesAt(world, x + k, dy, z + m)) continue;
                    world.func_147465_d(x + k, dy, z + m, leafID, meta, 3);
                }
            }
        }
    }

    private boolean canGenerateLeavesAt(World world, int x, int y, int z) {
        boolean soft = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z);
        boolean leaves = world.func_147439_a(x, y, z) == Blocks.field_150362_t || world.func_147439_a(x, y, z) == Blocks.field_150361_u;
        return soft || leaves;
    }
}

