/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.DesertStructure;
import Reika.ChromatiCraft.Auxiliary.OceanStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TileEntityCache;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;

public class DungeonGenerator
implements RetroactiveGenerator {
    public static final DungeonGenerator instance = new DungeonGenerator();
    private final ForgeDirection[] dirs = ForgeDirection.values();
    private final ArrayList<ChromaStructures.Structures> structs = new ArrayList();
    private final EnumMap<ChromaStructures.Structures, TileEntityCache<Coordinate>> generatedStructures;
    private String baseFilepath;
    private boolean needsSave;

    private DungeonGenerator() {
        this.structs.add(ChromaStructures.Structures.CAVERN);
        this.structs.add(ChromaStructures.Structures.BURROW);
        this.structs.add(ChromaStructures.Structures.OCEAN);
        this.structs.add(ChromaStructures.Structures.DESERT);
        this.generatedStructures = new EnumMap(ChromaStructures.Structures.class);
        for (ChromaStructures.Structures s : this.structs) {
            this.generatedStructures.put(s, (TileEntityCache<Coordinate>)new TileEntityCache());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Collection<ChromaStructures.Structures> getStructureTypes() {
        return Collections.unmodifiableCollection(this.structs);
    }

    public void initLevelData(MinecraftServer instance) {
        this.baseFilepath = DimensionManager.getCurrentSaveRootDirectory() + "/ChromatiCraft_Data/StructureCache/";
        this.loadData();
    }

    private final String getFilepath(ChromaStructures.Structures s) {
        return this.baseFilepath + s.name().toLowerCase() + ".dat";
    }

    private void loadData() {
        for (ChromaStructures.Structures s : this.structs) {
            this.generatedStructures.put(s, (TileEntityCache<Coordinate>)new TileEntityCache());
        }
        for (ChromaStructures.Structures s : this.structs) {
            File f = new File(this.getFilepath(s));
            StructureFile pf = new StructureFile(f);
            TileEntityCache<Coordinate> cache = this.generatedStructures.get((Object)s);
            try {
                pf.load();
                for (WorldLocation loc : pf.entries) {
                    cache.put(loc, (Object)new Coordinate(loc));
                }
            }
            catch (Throwable e) {
                ChromatiCraft.logger.logError((Object)("Could not load structure cache: " + f.getName() + "; try deleting the file '" + f.getAbsolutePath() + "'"));
                e.printStackTrace();
            }
        }
        this.needsSave = false;
    }

    private void saveData() {
        for (ChromaStructures.Structures s : this.structs) {
            File f = new File(this.getFilepath(s));
            StructureFile pf = new StructureFile(f);
            for (WorldLocation p : this.generatedStructures.get((Object)s).keySet()) {
                pf.entries.add(p);
            }
            try {
                pf.save();
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not save structure cache: " + f.getName()));
                e.printStackTrace();
            }
        }
        this.needsSave = false;
    }

    @SubscribeEvent
    public void saveData(WorldEvent.Save evt) {
        if (this.needsSave) {
            this.saveData();
        }
    }

    public void printCache(ICommandSender ics) {
        ReikaJavaLibrary.pConsole((Object)("[" + FMLCommonHandler.instance().getEffectiveSide() + "] Cache Debug: " + this.generatedStructures));
    }

    public Collection<WorldLocation> getNearbyStructures(ChromaStructures.Structures s, World world, double x, double y, double z, double r) {
        return this.generatedStructures.get((Object)s).getAllLocationsNear(new WorldLocation(world, (int)Math.round(x), (int)Math.round(y), (int)Math.round(z)), r);
    }

    public WorldLocation getNearestStructure(ChromaStructures.Structures s, World world, double x, double y, double z, double r) {
        Collection c = this.generatedStructures.get((Object)s).getAllLocationsNear(new WorldLocation(world, (int)Math.round(x), (int)Math.round(y), (int)Math.round(z)), r);
        WorldLocation closest = null;
        double d = Double.POSITIVE_INFINITY;
        for (WorldLocation loc : c) {
            double dist = loc.getDistanceTo(x, y, z);
            if (closest != null && !(dist < d) || !(dist <= r)) continue;
            d = dist;
            closest = loc;
        }
        return closest;
    }

    public boolean isStructureWithin(ChromaStructures.Structures s, World world, int x, int y, int z, double r) {
        return this.getNearestStructure(s, world, x, y, z, r) != null;
    }

    public void generateStructure(ChromaStructures.Structures s, TileEntityStructControl te) {
        WorldLocation loc = new WorldLocation((TileEntity)te);
        if (!this.generatedStructures.get((Object)s).containsKey(loc)) {
            this.generatedStructures.get((Object)s).put(loc, (Object)new Coordinate((TileEntity)te));
            this.needsSave = true;
        }
    }

    public void deleteStructure(ChromaStructures.Structures s, TileEntityStructControl te) {
        WorldLocation loc = new WorldLocation((TileEntity)te);
        if (this.generatedStructures.get((Object)s).containsKey(loc)) {
            this.generatedStructures.get((Object)s).remove(loc);
            this.needsSave = true;
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.canGenerateIn(world)) {
            for (ChromaStructures.Structures s : this.structs) {
                if (this.isGennableChunk(world, chunkX * 16, chunkZ * 16, random, s) && !this.tryGenerate(world, chunkX * 16, chunkZ * 16, random, s)) continue;
            }
        }
    }

    private boolean tryGenerate(World world, int cx, int cz, Random r, ChromaStructures.Structures s) {
        int x = cx + r.nextInt(16);
        int z = cz + r.nextInt(16);
        switch (s) {
            case CAVERN: {
                int y = 10 + r.nextInt(40);
                for (int tries = 0; tries < 10 && !this.isValidCavernLocation(world, x, y, z, ChromaStructures.getCavernStructure(world, x, y, z)); ++tries) {
                    y = 10 + r.nextInt(40);
                    x = cx + r.nextInt(16);
                    z = cz + r.nextInt(16);
                }
                FilledBlockArray struct = ChromaStructures.getCavernStructure(world, x, y, z);
                if (this.isValidCavernLocation(world, x, y, z, struct)) {
                    struct.place(2);
                    for (int i = 7; i < 18; ++i) {
                        int dx = x + i;
                        Block b = world.func_147439_a(dx, y, z);
                        Block b2 = world.func_147439_a(dx, y - 1, z);
                        if (b.isAir((IBlockAccess)world, dx, y, z) && b2.isAir((IBlockAccess)world, dx, y - 1, z)) break;
                        world.func_147449_b(dx, y, z, Blocks.field_150350_a);
                        world.func_147449_b(dx, y - 1, z, Blocks.field_150350_a);
                    }
                    world.func_147465_d(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                    TileEntityStructControl te = (TileEntityStructControl)world.func_147438_o(x, y, z);
                    te.generate(s, CrystalElement.WHITE);
                    this.generateStructure(s, te);
                    DungeonGenerator.populateChests(s, struct, r);
                    return true;
                }
                return false;
            }
            case BURROW: {
                int y = world.func_72825_h(x, z) - 1;
                CrystalElement e = CrystalElement.randomElement();
                FilledBlockArray arr = ChromaStructures.getBurrowStructure(world, x, y, z, e);
                if (this.isValidBurrowLocation(world, x, y, z, arr)) {
                    arr.place(2);
                    this.convertDirtToGrass(arr);
                    world.func_147465_d(x - 5, y - 8, z - 2, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                    TileEntityStructControl te = (TileEntityStructControl)world.func_147438_o(x - 5, y - 8, z - 2);
                    te.generate(s, e);
                    this.generateStructure(s, te);
                    DungeonGenerator.populateChests(s, arr, r);
                    return true;
                }
                return false;
            }
            case OCEAN: {
                int d = 3;
                int y = world.func_72825_h(x, z) - d;
                Block b = world.func_147439_a(x, y + d, z);
                for (int tries = 0; b != Blocks.field_150355_j && b != Blocks.field_150358_i && tries < 10; ++tries) {
                    x = cx + r.nextInt(16);
                    z = cz + r.nextInt(16);
                    b = world.func_147439_a(x, y + d, z);
                }
                if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
                    FilledBlockArray struct = ChromaStructures.getOceanStructure(world, x, y, z);
                    if (y > 0 && this.isValidOceanLocation(world, x, y, z, struct)) {
                        struct.place(2);
                        world.func_147465_d(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        TileEntityStructControl te = (TileEntityStructControl)world.func_147438_o(x, y, z);
                        te.generate(s, CrystalElement.WHITE);
                        this.generateStructure(s, te);
                        DungeonGenerator.populateChests(s, struct, r);
                        this.programSpawners(s, struct);
                        this.mossify(s, struct, r);
                        this.generatePit(world, x, y, z);
                        return true;
                    }
                }
                return false;
            }
            case DESERT: {
                int y = world.func_72825_h(x, z);
                if (world.func_147439_a(x, y - 1, z) != Blocks.field_150354_m) {
                    return false;
                }
                Block b = world.func_147439_a(x, y -= 8, z);
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (this.isValidBiomeForDesertStruct(biome)) {
                    FilledBlockArray struct = ChromaStructures.getDesertStructure(world, x -= 7, y -= 3, z -= 7);
                    DesertStructure.getTerrain(struct, x, y, z);
                    if (this.isValidDesertLocation(world, x, y, z, struct)) {
                        struct.place(2);
                        world.func_147465_d(x + 7, y + 3, z + 7, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        TileEntityStructControl te = (TileEntityStructControl)world.func_147438_o(x + 7, y + 3, z + 7);
                        te.generate(s, CrystalElement.WHITE);
                        this.generateStructure(s, te);
                        DungeonGenerator.populateChests(s, struct, r);
                        this.programSpawners(s, struct);
                        for (int k = 0; k < struct.getSize(); ++k) {
                            Coordinate c = struct.getNthBlock(k);
                            if (c.yCoord <= struct.getMaxY() - 2) continue;
                            Block b1 = c.offset(0, 1, 0).getBlock(world);
                            Block b2 = c.offset(0, -1, 0).getBlock(world);
                            if (b1 != Blocks.field_150350_a || b2 != Blocks.field_150354_m || !ReikaRandomHelper.doWithChance((double)(20.0 + 30.0 * (double)Math.abs(Math.abs(c.xCoord - struct.getMidX()) + Math.abs(c.zCoord - struct.getMidZ())) / 7.0))) continue;
                            c.setBlock(world, Blocks.field_150350_a);
                        }
                        for (int k1 = struct.getMinX(); k1 <= struct.getMaxX(); ++k1) {
                            for (int k2 = struct.getMinZ(); k2 <= struct.getMaxZ(); ++k2) {
                                Coordinate c = new Coordinate(k1, world.func_72825_h(k1, k2), k2);
                                if (c.getBlock(world) != Blocks.field_150350_a || c.offset(0, -1, 0).getBlock(world) != Blocks.field_150354_m || !ReikaRandomHelper.doWithChance((double)2.0) || c.offset(1, 0, 0).getBlock(world) != Blocks.field_150350_a || c.offset(-1, 0, 0).getBlock(world) != Blocks.field_150350_a || c.offset(0, 0, 1).getBlock(world) != Blocks.field_150350_a || c.offset(0, 0, -1).getBlock(world) != Blocks.field_150350_a) continue;
                                c.setBlock(world, Blocks.field_150434_aF);
                                if (!ReikaRandomHelper.doWithChance((double)40.0)) continue;
                                c.offset(0, 1, 0).setBlock(world, Blocks.field_150434_aF);
                                if (!ReikaRandomHelper.doWithChance((double)40.0)) continue;
                                c.offset(0, 2, 0).setBlock(world, Blocks.field_150434_aF);
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean isValidBiomeForDesertStruct(BiomeGenBase biome) {
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA);
    }

    private boolean isValidDesertLocation(World world, int x, int y, int z, FilledBlockArray struct) {
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMinX(), struct.getMinZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMaxX(), struct.getMinZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMinX(), struct.getMaxZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMaxX(), struct.getMaxZ()))) {
            return false;
        }
        if (world.func_147439_a(struct.getMinX(), struct.getMinY() + 3, struct.getMinZ()) == Blocks.field_150350_a) {
            return false;
        }
        if (world.func_147439_a(struct.getMaxX(), struct.getMinY() + 3, struct.getMinZ()) == Blocks.field_150350_a) {
            return false;
        }
        if (world.func_147439_a(struct.getMinX(), struct.getMinY() + 3, struct.getMaxZ()) == Blocks.field_150350_a) {
            return false;
        }
        return world.func_147439_a(struct.getMaxX(), struct.getMinY() + 3, struct.getMaxZ()) != Blocks.field_150350_a;
    }

    private static FilledBlockArray getPitSlice(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 1, y + 0, (z -= 3) + 1, b, 8);
        array.setBlock(x + 1, y + 0, z + 2, b, 8);
        array.setBlock(x + 1, y + 0, z + 3, b, 8);
        array.setBlock(x + 1, y + 0, z + 4, b, 8);
        array.setBlock(x + 1, y + 0, z + 5, b, 8);
        array.setBlock(x + 2, y + 0, z + 1, b, 8);
        array.setBlock(x + 2, y + 0, z + 5, b, 8);
        array.setBlock(x + 3, y + 0, z + 1, b, 8);
        array.setBlock(x + 3, y + 0, z + 5, b, 8);
        array.setBlock(x + 5, y + 0, z + 1, b, 8);
        array.setBlock(x + 5, y + 0, z + 2, b, 8);
        array.setBlock(x + 5, y + 0, z + 3, b, 8);
        array.setBlock(x + 5, y + 0, z + 4, b, 8);
        array.setBlock(x + 5, y + 0, z + 5, b, 8);
        array.setBlock(x + 4, y + 0, z + 1, b, 8);
        array.setBlock(x + 4, y + 0, z + 5, b, 8);
        array.setBlock(x + 2, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 0, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 4, Blocks.field_150350_a);
        return array;
    }

    private static FilledBlockArray getEndcap1(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 30, y + 8, (z -= 3) + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 4, Blocks.field_150350_a);
        return array;
    }

    private static FilledBlockArray getEndcap2(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 2, y + 8, (z -= 3) + 30, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 10, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 10, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 10, z + 30, Blocks.field_150350_a);
        return array;
    }

    private void generatePit(World world, int x, int y, int z) {
        for (int i = 3; i < 32; ++i) {
            FilledBlockArray arr = DungeonGenerator.getPitSlice(world, x, y - i, z);
            boolean flag = true;
            for (int k = 0; k < arr.getSize(); ++k) {
                Coordinate c = arr.getNthBlock(k);
                Block b = c.getBlock(world);
                if (b == Blocks.field_150350_a) continue;
                flag = false;
            }
            if (flag && i > 6) break;
            arr.place();
        }
        BlockArray arr = OceanStructure.getPitCover(x, y, z);
        for (int k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            Block b = c.getBlock(world);
            c.setBlock(world, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
        }
    }

    private void mossify(ChromaStructures.Structures s, FilledBlockArray arr, Random r) {
        Block b2 = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        for (int k = 0; k < arr.getSize(); ++k) {
            int dy;
            int ct;
            int meta;
            Coordinate c = arr.getNthBlock(k);
            Block b = c.getBlock(arr.world);
            if (b != b2 || (meta = c.getBlockMetadata(arr.world)) != BlockStructureShield.BlockType.STONE.metadata || r.nextInt(ct = Math.max(1, (dy = c.yCoord - arr.getMinY()) * 2 - 2)) != 0) continue;
            arr.world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, BlockStructureShield.BlockType.MOSS.metadata, 2);
        }
    }

    private void programSpawners(ChromaStructures.Structures s, FilledBlockArray arr) {
        switch (s) {
            case OCEAN: {
                for (int k = 0; k < arr.getSize(); ++k) {
                    Coordinate c = arr.getNthBlock(k);
                    Block b = c.getBlock(arr.world);
                    if (b != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner te = (TileEntityMobSpawner)arr.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    te.func_145881_a().field_98289_l = 8;
                    te.func_145881_a().field_98292_k = 16;
                    te.func_145881_a().field_98293_h = 400;
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)te, (String)((String)EntityList.field_75626_c.get(EntityCreeper.class)));
                }
                break;
            }
            case DESERT: {
                for (int k = 0; k < arr.getSize(); ++k) {
                    Coordinate c = arr.getNthBlock(k);
                    Block b = c.getBlock(arr.world);
                    if (b != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner te = (TileEntityMobSpawner)arr.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    Class mob = c.yCoord <= arr.getMinY() + 4 ? EntityBlaze.class : (Math.abs(c.xCoord - arr.getMinX()) == Math.abs(c.zCoord - arr.getMinZ()) ? EntitySpider.class : EntitySilverfish.class);
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)te, (String)((String)EntityList.field_75626_c.get(mob)));
                    te.func_145881_a().field_98289_l = 4;
                    te.func_145881_a().field_98286_b = 0;
                    if (mob != EntityBlaze.class) continue;
                    te.func_145881_a().field_98293_h = 100;
                    te.func_145881_a().field_98283_g = 40;
                }
                break;
            }
        }
    }

    public static void populateChests(ChromaStructures.Structures struct, FilledBlockArray arr, Random r) {
        for (int k = 0; k < arr.getSize(); ++k) {
            BlockLootChest.TileEntityLootChest te;
            Coordinate c = arr.getNthBlock(k);
            Block b = c.getBlock(arr.world);
            if (b != ChromaStructures.getChestGen() || !(te = (BlockLootChest.TileEntityLootChest)c.getTileEntity(arr.world)).isUntouchedWorldgen()) continue;
            int bonus = 0;
            if (struct == ChromaStructures.Structures.OCEAN && c.yCoord - arr.getMinY() == 4) {
                bonus = 4;
            }
            if (struct == ChromaStructures.Structures.DESERT && c.yCoord - arr.getMinY() < 4) {
                bonus = 2;
            }
            DungeonGenerator.populateChest(te, struct, bonus, r);
        }
    }

    public static void populateChest(BlockLootChest.TileEntityLootChest te, ChromaStructures.Structures struct, int bonus, Random r) {
        String s = null;
        switch (struct) {
            case CAVERN: {
                s = "dungeonChest";
                break;
            }
            case BURROW: {
                s = "bonusChest";
                break;
            }
            case OCEAN: {
                s = "pyramidJungleChest";
                break;
            }
            case DESERT: {
                s = "pyramidDesertyChest";
            }
        }
        if (s == null) {
            return;
        }
        te.populateChest(s, struct, bonus, r);
    }

    private void convertDirtToGrass(FilledBlockArray arr) {
        for (int k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            Block b = c.getBlock(arr.world);
            if (b != Blocks.field_150346_d || arr.world.func_72957_l(c.xCoord, c.yCoord + 1, c.zCoord) <= 8) continue;
            c.setBlock(arr.world, (Block)Blocks.field_150349_c);
        }
    }

    private boolean isValidCavernLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        boolean flag = false;
        for (int i = 6; i < 18; ++i) {
            int dx = x + i;
            Block b = world.func_147439_a(dx, y, z);
            Block b2 = world.func_147439_a(dx, y - 1, z);
            if (!b.isAir((IBlockAccess)world, dx, y, z) || !b2.isAir((IBlockAccess)world, dx, y - 1, z)) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (int k = 0; k < arr.getSize(); ++k) {
                Coordinate c = arr.getNthBlock(k);
                Coordinate c2 = c.offset(0, 1, 0);
                Block b = c.getBlock(world);
                Block b2 = c2.getBlock(world);
                if (b.isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) || ReikaBlockHelper.isLiquid((Block)b)) {
                    return false;
                }
                if (!b.isAir((IBlockAccess)world, c2.xCoord, c2.yCoord, c2.zCoord) && !ReikaBlockHelper.isLiquid((Block)b2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isValidBurrowLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        int k;
        if (world.func_147439_a(x, y, z) != Blocks.field_150349_c) {
            return false;
        }
        for (int i = 1; i <= 8; ++i) {
            for (k = -3; k <= 1; ++k) {
                Block b = world.func_147439_a(x, y + i, z + k);
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + i), (int)(z + k))) continue;
                return false;
            }
        }
        int r = 1;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k2 = -r; k2 <= r; ++k2) {
                    Block b = world.func_147439_a(x + i, y + j, z + k2);
                    if (!(b instanceof BlockLiquid) && !(b instanceof BlockFluidBase)) continue;
                    return false;
                }
            }
        }
        for (k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b == ChromaBlocks.CLIFFSTONE.getBlockInstance()) {
                return false;
            }
            if (world.func_72825_h(dx, dz) < y - 2) {
                return false;
            }
            if (!arr.hasBlockAt(dx, dy, dz, Blocks.field_150348_b) && !arr.hasBlockAt(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance()) || !b.isAir((IBlockAccess)world, dx, dy, dz) && ReikaWorldHelper.checkForAdjMaterial((World)world, (int)dx, (int)dy, (int)dz, (Material)Material.field_151579_a) == null) continue;
            return false;
        }
        return true;
    }

    private boolean isValidOceanLocation(World world, int x, int y, int z, FilledBlockArray struct) {
        Block b;
        Coordinate c;
        int k;
        if (world.func_147439_a(x, y + 8, z) != Blocks.field_150355_j && world.func_147439_a(x, y + 8, z) != Blocks.field_150358_i) {
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Not deep enough"));
            return false;
        }
        boolean flag1 = true;
        boolean flag2 = true;
        FilledBlockArray cap = (FilledBlockArray)DungeonGenerator.getEndcap1(world, x, y, z).offset(1, 0, 0);
        for (k = 0; k < cap.getSize(); ++k) {
            c = cap.getNthBlock(k);
            b = c.getBlock(world);
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) continue;
            flag1 = false;
        }
        cap = (FilledBlockArray)DungeonGenerator.getEndcap2(world, x, y, z).offset(0, 0, 1);
        for (k = 0; k < cap.getSize(); ++k) {
            c = cap.getNthBlock(k);
            b = c.getBlock(world);
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) continue;
            flag2 = false;
        }
        if (!flag1 && !flag2) {
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Blocked ends"));
            return false;
        }
        for (k = 0; k < struct.getSize(); ++k) {
            c = struct.getNthBlock(k);
            b = c.getBlock(world);
            if (b == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Intersects other structure"));
                return false;
            }
            if (world.func_72825_h(c.xCoord, c.zCoord) <= y) {
                ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Extends out of water"));
                return false;
            }
            if (ReikaBiomeHelper.isOcean((BiomeGenBase)world.func_72807_a(c.xCoord, c.zCoord))) continue;
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Bounds outside ocean"));
            return false;
        }
        int consec = 0;
        for (int i = 3; i < y; ++i) {
            FilledBlockArray slice = DungeonGenerator.getPitSlice(world, x, y - i, z);
            boolean flag = true;
            for (int k2 = 0; k2 < slice.getSize(); ++k2) {
                Coordinate c2 = slice.getNthBlock(k2);
                Block b2 = c2.getBlock(world);
                if (b2 == Blocks.field_150350_a) continue;
                flag = false;
            }
            if (flag && i > 6) {
                if (++consec < 3) continue;
                return true;
            }
            consec = 0;
        }
        ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: No cave."));
        return false;
    }

    private boolean isVoidWorld(World world, int x, int z) {
        return world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z);
    }

    private boolean isGennableChunk(World world, int x, int z, Random r, ChromaStructures.Structures s) {
        if (this.isVoidWorld(world, x, z)) {
            return false;
        }
        if (this.isStructureWithin(s, world, x, 48, z, this.getMinSeparation(s))) {
            return false;
        }
        switch (s) {
            case OCEAN: {
                return r.nextInt(6) == 0 && ReikaBiomeHelper.isOcean((BiomeGenBase)world.func_72807_a(x, z));
            }
            case CAVERN: {
                return r.nextInt(5) == 0;
            }
            case BURROW: {
                return r.nextInt(8) == 0 && world.func_72807_a((int)x, (int)z).field_76752_A == Blocks.field_150349_c;
            }
            case DESERT: {
                return r.nextInt(10) == 0 && world.func_72807_a((int)x, (int)z).field_76752_A == Blocks.field_150354_m;
            }
        }
        return false;
    }

    private double getMinSeparation(ChromaStructures.Structures s) {
        switch (s) {
            case DESERT: {
                return 512.0;
            }
            case OCEAN: {
                return 1024.0;
            }
            case CAVERN: {
                return 128.0;
            }
            case BURROW: {
                return 192.0;
            }
        }
        return 0.0;
    }

    private boolean canGenerateIn(World world) {
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && !MystPages.Pages.STRUCTURES.existsInWorld(world)) {
            return false;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return ChromaOptions.FLATGEN.getState() && ReikaWorldHelper.getSuperflatHeight((World)world) > 15;
        }
        if (world.field_73011_w.field_76574_g == 0) {
            return true;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) == 1) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == ExtraUtilsHandler.getInstance().darkID) {
            return false;
        }
        return world.field_73011_w.field_76574_g != TwilightForestHandler.getInstance().dimensionID;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Prefab Structures";
    }

    private static class StructureFile
    extends NBTFile {
        private final HashSet<WorldLocation> entries = new HashSet();

        private StructureFile(File f) {
            super(f);
            this.encryptData = true;
        }

        protected void readHeader(NBTTagCompound header) {
        }

        protected void readData(NBTTagList li) {
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                WorldLocation loc = WorldLocation.readFromNBT((NBTTagCompound)tag);
                if (loc == null) continue;
                this.entries.add(loc);
            }
        }

        protected void readExtraData(NBTTagCompound extra) {
        }

        protected void writeHeader(NBTTagCompound header) {
        }

        protected void writeData(NBTTagList li) {
            for (WorldLocation loc : this.entries) {
                NBTTagCompound tag = loc.writeToTag();
                li.func_74742_a((NBTBase)tag);
            }
        }

        protected NBTTagCompound writeExtraData() {
            return null;
        }
    }
}

