/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class DecoFlowerGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final DecoFlowerGenerator instance = new DecoFlowerGenerator();

    private DecoFlowerGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        chunkX *= 16;
        chunkZ *= 16;
        if (this.generateIn(world)) {
            for (int i = 0; i < BlockDecoFlower.Flowers.list.length; ++i) {
                BlockDecoFlower.Flowers p = BlockDecoFlower.Flowers.list[i];
                if (random.nextInt(p.getGenerationChance()) != 0) continue;
                int done = 0;
                int n = random.nextInt(5) == 0 ? 1 + random.nextInt(4) + random.nextInt(6) : 1;
                int tries = 0;
                while (done < n && tries < 40) {
                    int h;
                    int g;
                    int posY;
                    int posZ;
                    ++tries;
                    int posX = chunkX + random.nextInt(16);
                    BiomeGenBase b = world.func_72807_a(posX, posZ = chunkZ + random.nextInt(16));
                    if (!p.canGenerateIn(b)) continue;
                    if (p != BlockDecoFlower.Flowers.FLOWIVY && p != BlockDecoFlower.Flowers.GLOWROOT) {
                        for (posY = ReikaRandomHelper.getRandomPlusMinus((int)world.func_72825_h(posX, posZ), (int)25); world.func_147439_a(posX, posY - 1, posZ).isAir((IBlockAccess)world, posX, posY - 1, posZ) && posY > 0; --posY) {
                        }
                        if (posY <= 0) continue;
                    }
                    if (p == BlockDecoFlower.Flowers.GLOWROOT) {
                        posY = ReikaRandomHelper.getRandomBetween((int)4, (int)80);
                    }
                    while (!world.func_147439_a(posX, posY, posZ).isAir((IBlockAccess)world, posX, posY, posZ) && posY < 255) {
                        ++posY;
                    }
                    if (p == BlockDecoFlower.Flowers.GLOWROOT) {
                        while (posY < 255 && !BlockDecoFlower.Flowers.GLOWROOT.canPlantAt(world, posX, posY, posZ) && world.func_147439_a(posX, posY + 1, posZ).isAir((IBlockAccess)world, posX, posY + 1, posZ)) {
                            ++posY;
                        }
                    }
                    if (!world.func_147439_a(posX, posY, posZ).isAir((IBlockAccess)world, posX, posY, posZ) || !p.canPlantAt(world, posX, posY, posZ)) continue;
                    if (p == BlockDecoFlower.Flowers.FLOWIVY) {
                        while (world.func_147439_a(posX, posY + 1, posZ).isAir((IBlockAccess)world, posX, posY + 1, posZ) && p.canPlantAt(world, posX, posY + 1, posZ)) {
                            ++posY;
                        }
                    }
                    if (p == BlockDecoFlower.Flowers.FLOWIVY && !world.func_147439_a(posX, posY - 1, posZ).isAir((IBlockAccess)world, posX, posY - 1, posZ)) continue;
                    world.func_147465_d(posX, posY, posZ, ChromaBlocks.DECOFLOWER.getBlockInstance(), p.ordinal(), 2);
                    if (p == BlockDecoFlower.Flowers.FLOWIVY) {
                        g = random.nextInt(12);
                        for (h = 0; h < g; ++h) {
                            if (!world.func_147439_a(posX, posY - h, posZ).isAir((IBlockAccess)world, posX, posY - h, posZ) || !p.canPlantAt(world, posX, posY - h, posZ)) continue;
                            world.func_147465_d(posX, posY - h, posZ, ChromaBlocks.DECOFLOWER.getBlockInstance(), p.ordinal(), 2);
                        }
                    } else if (p == BlockDecoFlower.Flowers.VOIDREED) {
                        g = random.nextInt(4);
                        for (h = 0; h < g; ++h) {
                            if (!world.func_147439_a(posX, posY + h, posZ).isAir((IBlockAccess)world, posX, posY + h, posZ) || !p.canPlantAt(world, posX, posY + h, posZ)) continue;
                            world.func_147465_d(posX, posY + h, posZ, ChromaBlocks.DECOFLOWER.getBlockInstance(), p.ordinal(), 2);
                        }
                    }
                    ++done;
                }
            }
        }
    }

    private boolean generateIn(World world) {
        return (world.func_72912_H().func_76067_t() != WorldType.field_77138_c || ChromaOptions.FLATGEN.getState()) && !world.field_73011_w.field_76576_e;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Flowers";
    }

    @Override
    public String getCommandID() {
        return "flowers";
    }
}

