/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.TileEntity.TileEntityDataNode;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class DataTowerGenerator
implements RetroactiveGenerator {
    public static final DataTowerGenerator instance = new DataTowerGenerator();
    private final ArrayList<TowerLoot> loot = new ArrayList();

    private DataTowerGenerator() {
        this.loot.add(new TowerLoot(Items.field_151045_i, 2));
        this.loot.add(new TowerLoot(Items.field_151166_bC, 1));
        this.loot.add(new TowerLoot(Items.field_151043_k, 5));
        this.loot.add(new TowerLoot(Items.field_151042_j, 8));
        this.loot.add(new TowerLoot(Items.field_151137_ax, 8));
        this.loot.add(new TowerLoot(ReikaItemHelper.lapisDye, 12));
    }

    public void addLoot(ItemStack is, int max) {
        this.loot.add(new TowerLoot(is, max));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.canGenerateIn(world) || !this.isGennableChunk(world, chunkX * 16, chunkZ * 16, random) || this.generate(world, chunkX * 16, chunkZ * 16, random)) {
            // empty if block
        }
    }

    private boolean generate(World world, int cx, int cz, Random rand) {
        Towers tower = LoreManager.instance.getTower(world, cx, cz);
        if (tower == null) {
            return false;
        }
        Coordinate c = tower.getGeneratedLocation();
        int x = 0;
        int y = 0;
        int z = 0;
        if (c == null) {
            x = cx + 8;
            z = cz + 8;
            y = this.prepareForTower(world, x, z);
            int r = 1;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dz = z + k;
                    while (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)(y - 1), (int)dz) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)dx, (int)(y - 1), (int)dz) || ReikaBlockHelper.isWood((IBlockAccess)world, (int)dx, (int)(y - 1), (int)dz)) {
                        --y;
                    }
                }
            }
            tower.generatedAt(x, y, z);
        } else {
            x = c.xCoord;
            y = c.yCoord;
            z = c.zCoord;
        }
        FilledBlockArray f = ChromaStructures.getDataTowerStructure(world, x, y, z);
        f.place();
        TileEntityDataNode td = (TileEntityDataNode)world.func_147438_o(x, y + 1, z);
        td.setTower(tower);
        int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)1);
        int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)1);
        world.func_147465_d(dx, y - 1, dz, ChromaBlocks.LOOTCHEST.getBlockInstance(), rand.nextInt(4), 3);
        BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(dx, y - 1, dz);
        this.generateLoot(te, rand);
        return true;
    }

    private int prepareForTower(World world, int x, int z) {
        int y = world.func_72825_h(x, z);
        Block b = world.func_147439_a(x, y, z);
        while (b.isAir((IBlockAccess)world, x, y, z) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)x, (int)y, (int)z) || ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            b = world.func_147439_a(x, --y, z);
        }
        if (ReikaBlockHelper.isLiquid((Block)world.func_147439_a(x, y + 1, z))) {
            this.prepareIsland(world, x, y, z);
        } else if (y > 250) {
            this.prepareCrater(world, x, y, z);
        }
        return world.func_72825_h(x, z);
    }

    private void prepareIsland(World world, int x, int y, int z) {
        int r = 18;
        int r2 = 3;
        double F = (double)r2 / (double)r;
        int h = 64 - y;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                int j1;
                int dx = x + i;
                int dz = z + k;
                double dr = ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k);
                if (!(dr <= (double)r)) continue;
                double f = dr / (double)r;
                double df = f < F ? 1.0 : Math.pow(1.0 - (f - F) / (1.0 - F), 2.0);
                int dh = (int)Math.ceil((double)h * df);
                BiomeGenBase b = world.func_72807_a(dx, dz);
                if (dh == h) {
                    --dh;
                }
                for (int j = j1 = Math.min(0, world.func_72825_h(dx, dz) - y); j <= dh; ++j) {
                    int dy = y + j;
                    Block b2 = Blocks.field_150348_b;
                    if (j == dh && dy >= 62) {
                        b2 = b.field_76752_A;
                    } else if (dh - j <= 3) {
                        b2 = b.field_76753_B;
                    }
                    world.func_147449_b(dx, dy, dz, b2);
                }
            }
        }
    }

    private void prepareCrater(World world, int x, int y, int z) {
        int r = 12;
        int d = y - 250;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                int dx = x + i;
                int dz = z + k;
                double dr = ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k);
                if (!(dr <= (double)r)) continue;
                double f = Math.min(1.0, 1.0 - dr / (double)r);
                int dd = (int)Math.ceil(f * (double)d);
                for (int dy = 250 + d - dd; dy < 256; ++dy) {
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
    }

    private void generateLoot(BlockLootChest.TileEntityLootChest te, Random rand) {
        te.populateChest("strongholdLibrary", ChromaStructures.Structures.CAVERN, 2, rand);
        Collections.shuffle(this.loot);
        for (TowerLoot t : this.loot) {
            int n = rand.nextInt(1 + t.maxCount);
            for (int i = 0; i < n; ++i) {
                int slot = rand.nextInt(te.func_70302_i_());
                if (te.func_70301_a(slot) != null) continue;
                te.func_70299_a(slot, t.item.func_77946_l());
            }
        }
    }

    private boolean isVoidWorld(World world, int x, int z) {
        return world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z);
    }

    private boolean isGennableChunk(World world, int x, int z, Random r) {
        return !this.isVoidWorld(world, x, z);
    }

    private boolean canGenerateIn(World world) {
        if (world.field_73011_w.field_76574_g != 0) {
            return false;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && !ChromaOptions.FLATGEN.getState()) {
            return ReikaWorldHelper.getSuperflatHeight((World)world) > 15;
        }
        return true;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Lore Towers";
    }

    public static class TowerLoot {
        private final ItemStack item;
        private final int maxCount;

        public TowerLoot(Item i, int n) {
            this(new ItemStack(i), n);
        }

        public TowerLoot(ItemStack is, int n) {
            this.item = is.func_77946_l();
            this.item.field_77994_a = 1;
            this.maxCount = n;
        }
    }
}

