/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;

public class GlowingCliffsColumnShaper {
    private final SimplexNoiseGenerator landmassControl;
    private final SimplexNoiseGenerator upperPlateauTop;
    private final SimplexNoiseGenerator upperPlateauBottom;
    private final SimplexNoiseGenerator upperPlateauEdge;
    private final SimplexNoiseGenerator middlePlateauCaveDepth;
    private final SimplexNoiseGenerator middlePlateauTop;
    private final SimplexNoiseGenerator middlePlateauBottom;
    private final SimplexNoiseGenerator middlePlateauEdge;
    private final SimplexNoiseGenerator lowerPlateauCaveDepth;
    private final SimplexNoiseGenerator shoreHeight;
    private final SimplexNoiseGenerator dirtThickness;
    private final SimplexNoiseGenerator oceanDepth;
    private final SimplexNoiseGenerator caveCeilNoise;
    private static final double SHORELINE_THRESHOLD = 0.3;
    private static final double MIDDLE_MIN_THRESHOLD = 0.35;
    private static final double MIDDLE_MAX_THRESHOLD = 0.4;
    private static final double UPPER_MIN_THRESHOLD = 0.7;
    private static final double UPPER_MAX_THRESHOLD = 0.75;
    private static final double LOWER_CAVE_MIN_THRESHOLD = 0.4;
    private static final double LOWER_CAVE_MAX_THRESHOLD = 0.6;
    private static final double MIDDLE_CAVE_MIN_THRESHOLD = 0.8;
    private static final double MIDDLE_CAVE_MAX_THRESHOLD = 0.95;
    private static final int MIN_OCEAN_FLOOR_Y = 24;
    private static final int MAX_OCEAN_FLOOR_Y = 48;
    public static final int SEA_LEVEL = 62;
    private static final int MIN_SHORE_Y = 62;
    private static final int MAX_SHORE_Y = 72;
    private static final int MIN_MIDDLE_BOTTOM_Y = 80;
    private static final int MAX_MIDDLE_BOTTOM_Y = 96;
    private static final int MIN_MIDDLE_TOP_Y = 100;
    public static final int MAX_MIDDLE_TOP_Y = 112;
    private static final int MIN_UPPER_BOTTOM_Y = 128;
    private static final int MAX_UPPER_BOTTOM_Y = 140;
    private static final int MIN_UPPER_TOP_Y = 144;
    public static final int MAX_UPPER_TOP_Y = 160;
    private static final double HVAL_LIMIT_EDGE = 0.5;
    private static final Interpolation EDGE_BLENDING = new Interpolation(false).addPoint(0.0, 1.0).addPoint(0.05, 0.925).addPoint(0.1, 0.85).addPoint(0.3, 0.8).addPoint(0.33, 0.6).addPoint(0.55, 0.5).addPoint(0.7, 0.35).addPoint(0.75, 0.2).addPoint(0.85, 0.075).addPoint(1.0, 0.0);
    private static final double ANGLE_SEARCH_STEP = 15.0;
    private static final BlockKey STONE = new BlockKey(Blocks.field_150348_b, 0);
    private static final BlockKey DIRT = new BlockKey(Blocks.field_150346_d, 0);
    private static final BlockKey GRASS = new BlockKey((Block)Blocks.field_150349_c, 0);
    private static final BlockKey BIOME_STONE = STONE;
    private static final BlockKey BIOME_DIRT = DIRT;
    private static final BlockKey BIOME_GRASS = GRASS;
    private Block[] blockColumn;
    private byte[] metaColumn;

    public GlowingCliffsColumnShaper(long seed) {
        this.landmassControl = new SimplexNoiseGenerator(seed).setFrequency(0.006944444444444444).addOctave(2.5, 0.5).addOctave(6.0, 0.125);
        this.landmassControl.clampEdge = true;
        this.shoreHeight = new SimplexNoiseGenerator(seed ^ 0xFFFFFFFFFFFFFFFFL).setFrequency(0.03125);
        this.dirtThickness = new SimplexNoiseGenerator(-seed).setFrequency(0.125);
        this.oceanDepth = new SimplexNoiseGenerator(ReikaMathLibrary.cycleBitsRight((long)seed, (int)16)).setFrequency(0.03125);
        this.caveCeilNoise = new SimplexNoiseGenerator(ReikaMathLibrary.cycleBitsLeft((long)seed, (int)16)).setFrequency(0.0625);
        this.upperPlateauTop = new SimplexNoiseGenerator(seed * 4L + 8192L).setFrequency(0.041666666666666664);
        this.upperPlateauBottom = new SimplexNoiseGenerator(seed * 8L + 4096L).setFrequency(0.041666666666666664);
        this.upperPlateauEdge = new SimplexNoiseGenerator(seed * 2L + 65536L).setFrequency(0.041666666666666664);
        this.middlePlateauCaveDepth = new SimplexNoiseGenerator(seed * 16L + 32L).setFrequency(0.041666666666666664);
        this.middlePlateauTop = new SimplexNoiseGenerator(-seed * 4L + 4096L).setFrequency(0.03125);
        this.middlePlateauBottom = new SimplexNoiseGenerator(-seed * 8L + 65536L).setFrequency(0.03125);
        this.middlePlateauEdge = new SimplexNoiseGenerator(-seed * 2L + 16384L).setFrequency(0.03125);
        this.lowerPlateauCaveDepth = new SimplexNoiseGenerator(-seed * 16L + 32L).setFrequency(0.03125);
    }

    public void generateColumn(World world, int x, int z, Random rand, Block[] blocks, byte[] metas, BiomeGenBase biome) {
        this.blockColumn = blocks;
        this.metaColumn = metas;
        for (int i = 0; i < 256; ++i) {
            this.setBlock(x, i, z, Blocks.field_150350_a);
        }
        int dirtt = (int)ReikaMathLibrary.normalizeToBounds((double)this.dirtThickness.getValue((double)x, (double)z), (double)1.0, (double)4.0);
        double hval = this.calcHval(world, x, z, biome);
        GlowCliffRegion r = this.getRegion(world, x, z, biome);
        double middlethresh = r == GlowCliffRegion.WATER ? 0.0 : this.calcMiddleThresh(x, z);
        double topthresh = r == GlowCliffRegion.WATER ? 0.0 : this.calcTopThresh(x, z);
        switch (r) {
            case WATER: {
                this.generateWater(world, x, z, biome, rand, hval, dirtt);
                break;
            }
            case SHORES: {
                this.generateLowPlateau(world, x, z, biome, rand, middlethresh, hval, dirtt);
                break;
            }
            case PLATEAU: {
                double cave = ReikaMathLibrary.normalizeToBounds((double)this.lowerPlateauCaveDepth.getValue((double)x, (double)z), (double)0.4, (double)0.6);
                this.generateMidPlateau(world, x, z, biome, rand, hval < cave, middlethresh, cave, hval, dirtt);
                break;
            }
            case HIGH_PLATEAU: {
                double cave = ReikaMathLibrary.normalizeToBounds((double)this.middlePlateauCaveDepth.getValue((double)x, (double)z), (double)0.8, (double)0.95);
                this.generateUpperPlateau(world, x, z, biome, rand, hval < cave, topthresh, cave, hval, dirtt);
                break;
            }
        }
        this.cleanColumn(world, x, z, biome);
    }

    private void cleanColumn(World world, int x, int z, BiomeGenBase biome) {
        int pos = this.calcPosIndex(x, z);
        BlockKey stone = this.getStone(biome);
        BlockKey dirt = this.getDirt(biome);
        BlockKey grass = this.getGrass(biome);
        for (int i = 1; i < 256; ++i) {
            int idx = pos + i;
            if (this.blockColumn[idx] == dirt.blockID) {
                if (this.blockColumn[idx - 1] != Blocks.field_150350_a && this.blockColumn[idx - 1] != null && this.blockColumn[idx - 1] != ChromaBlocks.DECOFLOWER.getBlockInstance() && this.blockColumn[idx - 1] != ChromaBlocks.TIEREDPLANT.getBlockInstance()) continue;
                this.setBlock(x, i, z, stone.blockID, stone.metadata);
                continue;
            }
            if (i >= 255 || this.blockColumn[idx] != grass.blockID || this.blockColumn[idx + 1] == Blocks.field_150350_a || this.blockColumn[idx + 1] == null || this.blockColumn[idx + 1] == ChromaBlocks.DECOFLOWER.getBlockInstance() || this.blockColumn[idx + 1] == Blocks.field_150345_g) continue;
            this.setBlock(x, i, z, dirt.blockID, dirt.metadata);
        }
    }

    public void blendEdge(World world, int x, int z, Block[] blockArray, byte[] metaArray) {
        block4: {
            int posIndex;
            int top;
            int y;
            block3: {
                Object[] f = this.getInvertedDistanceFactor(world, x, z, 16);
                if (f == null) {
                    return;
                }
                y = this.calcTop(blockArray, x, z);
                top = this.getBlendedHeight(world, x, y, z, (Double)f[0], (Coordinate)f[1]);
                posIndex = this.calcPosIndex(x, z);
                if (y >= top) break block3;
                for (int i = y + 1; i <= top; ++i) {
                    int idx = posIndex + i;
                    blockArray[idx] = Blocks.field_150348_b;
                    metaArray[idx] = 0;
                }
                break block4;
            }
            if (y <= top) break block4;
            for (int i = y; i > top; --i) {
                int idx = posIndex + i;
                blockArray[idx] = i <= 62 ? Blocks.field_150355_j : Blocks.field_150350_a;
                metaArray[idx] = 0;
            }
        }
    }

    private int calcTop(Block[] blockArray, int x, int z) {
        int posIndex = this.calcPosIndex(x, z);
        for (int y = 255; y >= 0; --y) {
            int idx = posIndex + y;
            if (blockArray[idx] == null || blockArray[idx] == Blocks.field_150350_a || blockArray[idx].func_149688_o() == Material.field_151579_a || blockArray[idx] == Blocks.field_150355_j || blockArray[idx].func_149688_o() == Material.field_151586_h) continue;
            return y;
        }
        return 0;
    }

    private double calcTopThresh(int x, int z) {
        return ReikaMathLibrary.normalizeToBounds((double)this.upperPlateauEdge.getValue((double)x, (double)z), (double)0.7, (double)0.75);
    }

    private double calcMiddleThresh(int x, int z) {
        return ReikaMathLibrary.normalizeToBounds((double)this.middlePlateauEdge.getValue((double)x, (double)z), (double)0.35, (double)0.4);
    }

    private double calcHval(World world, int x, int z, BiomeGenBase b) {
        double hval = ReikaMathLibrary.normalizeToBounds((double)this.landmassControl.getValue((double)x, (double)z), (double)0.0, (double)this.getHvalLimit(world, x, z, b));
        BlendPoint f = this.getDistanceFactor(world, x, z, 24, b);
        if (f != null) {
            double dm = f.biome == ChromatiCraft.glowingcliffsEdge ? this.calcHval(world, f.xCoord, f.zCoord, f.biome) : (this.isBiomeOceanic(f.biome) ? 0.075 : 0.3);
            double dh = hval - dm;
            hval = dm + dh * f.distanceFraction;
        }
        return hval;
    }

    private double getHvalLimit(World world, int x, int z, BiomeGenBase b) {
        return 1.0;
    }

    private boolean isBiomeOceanic(BiomeGenBase b) {
        return BiomeManager.oceanBiomes.contains(b);
    }

    private int getBlendedHeight(World world, int x, int y, int z, double f, Coordinate loc) {
        double f2 = EDGE_BLENDING.getValue(f);
        return (int)(f2 * this.calcIntendedHeight(world, loc.xCoord, loc.zCoord) + (1.0 - f2) * (double)y);
    }

    private double calcIntendedHeight(World world, int x, int z) {
        double hval = this.calcHval(world, x, z, ChromatiCraft.glowingcliffsEdge);
        double middle = this.calcMiddleThresh(x, z);
        double top = this.calcTopThresh(x, z);
        if (hval < 0.3) {
            return this.getOceanFloor(x, z, hval) - 1;
        }
        if (hval == 0.3) {
            return 62.0;
        }
        if (hval < middle) {
            return this.getLowPlateauHeight(hval, middle, x, z);
        }
        if (hval < top) {
            return this.getMidPlateauHeight(x, z);
        }
        return this.getTopPlateauHeight(x, z);
    }

    private Object[] getInvertedDistanceFactor(World world, int x, int z, int search) {
        Object[] objectArray;
        int mind = Integer.MAX_VALUE;
        int look = search;
        Coordinate result = null;
        block0: for (int d = 1; d <= look; ++d) {
            for (double a = 0.0; a < 360.0; a += 15.0) {
                int dz;
                int dx = MathHelper.func_76128_c((double)((double)x + (double)d * Math.cos(Math.toRadians(a))));
                BiomeGenBase b = this.getBiome(world, dx, dz = MathHelper.func_76128_c((double)((double)z + (double)d * Math.sin(Math.toRadians(a)))));
                if (!BiomeGlowingCliffs.isGlowingCliffs(b)) continue;
                if (d >= mind) continue block0;
                mind = Math.min(mind, d);
                result = new Coordinate(dx, 0, dz);
                look = mind - 1;
                continue block0;
            }
        }
        if (mind == Integer.MAX_VALUE) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = (double)mind / (double)search;
            objectArray = objectArray2;
            objectArray2[1] = result;
        }
        return objectArray;
    }

    private BlendPoint getDistanceFactor(World world, int x, int z, int search, BiomeGenBase biome) {
        BlendPoint ret = null;
        int look = search;
        block0: for (int d = 1; d <= look; ++d) {
            for (double a = 0.0; a < 360.0; a += 15.0) {
                int dz;
                int dx = MathHelper.func_76128_c((double)((double)x + (double)d * Math.cos(Math.toRadians(a))));
                BiomeGenBase b = this.getBiome(world, dx, dz = MathHelper.func_76128_c((double)((double)z + (double)d * Math.sin(Math.toRadians(a)))));
                if (b == ChromatiCraft.glowingcliffs || b == biome) continue;
                if (ret != null && d >= ret.distance) continue block0;
                ret = new BlendPoint(d, (double)d / (double)search, dx, dz, b);
                look = d - 1;
                continue block0;
            }
        }
        return ret;
    }

    private BiomeGenBase getBiome(World world, int x, int z) {
        return world.func_72959_q().func_76935_a(x, z);
    }

    private void generateLowPlateau(World world, int x, int z, BiomeGenBase biome, Random rand, double middlethresh, double hval, int dirt) {
        double cave = ReikaMathLibrary.normalizeToBounds((double)this.lowerPlateauCaveDepth.getValue((double)x, (double)z), (double)0.4, (double)0.6);
        int top = this.getLowPlateauHeight(hval, cave, x, z);
        this.generateLandColumn(world, x, z, biome, rand, dirt, top, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    private int getLowPlateauHeight(double hval, double max, int x, int z) {
        return (int)ReikaMathLibrary.linterpolate((double)hval, (double)0.3, (double)max, (double)62.0, (double)72.0);
    }

    private void generateMidPlateau(World world, int x, int z, BiomeGenBase biome, Random rand, boolean cave, double thresh, double caveThresh, double hval, int dirt) {
        int top = this.getMidPlateauHeight(x, z);
        int caveFloor = Integer.MAX_VALUE;
        int caveCeil = Integer.MIN_VALUE;
        if (cave) {
            caveFloor = (int)ReikaMathLibrary.linterpolate((double)hval, (double)0.3, (double)caveThresh, (double)62.0, (double)72.0);
            int baseCeil = caveCeil = (int)ReikaMathLibrary.normalizeToBounds((double)this.middlePlateauBottom.getValue((double)x, (double)z), (double)80.0, (double)96.0);
            double dh = caveCeil - caveFloor;
            caveCeil = caveFloor + 4 + (int)ReikaMathLibrary.ellipticalInterpolation((double)Math.abs(hval - thresh), (double)0.0, (double)(caveThresh - thresh), (double)0.0, (double)(dh *= ReikaMathLibrary.normalizeToBounds((double)this.caveCeilNoise.getValue((double)x, (double)z), (double)0.8, (double)1.2)));
            dh = top - baseCeil;
            top = baseCeil + 2 + (int)ReikaMathLibrary.ellipticalInterpolation((double)(hval - caveThresh), (double)0.0, (double)(caveThresh - thresh), (double)0.0, (double)dh);
        }
        this.generateLandColumn(world, x, z, biome, rand, dirt, top, caveFloor, caveCeil);
    }

    private int getMidPlateauHeight(int x, int z) {
        return (int)ReikaMathLibrary.normalizeToBounds((double)this.middlePlateauTop.getValue((double)x, (double)z), (double)100.0, (double)112.0);
    }

    private void generateUpperPlateau(World world, int x, int z, BiomeGenBase biome, Random rand, boolean cave, double thresh, double caveThresh, double hval, int dirt) {
        int top = this.getTopPlateauHeight(x, z);
        int caveFloor = Integer.MAX_VALUE;
        int caveCeil = Integer.MIN_VALUE;
        if (cave) {
            caveFloor = (int)ReikaMathLibrary.normalizeToBounds((double)this.middlePlateauTop.getValue((double)x, (double)z), (double)100.0, (double)112.0);
            int baseCeil = caveCeil = (int)ReikaMathLibrary.normalizeToBounds((double)this.upperPlateauBottom.getValue((double)x, (double)z), (double)128.0, (double)140.0);
            double dh = caveCeil - caveFloor;
            caveCeil = caveFloor + 4 + (int)ReikaMathLibrary.ellipticalInterpolation((double)Math.abs(hval - thresh), (double)0.0, (double)(caveThresh - thresh), (double)0.0, (double)(dh *= ReikaMathLibrary.normalizeToBounds((double)this.caveCeilNoise.getValue((double)x, (double)z), (double)0.8, (double)1.2)));
            dh = top - baseCeil;
            top = baseCeil + 2 + (int)ReikaMathLibrary.ellipticalInterpolation((double)(hval - caveThresh), (double)0.0, (double)(caveThresh - thresh), (double)0.0, (double)dh);
        }
        this.generateLandColumn(world, x, z, biome, rand, dirt, top, caveFloor, caveCeil);
    }

    private int getTopPlateauHeight(int x, int z) {
        return (int)ReikaMathLibrary.normalizeToBounds((double)this.upperPlateauTop.getValue((double)x, (double)z), (double)144.0, (double)160.0);
    }

    private void generateWater(World world, int x, int z, BiomeGenBase biome, Random rand, double hval, int dirtt) {
        int i;
        int floor = this.getOceanFloor(x, z, hval);
        BlockKey stone = this.getStone(biome);
        BlockKey dirt = this.getDirt(biome);
        for (i = 0; i < floor; ++i) {
            this.setBlock(x, i, z, stone.blockID, stone.hasMetadata() ? stone.metadata : 0);
        }
        for (i = floor; i <= 62; ++i) {
            this.setBlock(x, i, z, Blocks.field_150355_j);
        }
        for (i = 63; i < 256; ++i) {
            this.setBlock(x, i, z, Blocks.field_150350_a);
        }
        for (int h = 1; h <= dirtt; ++h) {
            this.setBlock(x, floor - h, z, dirt.blockID, dirt.hasMetadata() ? dirt.metadata : 0);
        }
    }

    private int getOceanFloor(int x, int z, double hval) {
        int min = (int)ReikaMathLibrary.normalizeToBounds((double)this.oceanDepth.getValue((double)x, (double)z), (double)24.0, (double)48.0);
        int floor = (int)ReikaMathLibrary.linterpolate((double)hval, (double)0.0, (double)0.3, (double)min, (double)63.0);
        return floor;
    }

    private void generateLandColumn(World world, int x, int z, BiomeGenBase biome, Random rand, int dirt, int top, int caveFloor, int caveCeil) {
        for (int i = 0; i < 256; ++i) {
            BlockKey b = this.getStone(biome);
            if (i > top || i > caveFloor && i < caveCeil) {
                b = BlockKey.AIR;
            } else if (i == top || i == caveFloor && i < caveCeil) {
                b = this.getGrass(biome);
            } else if (i >= top - dirt || i >= caveFloor - dirt && i < caveCeil) {
                b = this.getDirt(biome);
            }
            this.setBlock(x, i, z, b.blockID, b.hasMetadata() ? b.metadata : 0);
        }
        if (caveFloor > 0 && caveFloor < 256) {
            if (ReikaRandomHelper.doWithChance((double)6.0)) {
                this.setBlock(x, caveFloor + 1, z, ChromaBlocks.DECOFLOWER.getBlockInstance(), BlockDecoFlower.Flowers.GLOWDAISY.ordinal());
            } else if (ReikaRandomHelper.doWithChance((double)0.008)) {
                this.setBlock(x, caveFloor + 1, z, Blocks.field_150345_g);
            }
            if (ReikaRandomHelper.doWithChance((double)0.003)) {
                this.setBlock(x, caveCeil - 1, z, ChromaBlocks.TIEREDPLANT.getBlockInstance(), BlockTieredPlant.TieredPlants.CAVE.ordinal());
            } else if (ReikaRandomHelper.doWithChance((double)0.008)) {
                int nt = Math.min(ReikaRandomHelper.getRandomBetween((int)1, (int)4), caveCeil - caveFloor - 3);
                for (int i = 1; i <= nt; ++i) {
                    this.setBlock(x, caveCeil - i, z, ChromaBlocks.DECOFLOWER.getBlockInstance(), BlockDecoFlower.Flowers.GLOWROOT.ordinal());
                }
            }
        }
    }

    private void setBlock(int x, int y, int z, Block b) {
        this.setBlock(x, y, z, b, 0);
    }

    private void setBlock(int x, int y, int z, Block b, int meta) {
        if (meta < 0) {
            throw new IllegalArgumentException("Negative metadata @ " + x + ", " + y + ", " + z + "!");
        }
        int posIndex = this.calcPosIndex(x, z);
        this.blockColumn[posIndex + y] = b;
        this.metaColumn[posIndex + y] = (byte)meta;
    }

    private int calcPosIndex(int x, int z) {
        int dx = x & 0xF;
        int dz = z & 0xF;
        int d = 256;
        return (dx * 16 + dz) * d;
    }

    private BlockKey getStone(BiomeGenBase biome) {
        return BiomeGlowingCliffs.isGlowingCliffs(biome) ? BIOME_STONE : STONE;
    }

    private BlockKey getDirt(BiomeGenBase biome) {
        return BiomeGlowingCliffs.isGlowingCliffs(biome) ? BIOME_DIRT : DIRT;
    }

    private BlockKey getGrass(BiomeGenBase biome) {
        return BiomeGlowingCliffs.isGlowingCliffs(biome) ? BIOME_GRASS : GRASS;
    }

    public GlowCliffRegion getRegion(World world, int x, int z, BiomeGenBase b) {
        double hval = this.calcHval(world, x, z, b);
        if (hval < 0.3) {
            return GlowCliffRegion.WATER;
        }
        double middlethresh = this.calcMiddleThresh(x, z);
        double topthresh = this.calcTopThresh(x, z);
        if (hval < middlethresh) {
            return GlowCliffRegion.SHORES;
        }
        if (hval < topthresh) {
            return GlowCliffRegion.PLATEAU;
        }
        return GlowCliffRegion.HIGH_PLATEAU;
    }

    public static enum GlowCliffRegion {
        WATER,
        SHORES,
        PLATEAU,
        HIGH_PLATEAU;

    }

    private static class BlendPoint {
        private final int distance;
        private final double distanceFraction;
        private final BiomeGenBase biome;
        private final int xCoord;
        private final int zCoord;

        private BlendPoint(int d, double f, int x, int z, BiomeGenBase b) {
            this.distance = d;
            this.distanceFraction = f;
            this.biome = b;
            this.xCoord = x;
            this.zCoord = z;
        }
    }
}

