/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class EnderPoolGenerator
extends WorldGenerator {
    private static final List<Block> placeables = new ArrayList<Block>();

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        for (int i = 2; i < 7; ++i) {
            if (!placeables.contains(world.func_147439_a(x, y - i, z)) || !this.generateRandomShapeAt(world, random, x, y - i, z, 6)) continue;
            return true;
        }
        return false;
    }

    private boolean generateRandomShapeAt(World world, Random r, int x, int y, int z, int max) {
        Block id = ChromatiCraft.instance.getEnderBlockToGenerate();
        BlockArray blocks = new BlockArray();
        boolean gen = false;
        gen = r.nextDouble() < 0.5 ? this.generateCircularPool(world, x, y, z, r, id, blocks) : this.generateEllipticalPool(world, x, y, z, r, id, blocks);
        if (gen) {
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                if (c.yCoord <= y) {
                    c.setBlock(world, id);
                    continue;
                }
                c.setBlock(world, Blocks.field_150350_a);
                Block bid = world.func_147439_a(c.xCoord, c.yCoord - 1, c.zCoord);
                if (bid != Blocks.field_150346_d) continue;
                world.func_147449_b(c.xCoord, c.yCoord - 1, c.zCoord, (Block)Blocks.field_150349_c);
            }
        }
        return gen;
    }

    private boolean generateCircularPool(World world, int x, int y, int z, Random rand, Block id, BlockArray blocks) {
        double dd;
        int k;
        int j;
        int i;
        int d = 2 + rand.nextInt(3);
        int[] r = new int[]{d, d - 1, d - 3};
        for (i = 0; i < 3; ++i) {
            for (j = -r[i]; j <= r[i]; ++j) {
                for (k = -r[i]; k <= r[i]; ++k) {
                    dd = ReikaMathLibrary.py3d((double)j, (double)0.0, (double)k);
                    if (!(dd <= (double)r[i] + 0.5)) continue;
                    if (this.isValidBlock(world, x + j, y - i, z + k)) {
                        blocks.addBlockCoordinate(x + j, y - i, z + k);
                        continue;
                    }
                    return false;
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = -r[i] - 1; j <= r[i] + 1; ++j) {
                for (k = -r[i] - 1; k <= r[i] + 1; ++k) {
                    dd = ReikaMathLibrary.py3d((double)j, (double)0.0, (double)k);
                    if (!(dd <= (double)r[i] + 1.5)) continue;
                    if (world.func_147439_a(x + j, y + i + 1, z + k) instanceof BlockLiquid) {
                        return false;
                    }
                    blocks.addBlockCoordinate(x + j, y + i + 1, z + k);
                }
            }
        }
        return true;
    }

    private boolean generateEllipticalPool(World world, int x, int y, int z, Random rand, Block id, BlockArray blocks) {
        double dd;
        int k;
        int j;
        int i;
        int d = 2 + rand.nextInt(3);
        int[] r = new int[]{d, d - 1, d - 3};
        double sc = 0.5 + rand.nextDouble() * 0.5;
        for (i = 0; i < 3; ++i) {
            for (j = -r[i]; j <= r[i]; ++j) {
                k = (int)Math.floor((double)(-r[i]) * sc);
                while ((double)k <= (double)r[i] * sc) {
                    dd = ReikaMathLibrary.py3d((double)j, (double)0.0, (double)k);
                    if (dd <= (double)r[i] + 0.5) {
                        if (this.isValidBlock(world, x + j, y - i, z + k)) {
                            blocks.addBlockCoordinate(x + j, y - i, z + k);
                        } else {
                            return false;
                        }
                    }
                    ++k;
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = -r[i] - 1; j <= r[i] + 1; ++j) {
                k = (int)Math.floor((double)(-r[i]) * sc - 1.0);
                while ((double)k <= (double)r[i] * sc + 1.0) {
                    dd = ReikaMathLibrary.py3d((double)j, (double)0.0, (double)k);
                    if (dd <= (double)r[i] + 1.5) {
                        if (world.func_147439_a(x + j, y + i + 1, z + k) instanceof BlockLiquid) {
                            return false;
                        }
                        blocks.addBlockCoordinate(x + j, y + i + 1, z + k);
                    }
                    ++k;
                }
            }
        }
        return true;
    }

    private boolean isValidBlock(World world, int x, int y, int z) {
        Block id = ChromatiCraft.instance.getEnderBlockToGenerate();
        Block idx = world.func_147439_a(x, y, z);
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return false;
        }
        ForgeDirection[] dirs = ForgeDirection.values();
        for (int i = 0; i < 6; ++i) {
            boolean ender;
            ForgeDirection dir = dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (dir == ForgeDirection.UP) {
                Block bid = world.func_147439_a(dx, dy, dz);
                if ((bid == Blocks.field_150350_a || !(bid instanceof BlockLiquid)) && bid != id) continue;
                return false;
            }
            boolean soft = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz);
            boolean bl = ender = world.func_147439_a(dx, dy, dz) == id;
            if (!soft) continue;
            return false;
        }
        return true;
    }

    static {
        placeables.add(Blocks.field_150346_d);
        placeables.add((Block)Blocks.field_150349_c);
        placeables.add(Blocks.field_150351_n);
        placeables.add(Blocks.field_150348_b);
        placeables.add((Block)Blocks.field_150354_m);
    }
}

