/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.RegionMapper;
import Reika.ChromatiCraft.World.Dimension.SkyRiverGenerator;
import Reika.ChromatiCraft.World.Dimension.StructureCalculator;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.reflect.Constructor;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;

public enum ThreadedGenerators {
    STRUCTURE(StructureCalculator.class),
    BIOME(BiomeDistributor.class),
    REGION(RegionMapper.class),
    SKYRIVER(SkyRiverGenerator.class);

    private final Class generator;
    private boolean isRunning;
    public static final ThreadedGenerators[] generators;
    private static final EnumMap<ThreadedGenerators, ThreadedGenerator> runMap;

    private ThreadedGenerators(Class<? extends ThreadedGenerator> c) {
        this.generator = c;
    }

    public boolean isDependentOn(ThreadedGenerators g) {
        switch (this) {
            case BIOME: {
                return g == STRUCTURE;
            }
            case REGION: {
                return g == STRUCTURE;
            }
            case STRUCTURE: {
                return false;
            }
            case SKYRIVER: {
                return false;
            }
        }
        return false;
    }

    public void run(long seed) {
        try {
            ThreadedGeneratorRunnable r = new ThreadedGeneratorRunnable(this, seed);
            Thread t = new Thread((Runnable)r, "ChromatiCraft Dimension " + this.getName());
            t.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start threaded generator " + this.getName(), e);
        }
    }

    private ThreadedGenerator getGenerator(long seed) {
        try {
            Constructor c = this.generator.getConstructor(Long.TYPE);
            ThreadedGenerator g = (ThreadedGenerator)c.newInstance(seed);
            return g;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start threaded generator " + this.getName(), e);
        }
    }

    ThreadedGenerator getCurrentlyActiveGenerator() {
        return runMap.get((Object)this);
    }

    public int getBit() {
        return 1 << this.ordinal();
    }

    private String getName() {
        return ReikaStringParser.capFirstChar((String)this.name());
    }

    public static void reset() {
        runMap.clear();
        ChromatiCraft.logger.log((Object)("All " + generators.length + " dimension generators complete."));
    }

    static {
        generators = ThreadedGenerators.values();
        runMap = new EnumMap(ThreadedGenerators.class);
    }

    private static class ThreadedGeneratorRunnable
    implements Runnable {
        private final ThreadedGenerators generator;
        private final ThreadedGenerator generatorObject;
        private final long seed;

        private ThreadedGeneratorRunnable(ThreadedGenerators g, long s) {
            this.generator = g;
            this.seed = s;
            this.generatorObject = this.generator.getGenerator(this.seed);
            runMap.put(this.generator, this.generatorObject);
        }

        @Override
        public void run() {
            if (this.generator.isRunning) {
                String msg = "You cannot run two threaded generator instances simultaneously!";
                FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException(msg), msg, true);
            }
            this.generator.isRunning = true;
            ChromatiCraft.logger.log((Object)("Initializing Dimension " + this.generator.getName() + " generation thread..."));
            try {
                long time = System.currentTimeMillis();
                this.generatorObject.run();
                double el = (double)(System.currentTimeMillis() - time) / 1000.0;
                String sg = this.generatorObject.getStateMessage();
                ChromatiCraft.logger.log((Object)String.format("Dimension " + this.generator.getName() + " generation thread complete; Elapsed time: %.3fs. %s", el, sg));
            }
            catch (Throwable e) {
                e.printStackTrace();
                String msg = "Dimension " + this.generator.getName() + " generation thread failed with " + e.getClass().getName() + ".";
                if (e instanceof ConcurrentModificationException) {
                    msg = msg + " A CME may be a transient issue. Try restarting to see if it happens consistently.";
                }
                FMLCommonHandler.instance().raiseException(e, msg, true);
                ChromatiCraft.logger.logError((Object)msg);
            }
            ChunkProviderChroma.finishGeneration(this.generator);
            this.generator.isRunning = false;
        }
    }
}

