/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Terrain;

import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.Block.Worldgen.BlockSparkle;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TerrainGenSparklingSands
extends ChromaDimensionBiomeTerrainShaper {
    private final SimplexNoiseGenerator beachTypeNoise;
    private final SimplexNoiseGenerator heightNoise;
    private final SimplexNoiseGenerator duneNoise;
    private final SimplexNoiseGenerator duneHeightNoise;
    private final SimplexNoiseGenerator beachTypeOffsetNoise;
    private final SimplexNoiseGenerator sparkleChoiceNoise;
    private static final int SHORE_Y = 103;
    private static final int LAYER_THICKNESS = 3;
    private static final ArrayList<BlockKey>[] HEIGHT_LEVELS = new ArrayList[]{ReikaJavaLibrary.makeListFrom((Object)new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), BlockSparkle.BlockTypes.CLAY.ordinal())), ReikaJavaLibrary.makeListFrom((Object[])new Object[]{new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), BlockSparkle.BlockTypes.SAND.ordinal()), new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), BlockSparkle.BlockTypes.GRAVEL.ordinal())}), ReikaJavaLibrary.makeListFrom((Object[])new Object[]{new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), BlockSparkle.BlockTypes.DIRT.ordinal()), new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), BlockSparkle.BlockTypes.STONE.ordinal())})};
    private static final int UNDERWATER_LAYERS = 1;
    private static final int MIN_Y = 98;
    private static final int MAX_Y = 98 + 3 * HEIGHT_LEVELS.length;
    private static final int MIN_DUNE_HEIGHT = 3;
    private static final int MAX_DUNE_HEIGHT = 12;

    public TerrainGenSparklingSands(long seed) {
        super(seed, ChromaDimensionManager.Biomes.SPARKLE);
        this.heightNoise = new SimplexNoiseGenerator(seed).addOctave(2.0, 0.5);
        this.beachTypeNoise = new SimplexNoiseGenerator(-seed).setFrequency(4.0);
        this.sparkleChoiceNoise = new SimplexNoiseGenerator(seed ^ 0xFFFFFFFFFFFFFFFFL).setFrequency(2.0);
        this.beachTypeOffsetNoise = new SimplexNoiseGenerator(2L * (seed ^ 0xFFFFFFFFFFFFFFFFL));
        this.duneNoise = new SimplexNoiseGenerator(-2L * seed).setFrequency(5.0);
        this.duneHeightNoise = new SimplexNoiseGenerator(2L * seed);
    }

    @Override
    public void generateColumn(World world, int chunkX, int chunkZ, int i, int k, int surface, Random rand, double edgeFactor) {
        boolean dune;
        double innerScale = 0.0625;
        double mainScale = 0.25;
        double floorScale = 0.5 / mainScale;
        int dx = chunkX + i;
        int dz = chunkZ + k;
        ChromaDimensionManager.ChromaDimensionBiomeType biome = BiomeDistributor.getBiome(dx, dz).getExactType();
        double rx = this.calcR(chunkX, i, innerScale, mainScale);
        double rz = this.calcR(chunkZ, k, innerScale, mainScale);
        int h = (int)(edgeFactor * ReikaMathLibrary.normalizeToBounds((double)this.heightNoise.getValue(rx, rz), (double)98.0, (double)MAX_Y) + (1.0 - edgeFactor) * 104.0);
        double dn = this.duneNoise.getValue(rx, rz);
        ArrayList<BlockKey> li = HEIGHT_LEVELS[(h - 98) / 3];
        boolean bl = dune = dn > 0.0;
        if (dune) {
            h = (int)((double)h + dn * ReikaMathLibrary.normalizeToBounds((double)this.duneHeightNoise.getValue(rx, rz), (double)3.0, (double)12.0));
        }
        this.generateLandColumn(world, dx, dz, h, rx, rz, dune, li);
    }

    private void generateLandColumn(World world, int x, int z, int h, double rx, double rz, boolean dune, ArrayList<BlockKey> topBlocks) {
        int y;
        double val;
        for (int y2 = 5; y2 < h; ++y2) {
            world.func_147449_b(x, y2, z, Blocks.field_150348_b);
        }
        BlockKey b = null;
        if (dune) {
            val = this.beachTypeNoise.getValue(rx, rz);
            b = new BlockKey(ChromaBlocks.SPARKLE.getBlockInstance(), val < 0.0 ? BlockSparkle.BlockTypes.SAND.ordinal() : BlockSparkle.BlockTypes.STONE.ordinal());
        } else if (topBlocks.size() == 1) {
            b = topBlocks.get(0);
        } else {
            val = this.beachTypeNoise.getValue(rx + (double)(h * 2370), rz + (double)(h * 1203));
            val = ReikaMathLibrary.normalizeToBounds((double)val, (double)0.0, (double)((double)topBlocks.size() - 0.001));
            val = MathHelper.func_151237_a((double)(val + this.beachTypeOffsetNoise.getValue(rx, rz)), (double)0.0, (double)((double)topBlocks.size() - 0.001));
            b = topBlocks.get((int)val);
        }
        if (Math.abs(this.sparkleChoiceNoise.getValue(rx + (double)(h * 37), rz + (double)(h * 28))) < 0.5) {
            b = new BlockKey(BlockSparkle.BlockTypes.values()[b.metadata].getBlockProxy(), 0);
        }
        if (b.blockID == Blocks.field_150348_b) {
            b = new BlockKey((Block)Blocks.field_150349_c, 0);
        }
        world.func_147465_d(x, h, z, b.blockID, b.metadata, 2);
        int ay = Math.max(103, h + 1);
        for (y = h + 1; y < 103; ++y) {
            world.func_147449_b(x, y, z, ChromaBlocks.LUMA.getBlockInstance());
        }
        for (y = ay; y < 256; ++y) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    @Override
    public double getBiomeSearchDistance() {
        return 8.0;
    }
}

