/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Terrain;

import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TerrainGenSkylandCanyons
extends ChromaDimensionBiomeTerrainShaper {
    private final SimplexNoiseGenerator canyonDepth;
    private final SimplexNoiseGenerator canyonShape;
    private final SimplexNoiseGenerator bottomEdge;
    private final SimplexNoiseGenerator bottomLowerEdge;
    private final SimplexNoiseGenerator islandIntensity;
    private static final double MIN_DEPTH = 12.0;
    private static final double MAX_DEPTH = 94.0;
    public static final int LOW_FLOOR = 10;
    public static final int HIGH_FLOOR = 30;
    public static final int LOW_CEIL = 35;
    public static final int HIGH_CEIL = 50;
    public static final int BIOME_SEARCH = 24;
    public static final int VERTICAL_BUFFER = 18;

    public TerrainGenSkylandCanyons(long seed) {
        super(seed, ChromaDimensionManager.Biomes.SKYLANDS, ChromaDimensionManager.SubBiomes.VOIDLANDS);
        this.canyonDepth = new SimplexNoiseGenerator(seed);
        this.canyonShape = new SimplexNoiseGenerator(seed ^ 0xFFFFFFFFFFFFFFFFL);
        this.bottomEdge = new SimplexNoiseGenerator(-seed);
        this.bottomLowerEdge = new SimplexNoiseGenerator(-seed ^ 0xFFFFFFFFFFFFFFFFL);
        this.islandIntensity = new SimplexNoiseGenerator(seed ^ -seed);
    }

    @Override
    public void generateColumn(World world, int chunkX, int chunkZ, int i, int k, int surface, Random rand, double edgeFactor) {
        int h1;
        double innerScale = 0.0625;
        double mainScale = 0.6666666666666666;
        int dx = chunkX + i;
        int dz = chunkZ + k;
        boolean isVoid = BiomeDistributor.getBiome(dx, dz).getExactType() == ChromaDimensionManager.SubBiomes.VOIDLANDS;
        int dt = 1 + rand.nextInt(4);
        double rx = this.calcR(chunkX, i, innerScale, mainScale);
        double rz = this.calcR(chunkZ, k, innerScale, mainScale);
        double raw = Math.pow(1.0 - Math.abs(this.canyonShape.getValue(rx, rz)), 5.0);
        double df = ReikaMathLibrary.normalizeToBounds((double)this.canyonDepth.getValue(rx, rz), (double)12.0, (double)94.0);
        double depth = MathHelper.func_151237_a((double)(raw * df), (double)0.0, (double)94.0);
        int h = (int)(depth *= edgeFactor);
        for (int j = 0; j <= h + 18; ++j) {
            int dy = 122 - j;
            this.cutBlock(world, dx, dy, dz);
        }
        world.func_147465_d(dx, 104 - h - 1, dz, (Block)Blocks.field_150349_c, 0, 2);
        for (int di = 0; di < dt; ++di) {
            world.func_147465_d(dx, 104 - h - 2 - di, dz, Blocks.field_150346_d, 0, 2);
        }
        double floor = ReikaMathLibrary.normalizeToBounds((double)this.bottomLowerEdge.getValue(rx, rz), (double)10.0, (double)30.0);
        double h2 = ReikaMathLibrary.normalizeToBounds((double)this.bottomEdge.getValue(rx, rz), (double)35.0, (double)50.0);
        if (edgeFactor < 1.0) {
            double avg = (floor + h2) / 2.0;
            h2 = avg + (h2 - avg) * edgeFactor;
            floor = avg - (avg - floor) * edgeFactor;
        }
        int dy = h1 = isVoid ? 0 : (int)floor;
        while ((double)dy <= h2) {
            this.cutBlock(world, dx, dy, dz);
            ++dy;
        }
        if (h1 > 0) {
            world.func_147465_d(dx, h1 - 1, dz, (Block)Blocks.field_150349_c, 0, 2);
            for (int di = 0; di < dt; ++di) {
                world.func_147465_d(dx, h1 - 2 - di, dz, Blocks.field_150346_d, 0, 2);
            }
        }
        if (isVoid) {
            double densityControl = ReikaMathLibrary.normalizeToBounds((double)this.islandIntensity.getValue(rx, rz), (double)-20.0, (double)-3.0);
            double islandHeight = Math.max(0.0, ReikaMathLibrary.normalizeToBounds((double)this.bottomLowerEdge.getValue(rx, rz), (double)densityControl, (double)15.0));
            if (islandHeight > 0.0) {
                int i1 = (int)(15.0 - islandHeight);
                int i2 = (int)(15.0 + islandHeight);
                for (int dy2 = i1; dy2 <= i2; ++dy2) {
                    Block b = Blocks.field_150348_b;
                    if (dy2 == i2) {
                        b = Blocks.field_150349_c;
                    } else if (i2 - dy2 < dt) {
                        b = Blocks.field_150346_d;
                    }
                    world.func_147465_d(dx, dy2, dz, b, 0, 2);
                }
            }
        }
    }

    @Override
    public double getBiomeSearchDistance() {
        return 24.0;
    }
}

