/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Terrain;

import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.BiomeDistributor;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class TerrainGenChromaIslands
extends ChromaDimensionBiomeTerrainShaper {
    private final SimplexNoiseGenerator bubbleNoise;
    private final SimplexNoiseGenerator floorNoise;
    private final SimplexNoiseGenerator sandNoise;
    private static final int MIN_FLOOR_OCEAN = 6;
    private static final int MAX_FLOOR_OCEAN = 36;
    private static final int MIN_FLOOR_SHALLOWS = 64;
    private static final int MAX_FLOOR_SHALLOWS = 80;
    private static final double ARCH_VAL_LIMIT = 0.4;

    public TerrainGenChromaIslands(long seed) {
        super(seed, ChromaDimensionManager.Biomes.ISLANDS, ChromaDimensionManager.SubBiomes.DEEPOCEAN);
        this.floorNoise = new SimplexNoiseGenerator(seed);
        this.bubbleNoise = new SimplexNoiseGenerator(seed ^ 0xFFFFFFFFFFFFFFFFL);
        this.sandNoise = new SimplexNoiseGenerator(-seed);
    }

    @Override
    public void generateColumn(World world, int chunkX, int chunkZ, int i, int k, int surface, Random rand, double edgeFactor) {
        double innerScale = 0.0625;
        double mainScale = 0.25;
        double floorScale = 0.5 / mainScale;
        int dx = chunkX + i;
        int dz = chunkZ + k;
        ChromaDimensionManager.ChromaDimensionBiomeType biome = BiomeDistributor.getBiome(dx, dz).getExactType();
        boolean ocean = biome == ChromaDimensionManager.SubBiomes.DEEPOCEAN;
        double rx = this.calcR(chunkX, i, innerScale, mainScale);
        double rz = this.calcR(chunkZ, k, innerScale, mainScale);
        double ay1 = 0.0;
        double ay2 = 0.0;
        double min = ocean ? 6.0 : 64.0;
        double max = ocean ? 36.0 : 80.0;
        double f = ReikaMathLibrary.normalizeToBounds((double)this.floorNoise.getValue(rx * floorScale, rz * floorScale), (double)min, (double)max);
        double d = 0.25;
        if (!ocean) {
            double df = 1.0 - Math.abs(this.bubbleNoise.getValue(rx * floorScale * d, rz * floorScale * d));
            df = Math.pow(df, 6.0);
            f += df * (104.0 - max + 12.0);
        }
        int maxy = 124;
        for (int y = 0; y <= maxy; ++y) {
            double ry = this.calcR(0, y, innerScale, mainScale);
            Object b = Blocks.field_150355_j;
            if ((double)y >= ay1 && (double)y <= ay2 || (double)y <= f) {
                b = Blocks.field_150348_b;
            }
            if (y == 0) {
                b = Blocks.field_150357_h;
            }
            if (y >= 103) {
                if (b == Blocks.field_150355_j) {
                    b = Blocks.field_150350_a;
                } else if (b == Blocks.field_150348_b && (double)y <= f) {
                    b = y == (int)f ? Blocks.field_150349_c : Blocks.field_150346_d;
                }
            }
            if (b == Blocks.field_150348_b && y == (int)f) {
                double type = this.sandNoise.getValue(rx, rz);
                Object object = b = type >= 0.0 ? Blocks.field_150346_d : Blocks.field_150354_m;
            }
            if (b == Blocks.field_150350_a) {
                Block at = world.func_147439_a(dx, y, dz);
                if (at == ChromaBlocks.GLOWLEAF.getBlockInstance() || at == ChromaBlocks.GLOWLOG.getBlockInstance()) continue;
                this.cutBlock(world, dx, y, dz);
                continue;
            }
            world.func_147465_d(dx, y, dz, b, 0, 2);
        }
    }

    @Override
    public double getBiomeSearchDistance() {
        return 16.0;
    }
}

