/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class StructureCalculator
extends ThreadedGenerator {
    private final Random seededRand;
    private final int maxAttempts;
    private final Thread callerThread;
    private int structureOriginX;
    private int structureOriginZ;
    private float structureAngleOrigin;
    private boolean positionsDetermined = false;
    public static final int STRUCTURE_CENTER_VARIATION = 6000;
    public static final int BASE_RADIUS = 5000;
    public static final int RADIUS_VARIATION = 3000;

    public StructureCalculator(long seed) {
        this(seed, 10);
    }

    private StructureCalculator(long seed, int max) {
        super(seed);
        this.maxAttempts = max;
        this.callerThread = Thread.currentThread();
        this.seededRand = new Random(this.generateOrGetGenSeed());
    }

    public double getMaximumDistanceFromOrigin() {
        double x = Math.max(Math.abs(this.structureOriginX + 5000 + 3000), Math.abs(this.structureOriginX - 5000 - 3000));
        double z = Math.max(Math.abs(this.structureOriginZ + 5000 + 3000), Math.abs(this.structureOriginZ - 5000 - 3000));
        return ReikaMathLibrary.py3d((double)x, (double)0.0, (double)z);
    }

    public static double getMaximumPossibleDistance() {
        return 14000.0;
    }

    public boolean arePositionsDetermined() {
        return this.positionsDetermined;
    }

    private long generateOrGetGenSeed() {
        File f = new File(DragonAPICore.getMinecraftDirectoryString() + "/ChromatiCraft_Data/DimensionGen.dat");
        try {
            if (f.exists()) {
                try {
                    ArrayList li = ReikaFileReader.getFileAsLines((File)f, (boolean)true);
                    if (!li.isEmpty()) {
                        String s = (String)li.get(0);
                        s = s.substring(s.indexOf(58) + 1);
                        return Long.parseLong(s);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    f.delete();
                }
            }
            f.getParentFile().mkdirs();
            f.createNewFile();
            long seed = System.currentTimeMillis();
            ReikaFileReader.writeLinesToFile((File)f, (ArrayList)ReikaJavaLibrary.makeListFrom((Object)("Seed:" + String.valueOf(seed))), (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File("c:").getTotalSpace() ^ (long)System.getProperty("os.name").hashCode();
    }

    @Override
    public void run() throws Throwable {
        this.generate();
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            ChromatiCraft.logger.log((Object)("Generated Structures: " + ChunkProviderChroma.structures));
        }
    }

    private void generate() throws OutOfMemoryError {
        ArrayList<DimensionStructureGenerator.DimensionStructureType> structs = this.getUsableStructures();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            int index = this.seededRand.nextInt(structs.size());
            DimensionStructureGenerator.DimensionStructureType e = structs.get(index);
            structs.remove(index);
            ChunkProviderChroma.structures.add(new DimensionStructureGenerator.StructurePair(e.createGenerator(), CrystalElement.elements[i]));
            if (!structs.isEmpty()) continue;
            structs = this.getUsableStructures();
        }
        this.structureOriginX = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)6000);
        this.structureOriginZ = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)6000);
        this.structureAngleOrigin = this.rand.nextFloat() * 360.0f;
        this.positionsDetermined = true;
        for (DimensionStructureGenerator.StructurePair s : new ArrayList<DimensionStructureGenerator.StructurePair>(ChunkProviderChroma.structures)) {
            this.tryGenerate(s, 0);
        }
        this.generateMonument();
    }

    @Override
    public String getStateMessage() {
        return ChunkProviderChroma.getStructures().size() + " structures generated.";
    }

    private void generateMonument() {
        ChunkProviderChroma.monument.startCalculate(this.structureOriginX, this.structureOriginZ, this.rand);
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            String sg = "CHROMATICRAFT: Generated the monument at " + this.structureOriginX + ", " + this.structureOriginZ + ".";
            ReikaJavaLibrary.pConsole((Object)sg);
        }
    }

    private ArrayList<DimensionStructureGenerator.DimensionStructureType> getUsableStructures() {
        ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])DimensionStructureGenerator.DimensionStructureType.types);
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return li;
        }
        Iterator it = li.iterator();
        while (it.hasNext()) {
            DimensionStructureGenerator.DimensionStructureType d = (DimensionStructureGenerator.DimensionStructureType)((Object)it.next());
            if (d.isComplete()) continue;
            it.remove();
        }
        return li;
    }

    private void tryGenerate(DimensionStructureGenerator.StructurePair p, int attempt) {
        block6: {
            try {
                this.doGenerate(p);
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e;
                }
                boolean redo = attempt < this.maxAttempts;
                StackTraceElement[] st = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                sb.append("Error calculating structure " + p.generator + ": ");
                sb.append(e.toString());
                int n = Math.min(6, st.length);
                for (int i = 0; i < n; ++i) {
                    sb.append(" @ ");
                    sb.append(st[i]);
                }
                sb.append("! ");
                if (redo) {
                    sb.append("Re-attempting...");
                } else {
                    sb.append("Already failed too many (" + this.maxAttempts + ") times. Giving up.");
                }
                ChromatiCraft.logger.logError((Object)sb.toString());
                p.generator.clear();
                ChunkProviderChroma.structures.remove(p);
                if (!redo) break block6;
                this.tryGenerate(p, attempt + 1);
            }
        }
    }

    private void doGenerate(DimensionStructureGenerator.StructurePair s) {
        double ang = Math.toRadians((double)this.structureAngleOrigin + (double)s.color.ordinal() * 22.5);
        int r = ReikaRandomHelper.getRandomPlusMinus((int)5000, (int)3000);
        int x = this.structureOriginX + (int)((double)r * Math.cos(ang));
        int z = this.structureOriginZ + (int)((double)r * Math.sin(ang));
        long t = System.currentTimeMillis();
        s.generator.startCalculate(s.color, x, z, this.rand);
        double dt = (double)(System.currentTimeMillis() - t) / 1000.0;
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            String sg = "CHROMATICRAFT: Generated a " + (Object)((Object)s.color) + " " + s.generator + " at " + s.generator.getEntryPosX() + ", " + s.generator.getEntryPosZ() + " in " + dt + " s";
            ReikaJavaLibrary.pConsole((Object)sg);
        }
    }
}

