/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Water;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class WaterPath {
    final Point startLoc;
    final Point endLoc;
    private final int gridSize;
    private final HashSet<Point> visitedCells = new HashSet();
    final LinkedList<Point> solution = new LinkedList();
    final HashSet<ForgeDirection>[][] lockSides;

    public WaterPath(int sx, int sz, int ex, int ez, int size) {
        this.startLoc = new Point(sx, sz);
        this.endLoc = new Point(ex, ez);
        this.gridSize = size;
        int s = size * 2 + 1;
        this.lockSides = new HashSet[s][s];
        for (int i = 0; i < this.lockSides.length; ++i) {
            for (int k = 0; k < this.lockSides[i].length; ++k) {
                this.lockSides[i][k] = new HashSet();
            }
        }
        this.visitedCells.add(this.startLoc);
        this.visitedCells.add(this.endLoc);
    }

    public void genPath(Random rand) {
        ArrayList<Point> li = this.generateShortestPath();
        boolean flag = true;
        while (flag) {
            flag = false;
            ArrayList indicesToTry = ReikaJavaLibrary.makeIntListFromArray((int[])ReikaArrayHelper.getLinearArray((int)(li.size() - 1)));
            while (!indicesToTry.isEmpty() && !flag) {
                int idx = (Integer)indicesToTry.remove(rand.nextInt(indicesToTry.size()));
                Point p1 = li.get(idx);
                Point p2 = li.get(idx + 1);
                ForgeDirection dir = ReikaDirectionHelper.getDirectionBetween((Point)p1, (Point)p2);
                flag = this.tryExtendPath(p1, p2, idx, li, dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir));
                if (flag) continue;
                dir = dir.getOpposite();
                flag = this.tryExtendPath(p1, p2, idx, li, dir);
            }
        }
        for (int i = 0; i < li.size() - 1; ++i) {
            Point p1 = li.get(i);
            Point p2 = li.get(i + 1);
            this.stepTo(p1, p2);
        }
        this.solution.addAll(li);
    }

    private boolean tryExtendPath(Point p1, Point p2, int idx, ArrayList<Point> li, ForgeDirection dir) {
        if (this.canStepTo(p1, dir, 1, false) && this.canStepTo(p2, dir, 1, false)) {
            int dist = 0;
            boolean flag2 = true;
            while (flag2) {
                flag2 = false;
                if (!this.canStepTo(p1, dir, ++dist, false) || !this.canStepTo(p2, dir, dist, false)) continue;
                flag2 = true;
            }
            ArrayList<Point> inject = new ArrayList<Point>();
            for (int i = dist - 1; i > 0; --i) {
                inject.add(0, new Point(p1.x + dir.offsetX * i, p1.y + dir.offsetZ * i));
                inject.add(new Point(p2.x + dir.offsetX * i, p2.y + dir.offsetZ * i));
            }
            this.visitedCells.addAll(inject);
            li.addAll(idx + 1, inject);
            return true;
        }
        return false;
    }

    private ArrayList<Point> generateShortestPath() {
        int dx = this.endLoc.x - this.startLoc.x;
        int dz = this.endLoc.y - this.startLoc.y;
        Point p = this.startLoc;
        ArrayList<Point> li = new ArrayList<Point>();
        li.add(p);
        while (dx != 0) {
            p = this.stepTo(p, dx > 0 ? ForgeDirection.EAST : ForgeDirection.WEST);
            li.add(p);
            dx = (int)Math.signum(dx) * (Math.abs(dx) - 1);
        }
        while (dz != 0) {
            p = this.stepTo(p, dz > 0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH);
            li.add(p);
            dz = (int)Math.signum(dz) * (Math.abs(dz) - 1);
        }
        return li;
    }

    private boolean canStepTo(Point from, ForgeDirection dir, int dist, boolean allowRevisit) {
        Point to = new Point(from.x + dir.offsetX * dist, from.y + dir.offsetZ * dist);
        return Math.abs(to.x) <= this.gridSize && Math.abs(to.y) <= this.gridSize && (allowRevisit || !this.visitedCells.contains(to));
    }

    private Point stepTo(Point from, ForgeDirection dir) {
        Point to = new Point(from.x + dir.offsetX, from.y + dir.offsetZ);
        this.visitedCells.add(to);
        return to;
    }

    private void stepTo(Point from, Point to) {
        ForgeDirection dir = ReikaDirectionHelper.getDirectionBetween((Point)from, (Point)to);
        int idx1a = from.x + this.gridSize;
        int idx1b = from.y + this.gridSize;
        int idx2a = to.x + this.gridSize;
        int idx2b = to.y + this.gridSize;
        this.lockSides[idx1a][idx1b].add(dir);
        this.lockSides[idx2a][idx2b].add(dir.getOpposite());
    }

    public LinkedList<Point> getSolution() {
        return new LinkedList<Point>(this.solution);
    }

    public String toString() {
        return this.solution.size() + ": " + this.solution.toString();
    }
}

