/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.TDMaze.LootRoom;
import Reika.ChromatiCraft.World.Dimension.Structure.TDMaze.MazeRoom;
import Reika.ChromatiCraft.World.Dimension.Structure.TDMaze.TDMazeEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.TDMaze.TunnelPiece;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ThreeDMazeGenerator
extends DimensionStructureGenerator {
    private final LinkedList<ForgeDirection> pathCache = new LinkedList();
    private final LinkedList<Coordinate> pathLocs = new LinkedList();
    private final HashSet<Coordinate> coordCache = new HashSet();
    private final MultiMap<Coordinate, ForgeDirection> locationCache = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private final ArrayList<MazeRoom> rooms = new ArrayList();
    private final HashSet<Coordinate> roomSpaces = new HashSet();
    private Coordinate step;
    private ForgeDirection nextDir;
    private int goalDistance;
    private HashMap<Coordinate, Integer> distances = new HashMap();
    private static final int MAX_SIZE_X = ThreeDMazeGenerator.getWidth();
    private static final int MAX_SIZE_Y = ThreeDMazeGenerator.getHeight();
    private static final int MAX_SIZE_Z = ThreeDMazeGenerator.getWidth();
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private int partSize;

    private static int getWidth() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
        }
        return 24;
    }

    private static int getHeight() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
        }
        return 12;
    }

    @Override
    public void calculate(int x, int z, Random rand) {
        this.posY = 75;
        this.partSize = 4;
        this.minX = x - this.partSize * MAX_SIZE_X / 2;
        this.maxX = x + this.partSize * MAX_SIZE_X / 2;
        this.minZ = z - this.partSize * MAX_SIZE_Z / 2;
        this.maxZ = z + this.partSize * MAX_SIZE_Z / 2;
        this.maxY = this.posY;
        this.minY = this.posY - this.partSize * MAX_SIZE_Y;
        this.generatePathFrom(MAX_SIZE_X / 2, MAX_SIZE_Y - 1, MAX_SIZE_Z / 2, rand);
        this.cutExits(rand);
        this.cutExtras(rand);
        this.addRooms(rand);
        this.generateBlocks(x, this.posY, z, rand);
        int mx = x + this.partSize * MAX_SIZE_X / 2 + this.partSize / 2;
        int mz = z + this.partSize * MAX_SIZE_Z / 2 + this.partSize / 2;
        this.entryX = mx;
        this.entryZ = mz;
        int by = this.posY - this.partSize * (MAX_SIZE_Y + 1) + this.partSize / 2;
        new LootRoom(this, rand).generate(this.world, mx, by, mz);
        this.addDynamicStructure(new TDMazeEntrance(this), mx, mz);
    }

    @Override
    protected int getCenterXOffset() {
        return this.partSize * (MAX_SIZE_X + 1) / 2;
    }

    @Override
    protected int getCenterZOffset() {
        return this.partSize * (MAX_SIZE_Z + 1) / 2;
    }

    private void generateBlocks(int x, int y, int z, Random rand) {
        for (int i = 0; i < MAX_SIZE_X; ++i) {
            for (int j = 0; j < MAX_SIZE_Y; ++j) {
                for (int k = 0; k < MAX_SIZE_Z; ++k) {
                    Coordinate c = new Coordinate(i, j, k);
                    TunnelPiece p = new TunnelPiece(this, this.partSize);
                    Collection dirs = this.locationCache.get((Object)new Coordinate(i, j, k));
                    for (ForgeDirection dir : dirs) {
                        p.connect(dir);
                    }
                    int ndl = 3;
                    if (i % ndl == 0 && j % (ndl / 2) == 0 && k % ndl == 0) {
                        p.setLighted();
                    }
                    if (i != 0 && j != 0 && k != 0 && i != MAX_SIZE_X - 1 && j != MAX_SIZE_Y - 1 && k != MAX_SIZE_Z - 1 && rand.nextInt(10) == 0) {
                        p.addWindow(ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)]);
                        while (rand.nextInt(10) == 0) {
                            p.addWindow(ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)]);
                        }
                    }
                    int dx = x + i * this.partSize;
                    int dy = y + j * this.partSize - MAX_SIZE_Y * this.partSize;
                    int dz = z + k * this.partSize;
                    p.generate(this.world, dx, dy, dz);
                }
            }
        }
        for (MazeRoom r : this.rooms) {
            int dx = x + r.center.xCoord * this.partSize;
            int dy = y + r.center.yCoord * this.partSize - MAX_SIZE_Y * this.partSize;
            int dz = z + r.center.zCoord * this.partSize;
            r.generate(this.world, dx, dy, dz);
        }
    }

    private void cutExits(Random rand) {
        this.locationCache.addValue((Object)new Coordinate(MAX_SIZE_X / 2, MAX_SIZE_Y - 1, MAX_SIZE_Z / 2), (Object)ForgeDirection.UP);
        this.locationCache.addValue((Object)new Coordinate(MAX_SIZE_X / 2, 0, MAX_SIZE_Z / 2), (Object)ForgeDirection.DOWN);
    }

    private void cutExtras(Random rand) {
        int rx = 4 + rand.nextInt(MAX_SIZE_X * 4 / 5);
        int ry = 2 + rand.nextInt(MAX_SIZE_Y / 2);
        int rz = 4 + rand.nextInt(MAX_SIZE_Z * 4 / 5);
        int n = rx * ry * rz;
        for (int i = 0; i < n; ++i) {
            Coordinate c = new Coordinate(rand.nextInt(MAX_SIZE_X), rand.nextInt(MAX_SIZE_Y), rand.nextInt(MAX_SIZE_Z));
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)];
            if (!this.canMove(c.xCoord, c.yCoord, c.zCoord, dir)) continue;
            this.locationCache.addValue((Object)c, (Object)dir);
        }
    }

    private void addRooms(Random rand) {
        int n = (int)(Math.sqrt(MAX_SIZE_X * MAX_SIZE_Y * MAX_SIZE_Z) / 2.0);
        Coordinate start = new Coordinate(MAX_SIZE_X / 2, MAX_SIZE_Y - 1, MAX_SIZE_Z / 2);
        Coordinate end = new Coordinate(MAX_SIZE_X / 2, MAX_SIZE_Y - 1, MAX_SIZE_Z / 2);
        for (int a = 0; a < n; ++a) {
            int tries;
            boolean large = rand.nextInt(6) == 0;
            int s = large ? 2 : 1;
            int dx = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_X - s - 1));
            int dy = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Y - s - 1));
            int dz = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Z - s - 1));
            Coordinate c = new Coordinate(dx, dy, dz);
            int d = 4 + s;
            for (tries = 0; (c.getTaxicabDistanceTo(end) < d || c.getTaxicabDistanceTo(start) < d) && tries < 50; ++tries) {
                dx = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_X - s - 1));
                dy = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Y - s - 1));
                dz = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Z - s - 1));
                c = new Coordinate(dx, dy, dz);
            }
            boolean flag = false;
            do {
                for (int i = -s - 1; i <= s + 1; ++i) {
                    for (int k = -s - 1; k <= s + 1; ++k) {
                        Coordinate c2 = c.offset(i, 0, k);
                        if (!this.roomSpaces.contains(c2)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                if (!flag) continue;
                dx = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_X - s));
                dy = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Y - s));
                dz = ReikaRandomHelper.getRandomBetween((int)s, (int)(MAX_SIZE_Z - s));
                c = new Coordinate(dx, dy, dz);
            } while (flag && ++tries < 50);
            if (tries >= 50) continue;
            MazeRoom r = new MazeRoom(this, this.partSize, s, c, rand);
            for (int i = -s; i <= s; ++i) {
                for (int k = -s; k <= s; ++k) {
                    Coordinate c2 = c.offset(i, 0, k);
                    this.roomSpaces.add(c2);
                    r.addCell(c2);
                }
            }
            this.rooms.add(r);
        }
    }

    private void generatePathFrom(int x, int y, int z, Random rand) {
        this.pathCache.addLast(ForgeDirection.DOWN);
        this.step = new Coordinate(x, y, z);
        this.nextDir = this.getMovementDirection(x, y, z, rand);
        while (!this.isFull()) {
            this.stepPath(this.step.xCoord, this.step.yCoord, this.step.zCoord, rand, this.nextDir);
        }
    }

    private void stepPath(int x, int y, int z, Random rand, ForgeDirection dir) {
        Coordinate c = new Coordinate(x, y, z);
        this.locationCache.addValue((Object)c, (Object)dir.getOpposite());
        this.coordCache.add(c);
        this.pathLocs.addLast(c);
        if (x == MAX_SIZE_X / 2 && y == 0 && z == MAX_SIZE_Z / 2) {
            Iterator<Coordinate> it = this.pathLocs.descendingIterator();
            int d = 0;
            while (it.hasNext()) {
                Coordinate loc = it.next();
                Integer get = this.distances.get(loc);
                if (get != null) {
                    d = Math.min(d, get);
                }
                this.distances.put(loc, d);
                ++d;
            }
            this.goalDistance = 0;
        } else {
            ++this.goalDistance;
            Integer get = this.distances.get(c);
            if (get != null) {
                this.goalDistance = Math.min(this.goalDistance, get);
            }
            this.distances.put(c, this.goalDistance);
        }
        if (this.isFull()) {
            this.pathLocs.removeLast();
            return;
        }
        if (this.hasUnvisitedNeighbors(x, y, z)) {
            dir = this.getMovementDirection(x, y, z, rand);
            this.locationCache.addValue((Object)c, (Object)dir);
            this.pathCache.addLast(dir);
            this.step = new Coordinate(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            this.nextDir = dir;
        } else {
            dir = this.pathCache.removeLast();
            this.pathLocs.removeLast();
            this.step = new Coordinate(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
            this.nextDir = dir.getOpposite();
        }
    }

    private boolean isFull() {
        return this.coordCache.size() >= MAX_SIZE_X * MAX_SIZE_Y * MAX_SIZE_Z;
    }

    private Collection<ForgeDirection> getMovementDirections(int x, int y, int z, ForgeDirection last, Random rand) {
        if (rand.nextInt(3) == 0 && this.canMove(x, y, z, last) && !this.hasCellFrom(x, y, z, last)) {
            return ReikaJavaLibrary.makeListFrom((Object)last);
        }
        last = this.pathCache.getLast().getOpposite();
        int n = rand.nextInt(3) == 0 ? 2 : 1;
        ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (li.size() >= n) break;
            if (dir == last || !this.canMove(x, y, z, dir) || this.hasCellFrom(x, y, z, dir)) continue;
            li.add(dir);
        }
        if (li.isEmpty()) {
            // empty if block
        }
        return li;
    }

    private ForgeDirection getMovementDirection(int x, int y, int z, Random rand) {
        ForgeDirection last = this.pathCache.getLast().getOpposite();
        ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])ForgeDirection.VALID_DIRECTIONS);
        int idx = rand.nextInt(li.size());
        while (li.get(idx) == last || !this.canMove(x, y, z, (ForgeDirection)li.get(idx)) || this.hasCellFrom(x, y, z, (ForgeDirection)li.get(idx))) {
            li.remove(idx);
            if (li.isEmpty()) {
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                }
            }
            idx = rand.nextInt(li.size());
        }
        if (li.isEmpty()) {
            // empty if block
        }
        return (ForgeDirection)li.get(idx);
    }

    private boolean canMove(int x, int y, int z, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        return dx >= 0 && dx < MAX_SIZE_X && dy >= 0 && dy < MAX_SIZE_Y && dz >= 0 && dz < MAX_SIZE_Z;
    }

    private boolean hasCellFrom(int x, int y, int z, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        return this.coordCache.contains(new Coordinate(dx, dy, dz));
    }

    private boolean hasUnvisitedNeighbors(int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (!this.canMove(x, y, z, dir) || this.hasCellFrom(x, y, z, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearCaches() {
        this.pathCache.clear();
        this.pathLocs.clear();
        this.coordCache.clear();
        this.locationCache.clear();
        this.distances.clear();
        this.roomSpaces.clear();
        this.rooms.clear();
        this.goalDistance = 0;
        this.step = null;
        this.nextDir = null;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return true;
    }

    public int getDistanceToGoal(Coordinate loc) {
        return this.distances.get(loc);
    }

    public boolean isLocationInMaze(double x, double y, double z) {
        int px = MathHelper.func_76128_c((double)x);
        int py = MathHelper.func_76128_c((double)y);
        int pz = MathHelper.func_76128_c((double)z);
        return px >= 0 && px < MAX_SIZE_X && py >= 0 && py < MAX_SIZE_Y && pz >= 0 && pz < MAX_SIZE_Z;
    }

    public Coordinate getCellFromBlockCoords(double x, double y, double z) {
        if (!this.isLocationInMaze(x, y, z)) {
            return null;
        }
        int dx = MathHelper.func_76128_c((double)x) - this.minX;
        int dy = MathHelper.func_76128_c((double)y) - this.minY;
        int dz = MathHelper.func_76128_c((double)z) - this.minZ;
        int s = this.partSize;
        return new Coordinate(dx / s, dy / s, dz / s);
    }
}

