/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.TDMaze;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class TunnelPiece
extends StructurePiece {
    private boolean[] connections = new boolean[6];
    private boolean lights = false;
    private boolean[] windows = new boolean[6];
    public final int size;

    public TunnelPiece(DimensionStructureGenerator g, int size) {
        super(g);
        this.size = size;
    }

    public TunnelPiece connect(ForgeDirection dir) {
        this.connections[dir.ordinal()] = true;
        return this;
    }

    public TunnelPiece disconnect(ForgeDirection dir) {
        this.connections[dir.ordinal()] = false;
        return this;
    }

    public TunnelPiece setLighted() {
        this.lights = true;
        return this;
    }

    public TunnelPiece addWindow(ForgeDirection dir) {
        this.windows[dir.ordinal()] = true;
        return this;
    }

    public static TunnelPiece omni(DimensionStructureGenerator g, int size) {
        TunnelPiece tp = new TunnelPiece(g, size);
        for (int i = 0; i < 6; ++i) {
            tp.connect(ForgeDirection.VALID_DIRECTIONS[i]);
        }
        return tp;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        for (int i = 0; i <= this.size; ++i) {
            for (int j = 0; j <= this.size; ++j) {
                for (int k = 0; k <= this.size; ++k) {
                    int meta;
                    Block b;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    boolean c0 = j == 0 && i != 0 && i != this.size && k != 0 && k != this.size;
                    boolean c1 = j == this.size && i != 0 && i != this.size && k != 0 && k != this.size;
                    boolean c2 = k == 0 && j != 0 && j != this.size && i != 0 && i != this.size;
                    boolean c3 = k == this.size && j != 0 && j != this.size && i != 0 && i != this.size;
                    boolean c4 = i == 0 && j != 0 && j != this.size && k != 0 && k != this.size;
                    boolean c5 = i == this.size && j != 0 && j != this.size && k != 0 && k != this.size;
                    boolean tunnel0 = this.connections[0] && c0;
                    boolean tunnel1 = this.connections[1] && c1;
                    boolean tunnel2 = this.connections[2] && c2;
                    boolean tunnel3 = this.connections[3] && c3;
                    boolean tunnel4 = this.connections[4] && c4;
                    boolean tunnel5 = this.connections[5] && c5;
                    boolean tunnel = tunnel0 || tunnel1 || tunnel2 || tunnel3 || tunnel4 || tunnel5;
                    boolean window0 = this.windows[0] && c0;
                    boolean window1 = this.windows[1] && c1;
                    boolean window2 = this.windows[2] && c2;
                    boolean window3 = this.windows[3] && c3;
                    boolean window4 = this.windows[4] && c4;
                    boolean window5 = this.windows[5] && c5;
                    boolean window = window0 || window1 || window2 || window3 || window4 || window5;
                    boolean wall0 = i == 0;
                    boolean wall1 = i == this.size;
                    boolean wall2 = j == 0;
                    boolean wall3 = j == this.size;
                    boolean wall4 = k == 0;
                    boolean wall5 = k == this.size;
                    boolean wall = wall0 || wall1 || wall2 || wall3 || wall4 || wall5;
                    boolean fill = !tunnel && wall;
                    boolean light0 = this.lights && i == 0 && j == this.size / 2 && k == this.size / 2;
                    boolean light1 = this.lights && i == this.size && j == this.size / 2 && k == this.size / 2;
                    boolean light2 = this.lights && j == 0 && i == this.size / 2 && k == this.size / 2;
                    boolean light3 = this.lights && j == this.size && i == this.size / 2 && k == this.size / 2;
                    boolean light4 = this.lights && k == 0 && j == this.size / 2 && i == this.size / 2;
                    boolean light5 = this.lights && k == this.size && j == this.size / 2 && i == this.size / 2;
                    boolean light = light0 || light1 || light2 || light3 || light4 || light5;
                    Block block = b = fill ? ChromaBlocks.STRUCTSHIELD.getBlockInstance() : Blocks.field_150350_a;
                    int n = fill ? (light ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata) : (meta = 0);
                    if (window) {
                        meta = BlockStructureShield.BlockType.GLASS.metadata;
                    }
                    world.setBlock(dx, dy, dz, b, meta);
                }
            }
        }
    }
}

