/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.awt.Point;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class MazePiece
extends StructurePiece {
    private int[] connections = new int[6];
    public final int size;
    public final boolean node;
    private final Point position;

    public MazePiece(DimensionStructureGenerator g, int size, Point pos, boolean node) {
        super(g);
        this.size = size;
        this.node = node;
        this.position = pos;
    }

    public MazePiece connect(ForgeDirection dir, boolean open) {
        this.connections[dir.ordinal()] = open ? 2 : 1;
        return this;
    }

    public MazePiece disconnect(ForgeDirection dir) {
        this.connections[dir.ordinal()] = 0;
        return this;
    }

    public static MazePiece omni(DimensionStructureGenerator g, int size, Point pos, boolean node) {
        MazePiece tp = new MazePiece(g, size, pos, node);
        for (int i = 0; i < 6; ++i) {
            tp.connect(ForgeDirection.VALID_DIRECTIONS[i], true);
        }
        return tp;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        for (int i = 0; i <= this.size; ++i) {
            for (int j = 0; j <= 3; ++j) {
                for (int k = 0; k <= this.size; ++k) {
                    int meta;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    boolean c2 = k == 0 && j != 0 && i != 0 && i != this.size;
                    boolean c3 = k == this.size && j != 0 && i != 0 && i != this.size;
                    boolean c4 = i == 0 && j != 0 && k != 0 && k != this.size;
                    boolean c5 = i == this.size && j != 0 && k != 0 && k != this.size;
                    int tunnel2 = c2 ? this.connections[2] : 0;
                    int tunnel3 = c3 ? this.connections[3] : 0;
                    int tunnel4 = c4 ? this.connections[4] : 0;
                    int tunnel5 = c5 ? this.connections[5] : 0;
                    int tunnel = ReikaMathLibrary.multiMax((int[])new int[]{tunnel2, tunnel3, tunnel4, tunnel5});
                    boolean edge = i == 0 || i == this.size || j == 0 || k == 0 || k == this.size;
                    BlockKey bk = this.getTunnelType(tunnel);
                    Block b = edge ? bk.blockID : Blocks.field_150350_a;
                    int n = meta = edge ? bk.metadata : 0;
                    if (bk.blockID == ChromaBlocks.SHIFTLOCK.getBlockInstance()) {
                        ForgeDirection dir = ReikaDirectionHelper.getSideOfBox((int)i, (int)j, (int)k, (boolean)false, (int)this.size);
                        ((ShiftMazeGenerator)this.parent).cacheLock(dx, dy, dz);
                    }
                    world.setBlock(dx, dy, dz, b, meta);
                }
            }
        }
        if (this.node) {
            world.setBlock(x + this.size / 2, y + this.size / 2, z + this.size / 2, Blocks.field_150343_Z);
        }
    }

    private BlockKey getTunnelType(int idx) {
        switch (idx) {
            default: {
                return new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            case 1: {
                return new BlockKey(ChromaBlocks.SHIFTLOCK.getBlockInstance(), 0);
            }
            case 2: 
        }
        return new BlockKey(Blocks.field_150350_a, 0);
    }
}

