/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class MazeAnchor
extends StructurePiece {
    private final int partSize;
    private final int genMetadata;
    private final BlockKey pyramidBlock;
    private static final WeightedRandom<BlockKey> blockRand = new WeightedRandom();

    public MazeAnchor(DimensionStructureGenerator s, int size, int meta, Random r) {
        super(s);
        this.partSize = size * 3;
        this.genMetadata = meta;
        this.pyramidBlock = MazeAnchor.getRandomBlockType(s, r);
    }

    private static BlockKey getRandomBlockType(DimensionStructureGenerator s, Random r) {
        return (BlockKey)blockRand.getRandomEntry();
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int meta = BlockStructureShield.BlockType.STONE.metadata;
        for (int i = 0; i <= this.partSize; ++i) {
            for (int k = 0; k <= this.partSize; ++k) {
                int dx = x + i - this.partSize / 2 + 2;
                int dz = z + k - this.partSize / 2 + 2;
                world.setBlock(dx, y, dz, b, meta);
            }
        }
        int h = 3;
        for (int j = 0; j <= h; ++j) {
            int in;
            for (int i = in = j + 4; i <= this.partSize - in; ++i) {
                for (int k = in; k <= this.partSize - in; ++k) {
                    int dx = x + i - this.partSize / 2 + 2;
                    int dz = z + k - this.partSize / 2 + 2;
                    world.setBlock(dx, y + j + 1, dz, this.pyramidBlock);
                }
            }
        }
        int dx = x - this.partSize / 2 + 8;
        int dz = z - this.partSize / 2 + 8;
        world.setBlock(dx, y + 1, dz, ChromaBlocks.SHIFTKEY.getBlockInstance(), this.genMetadata);
    }

    static {
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150426_aN), 30.0);
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150402_ci), 50.0);
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150371_ca, 0), 25.0);
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150371_ca, 1), 25.0);
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150451_bX), 40.0);
        blockRand.addEntry((Object)new BlockKey(Blocks.field_150368_y), 20.0);
    }
}

