/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.util.ForgeDirection;

public class SegmentDiscoverer {
    private final MazeGrid grid;
    private List<Point> overallVisisted = new LinkedList<Point>();
    private int segmentCounter = 0;

    public SegmentDiscoverer(MazeGrid grid) {
        this.grid = grid;
    }

    public void reset() {
        this.segmentCounter = 0;
        this.overallVisisted.clear();
    }

    public boolean hasFound(Point toFind) {
        for (Point p : this.overallVisisted) {
            if (!p.equals(toFind)) continue;
            return true;
        }
        return false;
    }

    public void runCalc(Collection<Point> segmentStartPoints, ShiftMazeState mazeState, boolean ignoreDoorStates) {
        for (Point p : segmentStartPoints) {
            this.startCalculation(p, mazeState, ignoreDoorStates);
        }
    }

    private void startCalculation(Point start, ShiftMazeState mazeState, boolean ignoreDoorStates) {
        int count = 0;
        this.overallVisisted.add(start);
        LinkedList<Point> todo = new LinkedList<Point>();
        todo.add(start);
        while (!todo.isEmpty()) {
            Point next = (Point)todo.removeFirst();
            List<Point> surrounded = this.getConnectingSegments(next, mazeState, ignoreDoorStates);
            count += surrounded.size();
            todo.addAll(surrounded);
        }
        System.out.println("Found " + count + " overall mazeParts to connect to.");
    }

    private List<Point> getConnectingSegments(Point center, ShiftMazeState state, boolean ignoreStates) {
        LinkedList<Point> collected = new LinkedList<Point>();
        MazeGrid.MazeSegment at = this.grid.getSegment(center.x, center.y);
        for (ForgeDirection dir : MazeGrid.MazeSegment.VALID_CONNECTIONS) {
            MazeGrid.MazeSegment other;
            int tX = center.x + dir.offsetX;
            int tZ = center.y + dir.offsetZ;
            Point target = new Point(tX, tZ);
            System.out.println("Point to scan: " + target);
            if (this.overallVisisted.contains(target)) {
                System.out.println("Found an already-found point. Not adding.");
                continue;
            }
            if (!this.grid.isInBounds(tX, tZ)) continue;
            this.overallVisisted.add(new Point(tX, tZ));
            MazeGrid.ShiftMazeDoor door = this.grid.getDoor(center, target);
            if (door != null) {
                System.out.println("Found a door!");
            }
            if (door != null && state != null && !ignoreStates) {
                System.out.println("Need to do door state checks.");
                boolean foundOpenState = door.doorStates.isEmpty();
                for (ShiftMazeState openState : door.doorStates) {
                    if (!openState.equals(state)) continue;
                    foundOpenState = true;
                    break;
                }
                if (!foundOpenState) continue;
            }
            if (!(other = this.grid.getSegment(tX, tZ)).getConnections().contains(dir.getOpposite()) && !at.getConnections().contains(dir)) continue;
            System.out.println("Connecting with direction " + dir.name());
            collected.add(target);
        }
        System.out.println("Found " + collected.size() + " connections.");
        return collected;
    }
}

