/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class KruskalDiscoverer {
    private final MazeGrid grid;
    private final Random seededRand;

    public KruskalDiscoverer(Random rand, MazeGrid grid) {
        this.grid = grid;
        this.seededRand = rand;
    }

    public void calculateMazeSegment(List<Point> pointsInSegment) {
        HashMap<Point, LinkedList<Object>> associated = new HashMap<Point, LinkedList<Object>>();
        LinkedList<GridConnection> cons = new LinkedList<GridConnection>();
        for (int xx = 0; xx < this.grid.getXSize(); ++xx) {
            for (int zz = 0; zz < this.grid.getZSize(); ++zz) {
                Point at = new Point(xx, zz);
                if (!pointsInSegment.contains(at) || this.grid.getSegment((int)xx, (int)zz).specialLock) continue;
                Point southAt = new Point(xx, zz + 1);
                Point eastAt = new Point(xx + 1, zz);
                if (!associated.containsKey(at)) {
                    associated.put(at, new LinkedList());
                }
                if (pointsInSegment.contains(southAt) && this.grid.isInBounds(southAt.x, southAt.y) && this.grid.isFree(southAt.x, southAt.y) && !this.grid.getSegment((int)southAt.x, (int)southAt.y).specialLock) {
                    cons.add(new GridConnection(at, southAt, ForgeDirection.SOUTH));
                    if (!associated.containsKey(southAt)) {
                        associated.put(southAt, new LinkedList());
                    }
                }
                if (!pointsInSegment.contains(eastAt) || !this.grid.isInBounds(southAt.x, southAt.y) || !this.grid.isFree(eastAt.x, eastAt.y) || this.grid.getSegment((int)eastAt.x, (int)eastAt.y).specialLock) continue;
                cons.add(new GridConnection(at, eastAt, ForgeDirection.EAST));
                if (associated.containsKey(eastAt)) continue;
                associated.put(eastAt, new LinkedList());
            }
        }
        Collections.shuffle(cons, this.seededRand);
        for (GridConnection connection : cons) {
            Point from = connection.from;
            Point to = connection.to;
            if (((List)associated.get(from)).contains(to)) continue;
            ((List)associated.get(from)).addAll((Collection)associated.remove(to));
            associated.put(to, (LinkedList<Object>)associated.get(from));
            this.grid.getSegment(from.x, from.y).addConnection(connection.fromToDirection);
            this.grid.getSegment(to.x, to.y).addConnection(connection.fromToDirection.getOpposite());
        }
    }

    private static class GridConnection {
        private final Point from;
        private final Point to;
        private final ForgeDirection fromToDirection;

        private GridConnection(Point from, Point to, ForgeDirection fromToDirection) {
            this.from = from;
            this.to = to;
            this.fromToDirection = fromToDirection;
        }
    }
}

