/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeSegmentNode;
import java.util.ArrayDeque;

public class GraphBacktrackDiscoverer {
    public static ArrayDeque<MazeSegmentNode> getNodePath(MazeSegmentNode fromNode, MazeSegmentNode toNode, int steps) {
        ArrayDeque<MazeSegmentNode> nodePath = new ArrayDeque<MazeSegmentNode>();
        nodePath.push(fromNode);
        nodePath = GraphBacktrackDiscoverer.recDiscoverGraph(nodePath, fromNode, toNode, steps);
        return nodePath;
    }

    private static ArrayDeque<MazeSegmentNode> recDiscoverGraph(ArrayDeque<MazeSegmentNode> nodePath, MazeSegmentNode fromNode, MazeSegmentNode toNode, int steps) {
        boolean containsDirectPath = fromNode.connectionDoors.containsKey(toNode);
        if (steps <= 0 && containsDirectPath) {
            nodePath.push(toNode);
            return nodePath;
        }
        for (MazeSegmentNode next : fromNode.connectionDoors.keySet()) {
            if (nodePath.contains(next)) continue;
            if (next.equals(toNode)) {
                if (steps > 0) continue;
                nodePath.push(next);
                return nodePath;
            }
            ArrayDeque<MazeSegmentNode> nextPath = new ArrayDeque<MazeSegmentNode>(nodePath);
            nextPath.push(next);
            ArrayDeque<MazeSegmentNode> resolvedPath = GraphBacktrackDiscoverer.recDiscoverGraph(nextPath, next, toNode, steps - 1);
            if (resolvedPath == null) continue;
            return resolvedPath;
        }
        if (containsDirectPath) {
            nodePath.push(toNode);
            return nodePath;
        }
        return null;
    }
}

