/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.NonEuclid.BlockTeleport;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Items.Tools.ItemDoorKey;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityTransportWindow;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer1;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer2;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer3;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer4;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer5;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclid.NonEuclidLayer6;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NonEuclideanGenerator
extends DimensionStructureGenerator {
    private final NonEuclidLayer1 layer1 = new NonEuclidLayer1();
    private final NonEuclidLayer2 layer2 = new NonEuclidLayer2();
    private final NonEuclidLayer3 layer3 = new NonEuclidLayer3();
    private final NonEuclidLayer4 layer4 = new NonEuclidLayer4();
    private final NonEuclidLayer5 layer5 = new NonEuclidLayer5();
    private final NonEuclidLayer6 layer6 = new NonEuclidLayer6();
    private UUID door;
    private Coordinate doorLoc;
    private final HashSet<Coordinate> portals = new HashSet();
    private final MultiMap<Coordinate, BlockTeleport.TriggerCriteria> criteria = new MultiMap();
    private final HashMap<Coordinate, HashMap<Coordinate, BlockTeleport.TeleportTriggerAction>> actions = new HashMap();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        Block b = ChromaBlocks.SPECIALSHIELD.getBlockInstance();
        Block b2 = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        this.door = UUID.randomUUID();
        int x = chunkX;
        this.posY = 10 + rand.nextInt(80);
        int z = chunkZ;
        this.entryX = x + 31;
        this.entryZ = z + 64;
        this.layer1.generate(this.world, rand, x, this.posY, z, b, b2);
        this.layer2.generate(this.world, rand, x, this.posY, z, b, b2);
        this.layer3.generate(this.world, rand, x, this.posY, z, b, b2);
        this.layer4.generate(this.world, rand, x, this.posY, z, b, b2);
        this.layer5.generate(this.world, rand, x, this.posY, z, b, b2);
        this.layer6.generate(this.world, rand, x, this.posY, z, b, b2);
        this.generateAir(this.world, rand, x, this.posY, z);
        this.addDynamicStructure(new NonEuclidEntrance(this), this.entryX, this.entryZ);
        this.placeWindow(x + 9, this.posY + 2, z + 44, ForgeDirection.WEST, x + 3, this.posY + 2, z + 52);
        this.placeWindow(x + 3, this.posY + 2, z + 52, ForgeDirection.EAST, x + 9, this.posY + 2, z + 44);
        this.createPortal(x + 39, this.posY + 1, z + 52, ForgeDirection.NORTH, new BlockVector(-16, 0, 8, ForgeDirection.NORTH), new Object[0]);
        this.createPortal(x + 23, this.posY + 1, z + 62, ForgeDirection.SOUTH, new BlockVector(16, 0, -8, ForgeDirection.SOUTH), new Object[0]);
        this.createPortal(x + 31, this.posY + 1, z + 48, ForgeDirection.NORTH, new BlockVector(-8, 0, 12, ForgeDirection.NORTH), new Coordinate(-8, 0, 14), BlockTeleport.DeactivateOneOf.instance, new Coordinate(8, 0, 4), BlockTeleport.DeactivateOneOf.instance);
        BlockTeleport.RerouteIf newLoc1 = new BlockTeleport.RerouteIf(new BlockVector(-2, 0, 12, ForgeDirection.EAST));
        BlockTeleport.RerouteIf newLoc2 = new BlockTeleport.RerouteIf(new BlockVector(-2, 0, 4, ForgeDirection.EAST));
        BlockTeleport.RerouteIf newLoc3 = new BlockTeleport.RerouteIf(new BlockVector(-2, 0, -4, ForgeDirection.EAST));
        this.createPortal(x + 24, this.posY + 1, z + 33, ForgeDirection.WEST, new BlockVector(11, 0, 8, ForgeDirection.EAST), new Coordinate(0, 0, 0), newLoc1, new Coordinate(0, 0, 8), newLoc1, new Coordinate(0, 0, 16), newLoc1);
        this.createPortal(x + 24, this.posY + 1, z + 41, ForgeDirection.WEST, new BlockVector(11, 0, 0, ForgeDirection.EAST), new Coordinate(0, 0, -8), newLoc2, new Coordinate(0, 0, 0), newLoc2, new Coordinate(0, 0, 8), newLoc2);
        this.createPortal(x + 24, this.posY + 1, z + 49, ForgeDirection.WEST, new BlockVector(11, 0, -8, ForgeDirection.EAST), new Coordinate(0, 0, -16), newLoc3, new Coordinate(0, 0, -8), newLoc3, new Coordinate(0, 0, 0), newLoc3);
        this.createPortal(x + 9, this.posY + 1, z + 4, ForgeDirection.NORTH, new BlockVector(12, 0, 0, ForgeDirection.NORTH), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 21, this.posY + 1, z + 6, ForgeDirection.NORTH, new BlockVector(12, 0, -2, ForgeDirection.SOUTH), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 33, this.posY + 1, z + 6, ForgeDirection.SOUTH, new BlockVector(12, 0, -2, ForgeDirection.NORTH), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 45, this.posY + 1, z + 6, ForgeDirection.SOUTH, new BlockVector(-36, 0, 0, ForgeDirection.SOUTH), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 10, this.posY + 1, z + 20, ForgeDirection.EAST, new BlockVector(10, 0, 25, ForgeDirection.WEST), new Object[0]);
        this.createPortal(x + 22, this.posY + 1, z + 20, ForgeDirection.WEST, new BlockVector(-6, 0, 21, ForgeDirection.SOUTH), new Object[0]);
        this.createPortal(x + 16, this.posY + 1, z + 34, ForgeDirection.SOUTH, new BlockVector(14, 0, -7, ForgeDirection.NORTH), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 9, this.posY + 1, z + 12, ForgeDirection.SOUTH, new BlockVector(36, 0, 0, ForgeDirection.SOUTH), new Coordinate(36, 0, 0), BlockTeleport.Deactivate.instance);
        this.createPortal(x + 13, this.posY + 1, z + 16, ForgeDirection.WEST, new BlockVector(8, 0, 37, ForgeDirection.WEST), BlockTeleport.SameFacing.instance);
        this.createPortal(x + 41, this.posY + 1, z + 18, ForgeDirection.NORTH, new BlockVector(-4, 0, 27, ForgeDirection.EAST), new Object[0]);
        this.createPortal(x + 41, this.posY + 1, z + 31, ForgeDirection.SOUTH, new BlockVector(-6, 0, 10, ForgeDirection.EAST), new Object[0]);
        this.createPortal(x + 7, this.posY + 1, z + 35, ForgeDirection.EAST, new BlockVector(24, 0, 13, ForgeDirection.NORTH), new Object[0]);
        this.createPortal(x + 18, this.posY + 1, z + 50, ForgeDirection.NORTH, new BlockVector(-4, 0, 0, ForgeDirection.NORTH), new Object[0]);
        this.createPortal(x + 45, this.posY + 1, z + 12, ForgeDirection.SOUTH, new BlockVector(0, 0, 0, ForgeDirection.SOUTH), new Object[0]);
        this.placeCore(x + 53, this.posY + 2, z + 16);
        this.placeKey(x + 13, this.posY + 1, z + 12, rand);
        this.placeDoor(x + 50, this.posY + 1, z + 16, ForgeDirection.EAST);
        this.createBreakable(x + 52, this.posY + 1, z + 13);
        this.createBreakable(x + 52, this.posY + 1, z + 19);
        this.createBreakable(x + 52, this.posY + 2, z + 13);
        this.createBreakable(x + 52, this.posY + 2, z + 19);
        this.createBreakable(x + 52, this.posY + 3, z + 13);
        this.createBreakable(x + 52, this.posY + 3, z + 19);
        this.createBreakable(x + 53, this.posY + 1, z + 13);
        this.createBreakable(x + 53, this.posY + 1, z + 19);
        this.createBreakable(x + 53, this.posY + 2, z + 13);
        this.createBreakable(x + 53, this.posY + 2, z + 19);
        this.createBreakable(x + 53, this.posY + 3, z + 13);
        this.createBreakable(x + 53, this.posY + 3, z + 19);
        this.createBreakable(x + 54, this.posY + 1, z + 13);
        this.createBreakable(x + 54, this.posY + 1, z + 19);
        this.createBreakable(x + 54, this.posY + 2, z + 13);
        this.createBreakable(x + 54, this.posY + 2, z + 19);
        this.createBreakable(x + 54, this.posY + 3, z + 13);
        this.createBreakable(x + 54, this.posY + 3, z + 19);
        this.createBreakable(x + 56, this.posY + 1, z + 15);
        this.createBreakable(x + 56, this.posY + 1, z + 16);
        this.createBreakable(x + 56, this.posY + 1, z + 17);
        this.createBreakable(x + 56, this.posY + 2, z + 15);
        this.createBreakable(x + 56, this.posY + 2, z + 16);
        this.createBreakable(x + 56, this.posY + 2, z + 17);
        this.createBreakable(x + 56, this.posY + 3, z + 15);
        this.createBreakable(x + 56, this.posY + 3, z + 16);
        this.createBreakable(x + 56, this.posY + 3, z + 17);
    }

    private void generateAir(ChunkSplicedGenerationCache world, Random rand, int x, int posY, int z) {
        HashSet set = world.getLocationsOf(new BlockKey(ChromaBlocks.SPECIALSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata));
        for (Coordinate c : set) {
            for (int i = 1; i <= 3; ++i) {
                int dx = c.xCoord;
                int dy = c.yCoord + i;
                int dz = c.zCoord;
                if (world.hasBlock(dx, dy, dz)) continue;
                world.setBlock(dx, dy, dz, Blocks.field_150350_a);
            }
        }
    }

    private void createBreakable(int x, int y, int z) {
        this.world.setBlock(x, y, z, ChromaBlocks.SPECIALSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        this.addBreakable(x, y, z);
    }

    private void createPortal(int x, int y, int z, ForgeDirection dir, BlockVector bv, Object ... ts) {
        PortalPlace p = new PortalPlace(this.id, dir, bv);
        ArrayList li = ReikaJavaLibrary.makeListFrom((Object[])ts);
        while (!li.isEmpty()) {
            Object o = li.remove(0);
            if (o instanceof BlockTeleport.TriggerCriteria) {
                this.addCriteria(x, y, z, (BlockTeleport.TriggerCriteria)o);
                continue;
            }
            if (!(o instanceof Coordinate)) continue;
            this.addAction(x, y, z, (Coordinate)o, (BlockTeleport.TeleportTriggerAction)li.remove(0));
        }
        this.world.setTileEntity(x, y, z, ChromaBlocks.TELEPORT.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)p);
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        for (int d = -1; d <= 1; ++d) {
            if (d != 0) {
                this.world.setBlock(x + d * left.offsetX, y, z + d * left.offsetZ, ChromaBlocks.TELEPORT.getBlockInstance(), 1);
            }
            this.world.setBlock(x + d * left.offsetX, y + 1, z + d * left.offsetZ, ChromaBlocks.TELEPORT.getBlockInstance(), 1);
            this.world.setBlock(x + d * left.offsetX, y + 2, z + d * left.offsetZ, ChromaBlocks.TELEPORT.getBlockInstance(), 1);
        }
        this.portals.add(new Coordinate(x, y, z));
    }

    private void addCriteria(int x, int y, int z, BlockTeleport.TriggerCriteria c) {
        this.criteria.addValue((Object)new Coordinate(x, y, z), (Object)c);
    }

    private void addAction(int x, int y, int z, Coordinate rel, BlockTeleport.TeleportTriggerAction act) {
        Coordinate loc = new Coordinate(x, y, z);
        HashMap<Object, BlockTeleport.TeleportTriggerAction> map = this.actions.get(loc);
        if (map == null) {
            map = new HashMap();
            this.actions.put(loc, map);
        }
        map.put(rel, act);
    }

    private void placeWindow(int x, int y, int z, ForgeDirection dir, int dx, int dy, int dz) {
        WindowPlace wp = new WindowPlace(dir, new Coordinate(dx, dy, dz));
        this.world.setTileEntity(x, y, z, ChromaTiles.WINDOW.getBlock(), ChromaTiles.WINDOW.getBlockMetadata(), (ChunkSplicedGenerationCache.TileCallback)wp);
    }

    private void placeKey(int x, int y, int z, Random rand) {
        this.world.setTileEntity(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), BlockLootChest.getMeta(ForgeDirection.EAST), (ChunkSplicedGenerationCache.TileCallback)new LootChestCallback(this.door, rand));
    }

    private void placeDoor(int x, int y, int z, ForgeDirection dir) {
        Block b = ChromaBlocks.DOOR.getBlockInstance();
        DoorCallback doorCallback = new DoorCallback(this.door);
        int m = BlockChromaDoor.getMetadata(false, false, true, true);
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        for (int d = -1; d <= 1; ++d) {
            this.world.setTileEntity(x + d * left.offsetX, y, z + d * left.offsetZ, b, m, (ChunkSplicedGenerationCache.TileCallback)doorCallback);
            this.world.setTileEntity(x + d * left.offsetX, y + 1, z + d * left.offsetZ, b, m, (ChunkSplicedGenerationCache.TileCallback)doorCallback);
            this.world.setTileEntity(x + d * left.offsetX, y + 2, z + d * left.offsetZ, b, m, (ChunkSplicedGenerationCache.TileCallback)doorCallback);
        }
        this.doorLoc = new Coordinate(x, y, z);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected void clearCaches() {
        this.door = null;
        this.doorLoc = null;
        this.portals.clear();
        this.criteria.clear();
        this.actions.clear();
    }

    public Collection<Coordinate> getPortalLocations() {
        return Collections.unmodifiableSet(this.portals);
    }

    public HashMap<Coordinate, BlockTeleport.TeleportTriggerAction> getActions(int x, int y, int z) {
        return this.actions.get(new Coordinate(x, y, z));
    }

    public void removeAction(int x, int y, int z, Coordinate rel) {
        HashMap<Coordinate, BlockTeleport.TeleportTriggerAction> map = this.actions.get(new Coordinate(x, y, z));
        if (map != null) {
            map.remove(rel);
        }
    }

    public Collection<BlockTeleport.TriggerCriteria> getCriteria(int x, int y, int z) {
        return this.criteria.get((Object)new Coordinate(x, y, z));
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return BlockChromaDoor.isOpen((IBlockAccess)world, this.doorLoc.xCoord, this.doorLoc.yCoord, this.doorLoc.zCoord);
    }

    private static class DoorCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;

        private DoorCallback(UUID id) {
            this.uid = id;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockChromaDoor.TileEntityChromaDoor) {
                ((BlockChromaDoor.TileEntityChromaDoor)te).bindUUID(null, this.uid, 0);
            }
        }
    }

    private static class LootChestCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final Random rand;

        private LootChestCallback(UUID id, Random r) {
            this.uid = id;
            this.rand = r;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockLootChest.TileEntityLootChest) {
                BlockLootChest.TileEntityLootChest tc = (BlockLootChest.TileEntityLootChest)te;
                ItemStack key = ChromaItems.KEY.getStackOf();
                ((ItemDoorKey)ChromaItems.KEY.getItemInstance()).setID(key, this.uid);
                tc.func_70299_a(this.rand.nextInt(tc.func_70302_i_()), key);
            }
        }
    }

    private static class PortalPlace
    implements ChunkSplicedGenerationCache.TileCallback {
        private final BlockVector location;
        private final ForgeDirection direction;
        private final UUID id;

        private PortalPlace(UUID uid, ForgeDirection dir, BlockVector bv) {
            this.id = uid;
            this.location = bv;
            this.direction = dir;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockTeleport.TileEntityTeleport) {
                BlockTeleport.TileEntityTeleport tp = (BlockTeleport.TileEntityTeleport)te;
                tp.destination = this.location;
                tp.facing = this.direction;
                tp.uid = this.id;
            }
        }
    }

    private static class WindowPlace
    implements ChunkSplicedGenerationCache.TileCallback {
        private final ForgeDirection direction;
        private final Coordinate other;

        private WindowPlace(ForgeDirection dir, Coordinate c) {
            this.direction = dir;
            this.other = c;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof TileEntityTransportWindow) {
                TileEntity te2;
                ((TileEntityTransportWindow)te).setFacing(this.direction);
                ((TileEntityTransportWindow)te).renderBackPane = false;
                ((TileEntityTransportWindow)te).renderTexture = false;
                ((TileEntityTransportWindow)te).setUnmineable(true);
                if (this.other.getBlock(world) != ChromaTiles.WINDOW.getBlock() || this.other.getBlockMetadata(world) != ChromaTiles.WINDOW.getBlockMetadata()) {
                    this.other.setBlock(world, ChromaTiles.WINDOW.getBlock(), ChromaTiles.WINDOW.getBlockMetadata());
                }
                if ((te2 = this.other.getTileEntity(world)) instanceof TileEntityTransportWindow) {
                    ((TileEntityTransportWindow)te).linkTo((TileEntityTransportWindow)te2);
                }
            }
        }
    }
}

