/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.DataStorage.MusicStructureData;
import Reika.ChromatiCraft.World.Dimension.Structure.Music.MusicEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.Music.MusicLoot;
import Reika.ChromatiCraft.World.Dimension.Structure.Music.MusicPuzzle;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class MusicPuzzleGenerator
extends DimensionStructureGenerator {
    private static final int LENGTH = 4 + 2 * ChromaOptions.getStructureDifficulty();
    private static final ArrayList<MelodyPrefab> prefabs = new ArrayList();
    private final ArrayList<MusicPuzzle> puzzles = new ArrayList();
    private HashSet<MelodyPrefab> usedPrefabs = new HashSet();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        this.generatePuzzles(rand);
        this.posY = 20 + rand.nextInt(80);
        int x = chunkX;
        int z = chunkZ;
        int y = this.posY;
        this.addDynamicStructure(new MusicEntrance(this), x, z);
        z += 3;
        for (MusicPuzzle p : this.puzzles) {
            p.generate(this.world, x, y, z);
            z += 20;
        }
        new MusicLoot(this).generate(this.world, x, y, z);
    }

    private void generatePuzzles(Random rand) {
        for (int i = 0; i < LENGTH; ++i) {
            int len = this.getPuzzleLength(i);
            MusicPuzzle m = new MusicPuzzle(this, len, i);
            MelodyPrefab p = null;
            if (this.usedPrefabs.size() < prefabs.size() && rand.nextInt(5) == 0) {
                p = this.getRandomPrefab(rand, len * 5 / 2);
            }
            if (p != null) {
                m.loadPrefab(p);
                this.usedPrefabs.add(p);
            } else {
                m.initialize(rand);
            }
            this.puzzles.add(m);
        }
    }

    private int getPuzzleLength(int step) {
        return Math.max(6, 2 * ChromaOptions.getStructureDifficulty() + (step - 9 + ChromaOptions.getStructureDifficulty()));
    }

    private MelodyPrefab getRandomPrefab(Random rand, int maxlen) {
        HashSet<MelodyPrefab> validPrefabs = new HashSet<MelodyPrefab>(prefabs);
        validPrefabs.removeAll(this.usedPrefabs);
        Iterator<MelodyPrefab> it = validPrefabs.iterator();
        while (it.hasNext()) {
            MelodyPrefab pre = it.next();
            if (pre.notes.size() <= maxlen) continue;
            it.remove();
        }
        return validPrefabs.isEmpty() ? null : (MelodyPrefab)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, validPrefabs);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    protected void clearCaches() {
        this.puzzles.clear();
        this.usedPrefabs.clear();
    }

    @Override
    public StructureData createDataStorage() {
        return new MusicStructureData(this);
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (MusicPuzzle m : this.puzzles) {
            if (m.isSolved) continue;
            return false;
        }
        return true;
    }

    private static void addPrefabMelody(ReikaMusicHelper.MusicKey ... notes) {
        ArrayList li = ReikaJavaLibrary.makeListFrom((Object[])notes);
        int shift = MusicPuzzleGenerator.verify(li);
        if (shift > 0) {
            for (int i = 0; i < li.size(); ++i) {
                li.set(i, ((ReikaMusicHelper.MusicKey)li.get(i)).getInterval(shift));
            }
        }
        prefabs.add(new MelodyPrefab(li));
    }

    private static int verify(ArrayList<ReikaMusicHelper.MusicKey> li) {
        boolean flag;
        int d;
        for (d = 0; d < 12; ++d) {
            flag = true;
            for (ReikaMusicHelper.MusicKey key : li) {
                if ((d == 0 || key.getInterval(d) != key) && CrystalMusicManager.instance.canPlayKey(key.getInterval(d))) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return d;
        }
        for (d = -1; d > -12; --d) {
            flag = true;
            for (ReikaMusicHelper.MusicKey key : li) {
                if ((d == 0 || key.getInterval(d) != key) && CrystalMusicManager.instance.canPlayKey(key.getInterval(d))) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return d;
        }
        throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Invalid prefab melody!");
    }

    public void completePuzzle(int structureIndex) {
        this.puzzles.get((int)structureIndex).isSolved = true;
    }

    static {
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.G4);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.C6, ReikaMusicHelper.MusicKey.C6, ReikaMusicHelper.MusicKey.E6, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.G6, ReikaMusicHelper.MusicKey.Fs6, ReikaMusicHelper.MusicKey.G6, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.C6, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.E6, ReikaMusicHelper.MusicKey.D6, ReikaMusicHelper.MusicKey.C6, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.Fs5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.D5);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.Cs5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.F5);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.Cs5, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.Cs5, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.Fs5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.Cs5);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.Fs5);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.D4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.D4, ReikaMusicHelper.MusicKey.Bb4, ReikaMusicHelper.MusicKey.D4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.Bb4, ReikaMusicHelper.MusicKey.Eb4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.Eb4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.Eb4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.D4);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.Ab4, ReikaMusicHelper.MusicKey.Bb4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.Ab4, ReikaMusicHelper.MusicKey.Bb4, ReikaMusicHelper.MusicKey.F4);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.Eb6, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.Eb6, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Eb6, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Ab5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.E6, ReikaMusicHelper.MusicKey.Fs5, ReikaMusicHelper.MusicKey.E6, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.B5, ReikaMusicHelper.MusicKey.Fs5, ReikaMusicHelper.MusicKey.Bb5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.Cs6, ReikaMusicHelper.MusicKey.B5);
        MusicPuzzleGenerator.addPrefabMelody(ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.Bb5, ReikaMusicHelper.MusicKey.Eb5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.A5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.G5);
    }

    public static final class MelodyPrefab {
        private final ArrayList<ReikaMusicHelper.MusicKey> notes;
        public final CrystalElement center;
        public final ReikaMusicHelper.KeySignature key;

        private MelodyPrefab(ArrayList<ReikaMusicHelper.MusicKey> li) {
            this.notes = li;
            this.key = ReikaMusicHelper.KeySignature.findSignature(li);
            this.center = this.key != null ? CrystalMusicManager.instance.getColorForKeySignature(this.key) : null;
        }

        public List<ReikaMusicHelper.MusicKey> getNotes() {
            return Collections.unmodifiableList(this.notes);
        }

        public int hashCode() {
            return this.notes.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MelodyPrefab && ((MelodyPrefab)o).notes.equals(this.notes);
        }
    }
}

