/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.LockLevel;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockColoredLock;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockLockKey;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LockRoomConnector;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksLoot;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LocksGenerator
extends DimensionStructureGenerator {
    private final ArrayList<LockLevel> genOrder = new ArrayList();
    private int[][] keyCodes = new int[BlockLockKey.LockChannel.lockList.length][16];
    private int[] gateCodes = new int[BlockLockKey.LockChannel.lockList.length];
    private int[] whiteLock = new int[BlockLockKey.LockChannel.lockList.length];
    private HashSet<Coordinate> lockCache = new HashSet();

    @Override
    public void calculate(int x, int z, Random rand) {
        this.posY = 40;
        this.resetColorCaches();
        ForgeDirection dir = ForgeDirection.SOUTH;
        this.genMaps(rand, dir);
        int len = 4 + rand.nextInt(8);
        int radius = 6 + rand.nextInt(5);
        this.addDynamicStructure(new LocksEntrance(this, dir, radius, len), x, z);
        int len2 = 4 + rand.nextInt(6);
        int d = radius + 3 + len;
        new LockRoomConnector(this, 0, 0, 0, 0).setLength(dir, len2).setOpenCeiling().generate(this.world, x += d * dir.offsetX, this.posY, z += d * dir.offsetZ);
        Coordinate c = this.genRooms(x += (len2 + 3) * dir.offsetX, this.posY, z += (len2 + 3) * dir.offsetZ, dir, rand);
        new LocksLoot(this).generate(this.world, c.xCoord - dir.offsetZ * 4 + dir.offsetX * 6, c.yCoord, c.zCoord - dir.offsetX * 4 + dir.offsetZ * 6);
    }

    private Coordinate genRooms(int x, int y, int z, ForgeDirection dir, Random rand) {
        int dx = x;
        int dy = y;
        int dz = z;
        ForgeDirection dir2 = dir;
        ForgeDirection turn = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        int n = this.genOrder.size();
        for (int i = 0; i < n; ++i) {
            LockLevel l = this.genOrder.get(i);
            LockLevel prev = i > 0 ? this.genOrder.get(i - 1) : null;
            LockLevel next = i < n - 1 ? this.genOrder.get(i + 1) : null;
            int d1 = l.getInitialOffset();
            l.generate(this.world, dx + turn.offsetX * d1, dy, dz + turn.offsetZ * d1);
            int out = 2 + rand.nextInt(3);
            int dx2 = (dx += l.getEnterExitDL() * dir.offsetX + l.getEnterExitDT() * turn.offsetX) + (2 + out) * dir2.offsetX;
            int dz2 = (dz += l.getEnterExitDL() * dir.offsetZ + l.getEnterExitDT() * turn.offsetZ) + (2 + out) * dir2.offsetZ;
            int d = 0;
            dx2 += turn.offsetX * d;
            dz2 += turn.offsetZ * d;
            dx += dir2.offsetX * (5 + out * 2);
            dz += dir2.offsetZ * (5 + out * 2);
            LockRoomConnector con = new LockRoomConnector(this, 0, 0, 0, 0);
            con.setLength(dir, out);
            con.setLength(dir.getOpposite(), out);
            if (next == null) {
                con.setLength(dir, out * 3);
                dx += dir.offsetX * out * 3;
                dz += dir.offsetZ * out * 3;
            }
            con.generate(this.world, dx2, dy, dz2);
        }
        return new Coordinate(dx, dy, dz);
    }

    private void genMaps(Random rand, ForgeDirection dir) {
        for (int i = 0; i < BlockLockKey.LockChannel.lockList.length; ++i) {
            LockLevel l = this.genNewLockLevel(i, rand);
            if (!l.canGenerate()) continue;
            l.setDirection(dir);
            this.genOrder.add(l);
        }
        Collections.shuffle(this.genOrder);
        Collections.sort(this.genOrder);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    public final int getNumberGates(int i) {
        return BlockLockKey.LockChannel.lockList[i].numberKeys;
    }

    @Override
    protected void clearCaches() {
        this.genOrder.clear();
        this.lockCache.clear();
        this.resetColorCaches();
    }

    private void resetColorCaches() {
        int n = BlockLockKey.LockChannel.lockList.length;
        this.keyCodes = new int[n][16];
        for (int i = 0; i < n; ++i) {
            this.gateCodes[i] = this.getNumberGates(i);
        }
        this.whiteLock = new int[n];
    }

    private LockLevel genNewLockLevel(int i, Random rand) {
        try {
            BlockLockKey.LockChannel ch = BlockLockKey.LockChannel.lockList[i];
            LockLevel l = ch.genRoom(this);
            l.permute(rand);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not instantiate lock level " + i + "!");
        }
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    public void markOpenGate(World world, int structIndex) {
        int n = structIndex;
        this.gateCodes[n] = this.gateCodes[n] - 1;
        this.genOrder.get((int)structIndex).isSolved = this.isGateOpen(structIndex);
        this.updateTiles(world, -1);
    }

    public void markClosedGate(World world, int structIndex) {
        int n = structIndex;
        this.gateCodes[n] = this.gateCodes[n] + 1;
        this.genOrder.get((int)structIndex).isSolved = false;
        this.updateTiles(world, -1);
    }

    public boolean isOpen(CrystalElement e, int structIndex) {
        return this.keyCodes[structIndex][e.ordinal()] > 0 || this.whiteLock[structIndex] > 0;
    }

    public boolean isGateOpen(int structIndex) {
        return this.gateCodes[structIndex] == 0;
    }

    public void openColor(CrystalElement e, World world, int structIndex) {
        if (e == CrystalElement.WHITE) {
            int n = structIndex;
            this.whiteLock[n] = this.whiteLock[n] + 1;
        } else {
            int[] nArray = this.keyCodes[structIndex];
            int n = e.ordinal();
            nArray[n] = nArray[n] + 1;
        }
        this.updateTiles(world, -1);
    }

    public void closeColor(CrystalElement e, World world, int structIndex) {
        if (e == CrystalElement.WHITE) {
            int n = structIndex;
            this.whiteLock[n] = this.whiteLock[n] - 1;
        } else {
            int[] nArray = this.keyCodes[structIndex];
            int n = e.ordinal();
            nArray[n] = nArray[n] - 1;
        }
        this.updateTiles(world, -1);
    }

    public int getWhiteLock(int channel) {
        return this.whiteLock[channel];
    }

    public int getColorCode(int channel, CrystalElement e) {
        return this.keyCodes[channel][e.ordinal()];
    }

    public int getGateCode(int channel) {
        return this.gateCodes[channel];
    }

    public void freezeLocks(World world, int structIndex, int time) {
        this.updateTiles(world, time);
    }

    private void updateTiles(World world, int time) {
        for (Coordinate loc : this.lockCache) {
            BlockColoredLock.TileEntityColorLock te = (BlockColoredLock.TileEntityColorLock)loc.getTileEntity(world);
            if (te == null) {
                ChromatiCraft.logger.logError((Object)("Colored lock @ " + loc + " in DIM" + world.field_73011_w.field_76574_g + " has no TileEntity!!"));
                Block b = loc.getBlock(world);
                ReikaJavaLibrary.pConsole((Object)("Present block ID: " + Block.func_149682_b((Block)b) + " = " + b.getClass()));
                continue;
            }
            if (time >= 0) {
                te.queueTick(time);
                continue;
            }
            te.recalc();
        }
    }

    public void addLock(int x, int y, int z) {
        this.lockCache.add(new Coordinate(x, y, z));
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (LockLevel l : this.genOrder) {
            if (l.isSolved) continue;
            return false;
        }
        return true;
    }
}

