/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.GOL.BlockGOLController;
import Reika.ChromatiCraft.Block.Dimension.Structure.GOL.BlockGOLTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.GOL.GOLDoors;
import Reika.ChromatiCraft.World.Dimension.Structure.GOL.GOLEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.GOL.GOLLoot;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GOLGenerator
extends DimensionStructureGenerator {
    public static final int MAX_ALLOWED = GOLGenerator.getSize() * 4;
    public static final int ROOM_HEIGHT = 12;
    public static final int SIZE = GOLGenerator.getSize();
    protected int floorY;
    private ArrayList<Coordinate> initialActive = new ArrayList();
    private Coordinate door;
    private boolean solved = false;

    private static int getSize() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 12;
            }
            case 2: {
                return 16;
            }
        }
        return 24;
    }

    @Override
    protected void calculate(int x, int z, Random rand) {
        this.posY = 30 + rand.nextInt(40);
        this.floorY = this.posY + 1;
        for (int i = -SIZE; i <= SIZE; ++i) {
            for (int k = -SIZE; k <= SIZE; ++k) {
                int dx = x + i;
                int dz = z + k;
                this.placeTile(dx, dz, false);
                for (int h = 1; h < 12; ++h) {
                    this.world.setBlock(dx, this.floorY + h, dz, Blocks.field_150350_a);
                }
                this.world.setBlock(dx, this.floorY - 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
                this.world.setBlock(dx, this.floorY + 12 + 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            }
        }
        for (int k = -1; k <= 13; ++k) {
            for (int i = -SIZE - 1; i <= SIZE + 1; ++i) {
                int m = Math.abs(k % 8) == Math.abs(i % 8) ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.CLOAK.metadata;
                this.world.setBlock(x + i, this.floorY + k, z - SIZE - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                this.world.setBlock(x + i, this.floorY + k, z + SIZE + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                this.world.setBlock(x - SIZE - 1, this.floorY + k, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                this.world.setBlock(x + SIZE + 1, this.floorY + k, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
            }
        }
        this.world.setTileEntity(this.posX - SIZE - 3, this.floorY + 1, this.posZ, ChromaBlocks.GOLCONTROL.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new GOLTileCallback(this, false));
        new GOLDoors(this).generate(this.world, x, this.floorY + 1, z - 8);
        new GOLLoot(this).generate(this.world, x + SIZE + 1 + 1, this.floorY - 1, z - 3);
        this.addDynamicStructure(new GOLEntrance(this), x - SIZE - 1 - 8, z - 8);
        this.door = new Coordinate(x + SIZE + 1, this.floorY + 1, z);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    protected final void placeTile(int x, int z, boolean startOn) {
        this.world.setTileEntity(x, this.floorY, z, ChromaBlocks.GOL.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new GOLTileCallback(this, startOn));
        this.world.setBlock(x, this.floorY + 12, z, ChromaBlocks.GOL.getBlockInstance(), 2);
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    public void deactivateTile(World world, int x, int y, int z) {
        Coordinate c = new Coordinate(x, y, z);
        this.initialActive.remove(c);
    }

    public boolean activateTile(World world, int x, int y, int z) {
        if (this.initialActive.size() >= MAX_ALLOWED) {
            return false;
        }
        Coordinate c = new Coordinate(x, y, z);
        this.initialActive.add(c);
        return true;
    }

    @Override
    protected void clearCaches() {
        this.initialActive.clear();
        this.door = null;
        this.solved = false;
    }

    public void clearTiles() {
        this.initialActive.clear();
    }

    public void checkConditions(World world) {
        int num = 0;
        int tot = 0;
        for (int i = -SIZE; i <= SIZE; ++i) {
            for (int k = -SIZE; k <= SIZE; ++k) {
                int dx = this.posX + i;
                int dz = this.posZ + k;
                Coordinate c = new Coordinate(dx, this.floorY + 12, dz);
                if (c.getBlock(world) != ChromaBlocks.GOL.getBlockInstance()) continue;
                if (c.getBlockMetadata(world) == 3) {
                    ++num;
                }
                ++tot;
            }
        }
        float f = 1.0f;
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                f = 0.8f;
                break;
            }
            case 2: {
                f = 0.875f;
                break;
            }
            case 3: {
                f = 0.925f;
            }
        }
        int min = (int)((float)((SIZE * 2 + 1) * (SIZE * 2 + 1)) * f);
        if (num >= min) {
            TileEntity te = this.door.getTileEntity(world);
            if (te instanceof BlockChromaDoor.TileEntityChromaDoor) {
                ((BlockChromaDoor.TileEntityChromaDoor)te).open(-1);
            }
            ChromaSounds.CAST.playSoundAtBlock(world, this.door.xCoord - SIZE * 2 - 3, this.door.yCoord, this.door.zCoord, 2.0f, 1.0f);
            this.solved = true;
        } else {
            ChromaSounds.ERROR.playSoundAtBlock(world, this.door.xCoord - SIZE * 2 - 3, this.door.yCoord, this.door.zCoord, 2.0f, 1.0f);
        }
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return this.solved;
    }

    private static class GOLTileCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final boolean initOn;
        private final GOLGenerator generator;

        private GOLTileCallback(GOLGenerator gen, boolean on) {
            this.initOn = on;
            this.generator = gen;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockGOLTile.GOLTile) {
                ((BlockGOLTile.GOLTile)te).initialize(this.initOn);
                ((BlockGOLTile.GOLTile)te).uid = this.generator.id;
            }
            if (te instanceof BlockGOLController.GOLController) {
                ((BlockGOLController.GOLController)te).initialize(this.generator.posX - SIZE, this.generator.posX + SIZE, this.generator.posZ - SIZE, this.generator.posZ + SIZE, this.generator.floorY);
                ((BlockGOLController.GOLController)te).uid = this.generator.id;
            }
        }
    }
}

