/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Dimension.Structure.Bridge.BlockDynamicBridge;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.Bridge.BridgeEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.Bridge.BridgeEntryPlatform;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BridgeGenerator
extends DimensionStructureGenerator {
    private final CountMap<UUID> totalSwitches = new CountMap();
    private final CountMap<UUID> activeSwitches = new CountMap();
    private final HashMap<UUID, ControlType> modes = new HashMap();
    private final MultiMap<UUID, Coordinate> bridgeLocations = new MultiMap();
    private static final int SIZE = BridgeGenerator.getSize();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        this.posY = 30 + rand.nextInt(40);
        int x = chunkX;
        int z = chunkZ;
        int y = this.posY;
        for (int i = -SIZE; i <= SIZE; ++i) {
            for (int j = -SIZE; j <= SIZE; ++j) {
                for (int k = -SIZE; k <= SIZE; ++k) {
                    if (!ReikaMathLibrary.isPointInsidePowerEllipse((double)i, (double)j, (double)k, (double)SIZE, (double)((double)SIZE / 4.0), (double)((double)SIZE / 2.0), (double)1.5)) continue;
                    if (ReikaMathLibrary.isPointInsidePowerEllipse((double)i, (double)j, (double)k, (double)((double)SIZE - 1.5), (double)((double)SIZE / 4.0 - 1.5), (double)((double)SIZE / 2.0 - 1.5), (double)1.5)) {
                        this.world.setBlock(x + i, y + j, z + k, j < -1 ? Blocks.field_150355_j : Blocks.field_150350_a);
                        continue;
                    }
                    this.world.setBlock(x + i, y + j, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
                }
            }
        }
        new BridgeEntryPlatform(this).connect(ForgeDirection.EAST).generate(this.world, x, y, z);
        this.addDynamicStructure(new BridgeEntrance(this), x, z);
    }

    private static int getSize() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
        }
        return 64;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return false;
    }

    public boolean isKeyActive(UUID uid) {
        return this.modes.get(uid).compare(this.activeSwitches.get((Object)uid), this.totalSwitches.get((Object)uid));
    }

    @Override
    protected void clearCaches() {
        this.totalSwitches.clear();
        this.activeSwitches.clear();
        this.modes.clear();
        this.bridgeLocations.clear();
    }

    public void addBridge(Coordinate c, UUID ... uids) {
        for (int i = 0; i < uids.length; ++i) {
            this.bridgeLocations.addValue((Object)uids[i], (Object)c);
        }
    }

    public void addKey(UUID uid) {
        this.totalSwitches.increment((Object)uid);
    }

    @Override
    public void tickPlayer(EntityPlayer ep) {
        while (!ep.field_70122_E && !ep.func_70072_I()) {
            ep.func_70091_d(0.0, (double)-0.05f, 0.0);
        }
    }

    public void updateControl(World world, UUID id, boolean active) {
        this.activeSwitches.increment((Object)id, active ? 1 : -1);
        for (Coordinate c : this.bridgeLocations.get((Object)id)) {
            BlockDynamicBridge.TileDynamicBridge te = (BlockDynamicBridge.TileDynamicBridge)c.getTileEntity(world);
            if (te == null) continue;
            te.checkState();
        }
    }

    public static enum ControlType {
        AND,
        OR,
        XOR;


        public boolean compare(int num, int total) {
            switch (this) {
                case AND: {
                    return num == total;
                }
                case OR: {
                    return num > 0;
                }
                case XOR: {
                    return num == 1;
                }
            }
            return false;
        }
    }
}

