/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Bridge;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.BridgeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class BridgeNode
extends StructurePiece {
    protected final boolean[] connections = new boolean[4];
    protected final int radius;

    public BridgeNode(BridgeGenerator s, int r) {
        super(s);
        this.radius = r;
    }

    public BridgeNode connect(ForgeDirection dir) {
        this.connections[dir.ordinal() - 2] = true;
        return this;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int i;
        for (i = -this.radius; i <= this.radius; ++i) {
            for (int k = -this.radius; k <= this.radius; ++k) {
                world.setBlock(x + i, y, z + k, Blocks.field_150344_f);
                if (Math.abs(i) != this.radius && Math.abs(k) != this.radius) continue;
                world.setBlock(x + i, y + 1, z + k, Blocks.field_150422_aJ);
            }
        }
        for (i = 0; i < 4; ++i) {
            if (!this.connections[i]) continue;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i + 2];
            for (int k = -1; k <= 1; ++k) {
                int dx = x + dir.offsetX * this.radius + k * dir.offsetZ;
                int dz = z + dir.offsetZ * this.radius + k * dir.offsetX;
                world.setBlock(dx, y, dz, ChromaBlocks.BRIDGE.getBlockInstance());
                world.setBlock(dx, y + 1, dz, Blocks.field_150350_a);
            }
        }
        for (i = -this.radius; i <= this.radius; i += this.radius * 2) {
            for (int k = -this.radius; k <= this.radius; k += this.radius * 2) {
                boolean flag = true;
                for (int h = 2; flag || h >= -1; --h) {
                    BlockKey bk = world.getBlock(x, y + h, z);
                    boolean bl = flag = bk == null || bk.blockID == Blocks.field_150355_j || bk.blockID == Blocks.field_150350_a;
                    if (!flag && h < -1) continue;
                    world.setBlock(x + i, y + h, z + k, Blocks.field_150344_f);
                }
                world.setBlock(x + i, y + 3, z + k, Blocks.field_150478_aa, 5);
            }
        }
    }
}

