/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarm.AntFarmEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarm.AntFarmLevel;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarm.AntFarmTunnel;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class AntFarmGenerator
extends DimensionStructureGenerator {
    public static final float LIGHT_DURATION = 1024.0f;
    private final HashSet<Coordinate> airSpaces = new HashSet();
    private final HashSet<Coordinate> tunnelSpaces = new HashSet();
    private final HashSet<Coordinate> levelSpaces = new HashSet();
    private final LinkedList<AntFarmLevel> levels = new LinkedList();
    private final ArrayList<AntFarmTunnel> tunnels = new ArrayList();
    private final HashMap<Coordinate, BlockKey> blocks = new HashMap();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        int h = 90;
        int mh = 20;
        int dhy = 10;
        for (int y = mh; y <= mh + h; y += dhy) {
            double a = Math.toRadians(360.0 * (double)(y - mh) / (double)h);
            double dr = ReikaRandomHelper.getRandomBetween((double)48.0, (double)96.0);
            int x = chunkX + MathHelper.func_76128_c((double)(dr * Math.cos(a)));
            int z = chunkZ + MathHelper.func_76128_c((double)(dr * Math.sin(a)));
            AntFarmLevel pre = this.levels.isEmpty() ? null : this.levels.getLast();
            int lh = 4;
            int lr = 8;
            AntFarmLevel l = new AntFarmLevel(this, x, y, z, lr, lh);
            l.register(this, this.levelSpaces);
            this.levels.addLast(l);
            if (pre == null) continue;
            AntFarmTunnel t = this.createTunnel(pre.posX, pre.posY, pre.posZ, x, y, z, 3, 2, rand);
            while (t.intersectsWith(this.tunnelSpaces, this.levelSpaces)) {
                t = this.createTunnel(pre.posX, pre.posY, pre.posZ, x, y, z, 3, 2, rand);
            }
            t.register(this, this.tunnelSpaces);
            this.tunnels.add(t);
        }
        for (AntFarmLevel l : this.levels) {
            int n = 1;
            for (int i = 0; i < n; ++i) {
                int z;
                int dz;
                int y;
                int dy;
                double ang = Math.toRadians(rand.nextDouble() * 360.0);
                double slope = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)45.0);
                double len = ReikaRandomHelper.getRandomBetween((double)12.0, (double)64.0);
                double[] d = ReikaPhysicsHelper.polarToCartesian((double)len, (double)slope, (double)ang);
                int x = MathHelper.func_76128_c((double)d[0]);
                int dx = l.posX + x;
                AntFarmTunnel t = this.createTunnel(l.posX, l.posY, l.posZ, dx, dy = l.posY + (y = MathHelper.func_76128_c((double)d[1])), dz = l.posZ + (z = MathHelper.func_76128_c((double)d[2])), 3, 3, rand);
                if (t.intersectsWith(this.tunnelSpaces, this.levelSpaces)) {
                    // empty if block
                }
                t.register(this, this.tunnelSpaces);
                this.tunnels.add(t);
            }
        }
        for (Coordinate c : this.blocks.keySet()) {
            BlockKey bk = this.blocks.get(c);
            this.world.setBlock(c.xCoord, c.yCoord, c.zCoord, bk.blockID, bk.metadata);
        }
        this.addDynamicStructure(new AntFarmEntrance(this, mh + h), chunkX, chunkZ);
    }

    private AntFarmTunnel createTunnel(int x, int y, int z, int x2, int y2, int z2, int w, int c, Random rand) {
        return new AntFarmTunnel(this, new Coordinate(x, y, z), new Coordinate(x2, y2, z2), c, w);
    }

    private int getRoomsPerLevel(Random rand) {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return rand.nextInt(6) == 0 ? 2 : 1;
            }
            case 2: {
                return rand.nextInt(2) == 0 ? 2 : 1;
            }
        }
        return rand.nextInt(3) == 0 ? 3 : (rand.nextInt(4) > 0 ? 2 : 1);
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return false;
    }

    @Override
    protected void clearCaches() {
        this.levels.clear();
        this.tunnels.clear();
        this.blocks.clear();
        this.airSpaces.clear();
        this.tunnelSpaces.clear();
        this.levelSpaces.clear();
    }

    public void cutBlock(Coordinate c, boolean air) {
        BlockKey b;
        BlockKey blockKey = b = air ? new BlockKey(Blocks.field_150350_a) : new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        if (this.airSpaces.contains(c)) {
            b = new BlockKey(Blocks.field_150350_a);
        }
        this.blocks.put(c, b);
        if (b.blockID == Blocks.field_150350_a) {
            this.airSpaces.add(c);
        }
    }
}

