/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.AntFarm;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarmGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.MathHelper;

public class AntFarmTunnel
extends StructurePiece {
    public final Coordinate point1;
    public final Coordinate point2;
    public final int tunnelRadius;
    public final int curvature;
    private final HashMap<Coordinate, Boolean> blocks = new HashMap();

    public AntFarmTunnel(AntFarmGenerator a, Coordinate c1, Coordinate c2, int curve, int r) {
        super(a);
        this.point1 = c1;
        this.point2 = c2;
        this.curvature = curve;
        this.tunnelRadius = r;
        this.initialize();
    }

    private void initialize() {
        DecimalPosition d1 = new DecimalPosition(this.point1);
        DecimalPosition d2 = new DecimalPosition(this.point2);
        LightningBolt b = new LightningBolt(d1, d2, this.curvature);
        double len = d1.getDistanceTo(d2);
        b.variance = Math.min(6.0, len / 8.0);
        b.velocity = b.variance * 2.0;
        b.update();
        Spline s = new Spline(Spline.SplineType.CHORDAL);
        for (int i = 0; i <= b.nsteps; ++i) {
            s.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(b.getPosition(i)));
        }
        List li = s.get((int)(4.0 * len), false);
        for (DecimalPosition p : li) {
            this.generateTunnelSection(MathHelper.func_76128_c((double)p.xCoord), MathHelper.func_76128_c((double)p.yCoord), MathHelper.func_76128_c((double)p.zCoord), this.tunnelRadius);
        }
    }

    private void generateTunnelSection(int dx, int dy, int dz, int r) {
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    Coordinate c;
                    double dd = ReikaMathLibrary.py3d((double)i, (double)j, (double)k);
                    if (!(dd <= (double)r + 0.5)) continue;
                    int ddx = dx + i;
                    int ddy = dy + j;
                    int ddz = dz + k;
                    Boolean pre = this.blocks.get(c = new Coordinate(ddx, ddy, ddz));
                    this.blocks.put(c, pre != null && pre != false || dd <= (double)r - 0.5);
                }
            }
        }
    }

    public void register(AntFarmGenerator g, HashSet<Coordinate> tunnelSpaces) {
        for (Coordinate c : this.blocks.keySet()) {
            g.cutBlock(c, this.blocks.get(c));
        }
        tunnelSpaces.addAll(this.blocks.keySet());
    }

    public boolean intersectsWith(HashSet<Coordinate> tunnelSpaces, HashSet<Coordinate> levelSpaces) {
        for (Coordinate c : this.blocks.keySet()) {
            if (!tunnelSpaces.contains(c) || levelSpaces.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
    }
}

